/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomPluginResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<DescribeCustomPluginResponse.Builder, DescribeCustomPluginResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(DescribeCustomPluginResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginArn").getter(getter(DescribeCustomPluginResponse::customPluginArn))
            .setter(setter(Builder::customPluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginArn").build()).build();

    private static final SdkField<String> CUSTOM_PLUGIN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginState").getter(getter(DescribeCustomPluginResponse::customPluginStateAsString))
            .setter(setter(Builder::customPluginState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeCustomPluginResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CustomPluginRevisionSummary> LATEST_REVISION_FIELD = SdkField
            .<CustomPluginRevisionSummary> builder(MarshallingType.SDK_POJO).memberName("latestRevision")
            .getter(getter(DescribeCustomPluginResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(CustomPluginRevisionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeCustomPluginResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<StateDescription> STATE_DESCRIPTION_FIELD = SdkField
            .<StateDescription> builder(MarshallingType.SDK_POJO).memberName("stateDescription")
            .getter(getter(DescribeCustomPluginResponse::stateDescription)).setter(setter(Builder::stateDescription))
            .constructor(StateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            CUSTOM_PLUGIN_ARN_FIELD, CUSTOM_PLUGIN_STATE_FIELD, DESCRIPTION_FIELD, LATEST_REVISION_FIELD, NAME_FIELD,
            STATE_DESCRIPTION_FIELD));

    private final Instant creationTime;

    private final String customPluginArn;

    private final String customPluginState;

    private final String description;

    private final CustomPluginRevisionSummary latestRevision;

    private final String name;

    private final StateDescription stateDescription;

    private DescribeCustomPluginResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.customPluginArn = builder.customPluginArn;
        this.customPluginState = builder.customPluginState;
        this.description = builder.description;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.stateDescription = builder.stateDescription;
    }

    /**
     * <p>
     * The time that the custom plugin was created.
     * </p>
     * 
     * @return The time that the custom plugin was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom plugin.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom plugin.
     */
    public final String customPluginArn() {
        return customPluginArn;
    }

    /**
     * <p>
     * The state of the custom plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customPluginState}
     * will return {@link CustomPluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customPluginStateAsString}.
     * </p>
     * 
     * @return The state of the custom plugin.
     * @see CustomPluginState
     */
    public final CustomPluginState customPluginState() {
        return CustomPluginState.fromValue(customPluginState);
    }

    /**
     * <p>
     * The state of the custom plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customPluginState}
     * will return {@link CustomPluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customPluginStateAsString}.
     * </p>
     * 
     * @return The state of the custom plugin.
     * @see CustomPluginState
     */
    public final String customPluginStateAsString() {
        return customPluginState;
    }

    /**
     * <p>
     * The description of the custom plugin.
     * </p>
     * 
     * @return The description of the custom plugin.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The latest successfully created revision of the custom plugin. If there are no successfully created revisions,
     * this field will be absent.
     * </p>
     * 
     * @return The latest successfully created revision of the custom plugin. If there are no successfully created
     *         revisions, this field will be absent.
     */
    public final CustomPluginRevisionSummary latestRevision() {
        return latestRevision;
    }

    /**
     * <p>
     * The name of the custom plugin.
     * </p>
     * 
     * @return The name of the custom plugin.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Details about the state of a custom plugin.
     * </p>
     * 
     * @return Details about the state of a custom plugin.
     */
    public final StateDescription stateDescription() {
        return stateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomPluginResponse)) {
            return false;
        }
        DescribeCustomPluginResponse other = (DescribeCustomPluginResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(customPluginArn(), other.customPluginArn())
                && Objects.equals(customPluginStateAsString(), other.customPluginStateAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(latestRevision(), other.latestRevision())
                && Objects.equals(name(), other.name()) && Objects.equals(stateDescription(), other.stateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomPluginResponse").add("CreationTime", creationTime())
                .add("CustomPluginArn", customPluginArn()).add("CustomPluginState", customPluginStateAsString())
                .add("Description", description()).add("LatestRevision", latestRevision()).add("Name", name())
                .add("StateDescription", stateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "customPluginArn":
            return Optional.ofNullable(clazz.cast(customPluginArn()));
        case "customPluginState":
            return Optional.ofNullable(clazz.cast(customPluginStateAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "latestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "stateDescription":
            return Optional.ofNullable(clazz.cast(stateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomPluginResponse, T> g) {
        return obj -> g.apply((DescribeCustomPluginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomPluginResponse> {
        /**
         * <p>
         * The time that the custom plugin was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the custom plugin was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom plugin.
         * </p>
         * 
         * @param customPluginArn
         *        The Amazon Resource Name (ARN) of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginArn(String customPluginArn);

        /**
         * <p>
         * The state of the custom plugin.
         * </p>
         * 
         * @param customPluginState
         *        The state of the custom plugin.
         * @see CustomPluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginState
         */
        Builder customPluginState(String customPluginState);

        /**
         * <p>
         * The state of the custom plugin.
         * </p>
         * 
         * @param customPluginState
         *        The state of the custom plugin.
         * @see CustomPluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginState
         */
        Builder customPluginState(CustomPluginState customPluginState);

        /**
         * <p>
         * The description of the custom plugin.
         * </p>
         * 
         * @param description
         *        The description of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The latest successfully created revision of the custom plugin. If there are no successfully created
         * revisions, this field will be absent.
         * </p>
         * 
         * @param latestRevision
         *        The latest successfully created revision of the custom plugin. If there are no successfully created
         *        revisions, this field will be absent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(CustomPluginRevisionSummary latestRevision);

        /**
         * <p>
         * The latest successfully created revision of the custom plugin. If there are no successfully created
         * revisions, this field will be absent.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPluginRevisionSummary.Builder}
         * avoiding the need to create one manually via {@link CustomPluginRevisionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomPluginRevisionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #latestRevision(CustomPluginRevisionSummary)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link CustomPluginRevisionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(CustomPluginRevisionSummary)
         */
        default Builder latestRevision(Consumer<CustomPluginRevisionSummary.Builder> latestRevision) {
            return latestRevision(CustomPluginRevisionSummary.builder().applyMutation(latestRevision).build());
        }

        /**
         * <p>
         * The name of the custom plugin.
         * </p>
         * 
         * @param name
         *        The name of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Details about the state of a custom plugin.
         * </p>
         * 
         * @param stateDescription
         *        Details about the state of a custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateDescription(StateDescription stateDescription);

        /**
         * <p>
         * Details about the state of a custom plugin.
         * </p>
         * This is a convenience method that creates an instance of the {@link StateDescription.Builder} avoiding the
         * need to create one manually via {@link StateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #stateDescription(StateDescription)}.
         * 
         * @param stateDescription
         *        a consumer that will call methods on {@link StateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateDescription(StateDescription)
         */
        default Builder stateDescription(Consumer<StateDescription.Builder> stateDescription) {
            return stateDescription(StateDescription.builder().applyMutation(stateDescription).build());
        }
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String customPluginArn;

        private String customPluginState;

        private String description;

        private CustomPluginRevisionSummary latestRevision;

        private String name;

        private StateDescription stateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomPluginResponse model) {
            super(model);
            creationTime(model.creationTime);
            customPluginArn(model.customPluginArn);
            customPluginState(model.customPluginState);
            description(model.description);
            latestRevision(model.latestRevision);
            name(model.name);
            stateDescription(model.stateDescription);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCustomPluginArn() {
            return customPluginArn;
        }

        public final void setCustomPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
        }

        @Override
        public final Builder customPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
            return this;
        }

        public final String getCustomPluginState() {
            return customPluginState;
        }

        public final void setCustomPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
        }

        @Override
        public final Builder customPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
            return this;
        }

        @Override
        public final Builder customPluginState(CustomPluginState customPluginState) {
            this.customPluginState(customPluginState == null ? null : customPluginState.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CustomPluginRevisionSummary.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(CustomPluginRevisionSummary.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(CustomPluginRevisionSummary latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StateDescription.Builder getStateDescription() {
            return stateDescription != null ? stateDescription.toBuilder() : null;
        }

        public final void setStateDescription(StateDescription.BuilderImpl stateDescription) {
            this.stateDescription = stateDescription != null ? stateDescription.build() : null;
        }

        @Override
        public final Builder stateDescription(StateDescription stateDescription) {
            this.stateDescription = stateDescription;
            return this;
        }

        @Override
        public DescribeCustomPluginResponse build() {
            return new DescribeCustomPluginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
