/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkerConfigurationResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<DescribeWorkerConfigurationResponse.Builder, DescribeWorkerConfigurationResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(DescribeWorkerConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeWorkerConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<WorkerConfigurationRevisionDescription> LATEST_REVISION_FIELD = SdkField
            .<WorkerConfigurationRevisionDescription> builder(MarshallingType.SDK_POJO).memberName("latestRevision")
            .getter(getter(DescribeWorkerConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(WorkerConfigurationRevisionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeWorkerConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationArn").getter(getter(DescribeWorkerConfigurationResponse::workerConfigurationArn))
            .setter(setter(Builder::workerConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DESCRIPTION_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, WORKER_CONFIGURATION_ARN_FIELD));

    private final Instant creationTime;

    private final String description;

    private final WorkerConfigurationRevisionDescription latestRevision;

    private final String name;

    private final String workerConfigurationArn;

    private DescribeWorkerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.workerConfigurationArn = builder.workerConfigurationArn;
    }

    /**
     * <p>
     * The time that the worker configuration was created.
     * </p>
     * 
     * @return The time that the worker configuration was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the worker configuration.
     * </p>
     * 
     * @return The description of the worker configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The latest revision of the custom configuration.
     * </p>
     * 
     * @return The latest revision of the custom configuration.
     */
    public final WorkerConfigurationRevisionDescription latestRevision() {
        return latestRevision;
    }

    /**
     * <p>
     * The name of the worker configuration.
     * </p>
     * 
     * @return The name of the worker configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom configuration.
     */
    public final String workerConfigurationArn() {
        return workerConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkerConfigurationResponse)) {
            return false;
        }
        DescribeWorkerConfigurationResponse other = (DescribeWorkerConfigurationResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(latestRevision(), other.latestRevision()) && Objects.equals(name(), other.name())
                && Objects.equals(workerConfigurationArn(), other.workerConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkerConfigurationResponse").add("CreationTime", creationTime())
                .add("Description", description()).add("LatestRevision", latestRevision()).add("Name", name())
                .add("WorkerConfigurationArn", workerConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "latestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "workerConfigurationArn":
            return Optional.ofNullable(clazz.cast(workerConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkerConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeWorkerConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWorkerConfigurationResponse> {
        /**
         * <p>
         * The time that the worker configuration was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the worker configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the worker configuration.
         * </p>
         * 
         * @param description
         *        The description of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The latest revision of the custom configuration.
         * </p>
         * 
         * @param latestRevision
         *        The latest revision of the custom configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(WorkerConfigurationRevisionDescription latestRevision);

        /**
         * <p>
         * The latest revision of the custom configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkerConfigurationRevisionDescription.Builder} avoiding the need to create one manually via
         * {@link WorkerConfigurationRevisionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link WorkerConfigurationRevisionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #latestRevision(WorkerConfigurationRevisionDescription)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link WorkerConfigurationRevisionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(WorkerConfigurationRevisionDescription)
         */
        default Builder latestRevision(Consumer<WorkerConfigurationRevisionDescription.Builder> latestRevision) {
            return latestRevision(WorkerConfigurationRevisionDescription.builder().applyMutation(latestRevision).build());
        }

        /**
         * <p>
         * The name of the worker configuration.
         * </p>
         * 
         * @param name
         *        The name of the worker configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom configuration.
         * </p>
         * 
         * @param workerConfigurationArn
         *        The Amazon Resource Name (ARN) of the custom configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurationArn(String workerConfigurationArn);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String description;

        private WorkerConfigurationRevisionDescription latestRevision;

        private String name;

        private String workerConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkerConfigurationResponse model) {
            super(model);
            creationTime(model.creationTime);
            description(model.description);
            latestRevision(model.latestRevision);
            name(model.name);
            workerConfigurationArn(model.workerConfigurationArn);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkerConfigurationRevisionDescription.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(WorkerConfigurationRevisionDescription.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(WorkerConfigurationRevisionDescription latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkerConfigurationArn() {
            return workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        @Override
        public DescribeWorkerConfigurationResponse build() {
            return new DescribeWorkerConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
