/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomPluginsResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<ListCustomPluginsResponse.Builder, ListCustomPluginsResponse> {
    private static final SdkField<List<CustomPluginSummary>> CUSTOM_PLUGINS_FIELD = SdkField
            .<List<CustomPluginSummary>> builder(MarshallingType.LIST)
            .memberName("customPlugins")
            .getter(getter(ListCustomPluginsResponse::customPlugins))
            .setter(setter(Builder::customPlugins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPlugins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomPluginSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomPluginSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomPluginsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_PLUGINS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CustomPluginSummary> customPlugins;

    private final String nextToken;

    private ListCustomPluginsResponse(BuilderImpl builder) {
        super(builder);
        this.customPlugins = builder.customPlugins;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomPlugins property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomPlugins() {
        return customPlugins != null && !(customPlugins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of custom plugin descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomPlugins} method.
     * </p>
     * 
     * @return An array of custom plugin descriptions.
     */
    public final List<CustomPluginSummary> customPlugins() {
        return customPlugins;
    }

    /**
     * <p>
     * If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this NextToken
     * in a subsequent request to continue listing from where the previous operation left off.
     * </p>
     * 
     * @return If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this
     *         NextToken in a subsequent request to continue listing from where the previous operation left off.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomPlugins() ? customPlugins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomPluginsResponse)) {
            return false;
        }
        ListCustomPluginsResponse other = (ListCustomPluginsResponse) obj;
        return hasCustomPlugins() == other.hasCustomPlugins() && Objects.equals(customPlugins(), other.customPlugins())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomPluginsResponse").add("CustomPlugins", hasCustomPlugins() ? customPlugins() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customPlugins":
            return Optional.ofNullable(clazz.cast(customPlugins()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomPluginsResponse, T> g) {
        return obj -> g.apply((ListCustomPluginsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCustomPluginsResponse> {
        /**
         * <p>
         * An array of custom plugin descriptions.
         * </p>
         * 
         * @param customPlugins
         *        An array of custom plugin descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPlugins(Collection<CustomPluginSummary> customPlugins);

        /**
         * <p>
         * An array of custom plugin descriptions.
         * </p>
         * 
         * @param customPlugins
         *        An array of custom plugin descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPlugins(CustomPluginSummary... customPlugins);

        /**
         * <p>
         * An array of custom plugin descriptions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CustomPluginSummary>.Builder}
         * avoiding the need to create one manually via {@link List<CustomPluginSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomPluginSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #customPlugins(List<CustomPluginSummary>)}.
         * 
         * @param customPlugins
         *        a consumer that will call methods on {@link List<CustomPluginSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPlugins(List<CustomPluginSummary>)
         */
        Builder customPlugins(Consumer<CustomPluginSummary.Builder>... customPlugins);

        /**
         * <p>
         * If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this
         * NextToken in a subsequent request to continue listing from where the previous operation left off.
         * </p>
         * 
         * @param nextToken
         *        If the response of a ListCustomPlugins operation is truncated, it will include a NextToken. Send this
         *        NextToken in a subsequent request to continue listing from where the previous operation left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private List<CustomPluginSummary> customPlugins = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomPluginsResponse model) {
            super(model);
            customPlugins(model.customPlugins);
            nextToken(model.nextToken);
        }

        public final List<CustomPluginSummary.Builder> getCustomPlugins() {
            List<CustomPluginSummary.Builder> result = ___listOfCustomPluginSummaryCopier.copyToBuilder(this.customPlugins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomPlugins(Collection<CustomPluginSummary.BuilderImpl> customPlugins) {
            this.customPlugins = ___listOfCustomPluginSummaryCopier.copyFromBuilder(customPlugins);
        }

        @Override
        public final Builder customPlugins(Collection<CustomPluginSummary> customPlugins) {
            this.customPlugins = ___listOfCustomPluginSummaryCopier.copy(customPlugins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customPlugins(CustomPluginSummary... customPlugins) {
            customPlugins(Arrays.asList(customPlugins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customPlugins(Consumer<CustomPluginSummary.Builder>... customPlugins) {
            customPlugins(Stream.of(customPlugins).map(c -> CustomPluginSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomPluginsResponse build() {
            return new ListCustomPluginsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
