/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kafkaconnect.DefaultKafkaConnectBaseClientBuilder;
import software.amazon.awssdk.services.kafkaconnect.DefaultKafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClient;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectClientBuilder;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.kafkaconnect.endpoints.KafkaConnectEndpointProvider;

@SdkInternalApi
final class DefaultKafkaConnectClientBuilder
extends DefaultKafkaConnectBaseClientBuilder<KafkaConnectClientBuilder, KafkaConnectClient>
implements KafkaConnectClientBuilder {
    DefaultKafkaConnectClientBuilder() {
    }

    @Override
    public DefaultKafkaConnectClientBuilder endpointProvider(KafkaConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KafkaConnectClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKafkaConnectClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        KafkaConnectServiceClientConfiguration serviceClientConfiguration = KafkaConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultKafkaConnectClient(serviceClientConfiguration, clientConfiguration);
    }
}

