/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWorkerConfigurationResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<DeleteWorkerConfigurationResponse.Builder, DeleteWorkerConfigurationResponse> {
    private static final SdkField<String> WORKER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationArn").getter(getter(DeleteWorkerConfigurationResponse::workerConfigurationArn))
            .setter(setter(Builder::workerConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationArn").build())
            .build();

    private static final SdkField<String> WORKER_CONFIGURATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerConfigurationState")
            .getter(getter(DeleteWorkerConfigurationResponse::workerConfigurationStateAsString))
            .setter(setter(Builder::workerConfigurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurationState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WORKER_CONFIGURATION_ARN_FIELD, WORKER_CONFIGURATION_STATE_FIELD));

    private final String workerConfigurationArn;

    private final String workerConfigurationState;

    private DeleteWorkerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.workerConfigurationArn = builder.workerConfigurationArn;
        this.workerConfigurationState = builder.workerConfigurationState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the worker configuration that you requested to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the worker configuration that you requested to delete.
     */
    public final String workerConfigurationArn() {
        return workerConfigurationArn;
    }

    /**
     * <p>
     * The state of the worker configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workerConfigurationState} will return {@link WorkerConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #workerConfigurationStateAsString}.
     * </p>
     * 
     * @return The state of the worker configuration.
     * @see WorkerConfigurationState
     */
    public final WorkerConfigurationState workerConfigurationState() {
        return WorkerConfigurationState.fromValue(workerConfigurationState);
    }

    /**
     * <p>
     * The state of the worker configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workerConfigurationState} will return {@link WorkerConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #workerConfigurationStateAsString}.
     * </p>
     * 
     * @return The state of the worker configuration.
     * @see WorkerConfigurationState
     */
    public final String workerConfigurationStateAsString() {
        return workerConfigurationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(workerConfigurationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkerConfigurationResponse)) {
            return false;
        }
        DeleteWorkerConfigurationResponse other = (DeleteWorkerConfigurationResponse) obj;
        return Objects.equals(workerConfigurationArn(), other.workerConfigurationArn())
                && Objects.equals(workerConfigurationStateAsString(), other.workerConfigurationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWorkerConfigurationResponse").add("WorkerConfigurationArn", workerConfigurationArn())
                .add("WorkerConfigurationState", workerConfigurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workerConfigurationArn":
            return Optional.ofNullable(clazz.cast(workerConfigurationArn()));
        case "workerConfigurationState":
            return Optional.ofNullable(clazz.cast(workerConfigurationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkerConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteWorkerConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteWorkerConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the worker configuration that you requested to delete.
         * </p>
         * 
         * @param workerConfigurationArn
         *        The Amazon Resource Name (ARN) of the worker configuration that you requested to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurationArn(String workerConfigurationArn);

        /**
         * <p>
         * The state of the worker configuration.
         * </p>
         * 
         * @param workerConfigurationState
         *        The state of the worker configuration.
         * @see WorkerConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerConfigurationState
         */
        Builder workerConfigurationState(String workerConfigurationState);

        /**
         * <p>
         * The state of the worker configuration.
         * </p>
         * 
         * @param workerConfigurationState
         *        The state of the worker configuration.
         * @see WorkerConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerConfigurationState
         */
        Builder workerConfigurationState(WorkerConfigurationState workerConfigurationState);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private String workerConfigurationArn;

        private String workerConfigurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkerConfigurationResponse model) {
            super(model);
            workerConfigurationArn(model.workerConfigurationArn);
            workerConfigurationState(model.workerConfigurationState);
        }

        public final String getWorkerConfigurationArn() {
            return workerConfigurationArn;
        }

        public final void setWorkerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
        }

        @Override
        public final Builder workerConfigurationArn(String workerConfigurationArn) {
            this.workerConfigurationArn = workerConfigurationArn;
            return this;
        }

        public final String getWorkerConfigurationState() {
            return workerConfigurationState;
        }

        public final void setWorkerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
        }

        @Override
        public final Builder workerConfigurationState(String workerConfigurationState) {
            this.workerConfigurationState = workerConfigurationState;
            return this;
        }

        @Override
        public final Builder workerConfigurationState(WorkerConfigurationState workerConfigurationState) {
            this.workerConfigurationState(workerConfigurationState == null ? null : workerConfigurationState.toString());
            return this;
        }

        @Override
        public DeleteWorkerConfigurationResponse build() {
            return new DeleteWorkerConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
