/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate;
import software.amazon.awssdk.services.kafkaconnect.model.ProvisionedCapacityUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityUpdate> {
    private static final SdkField<AutoScalingUpdate> AUTO_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoScaling").getter(CapacityUpdate.getter(CapacityUpdate::autoScaling)).setter(CapacityUpdate.setter(Builder::autoScaling)).constructor(AutoScalingUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()}).build();
    private static final SdkField<ProvisionedCapacityUpdate> PROVISIONED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisionedCapacity").getter(CapacityUpdate.getter(CapacityUpdate::provisionedCapacity)).setter(CapacityUpdate.setter(Builder::provisionedCapacity)).constructor(ProvisionedCapacityUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_FIELD, PROVISIONED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("autoScaling", AUTO_SCALING_FIELD);
            this.put("provisionedCapacity", PROVISIONED_CAPACITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AutoScalingUpdate autoScaling;
    private final ProvisionedCapacityUpdate provisionedCapacity;

    private CapacityUpdate(BuilderImpl builder) {
        this.autoScaling = builder.autoScaling;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    public final AutoScalingUpdate autoScaling() {
        return this.autoScaling;
    }

    public final ProvisionedCapacityUpdate provisionedCapacity() {
        return this.provisionedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityUpdate)) {
            return false;
        }
        CapacityUpdate other = (CapacityUpdate)obj;
        return Objects.equals(this.autoScaling(), other.autoScaling()) && Objects.equals(this.provisionedCapacity(), other.provisionedCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityUpdate").add("AutoScaling", (Object)this.autoScaling()).add("ProvisionedCapacity", (Object)this.provisionedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScaling": {
                return Optional.ofNullable(clazz.cast(this.autoScaling()));
            }
            case "provisionedCapacity": {
                return Optional.ofNullable(clazz.cast(this.provisionedCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CapacityUpdate, T> g) {
        return obj -> g.apply((CapacityUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoScalingUpdate autoScaling;
        private ProvisionedCapacityUpdate provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityUpdate model) {
            this.autoScaling(model.autoScaling);
            this.provisionedCapacity(model.provisionedCapacity);
        }

        public final AutoScalingUpdate.Builder getAutoScaling() {
            return this.autoScaling != null ? this.autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(AutoScalingUpdate.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(AutoScalingUpdate autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final ProvisionedCapacityUpdate.Builder getProvisionedCapacity() {
            return this.provisionedCapacity != null ? this.provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacityUpdate.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        public final Builder provisionedCapacity(ProvisionedCapacityUpdate provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        public CapacityUpdate build() {
            return new CapacityUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityUpdate> {
        public Builder autoScaling(AutoScalingUpdate var1);

        default public Builder autoScaling(Consumer<AutoScalingUpdate.Builder> autoScaling) {
            return this.autoScaling((AutoScalingUpdate)((AutoScalingUpdate.Builder)AutoScalingUpdate.builder().applyMutation(autoScaling)).build());
        }

        public Builder provisionedCapacity(ProvisionedCapacityUpdate var1);

        default public Builder provisionedCapacity(Consumer<ProvisionedCapacityUpdate.Builder> provisionedCapacity) {
            return this.provisionedCapacity((ProvisionedCapacityUpdate)((ProvisionedCapacityUpdate.Builder)ProvisionedCapacityUpdate.builder().applyMutation(provisionedCapacity)).build());
        }
    }
}

