/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a step that is involved in a connector's operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorOperationStep implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorOperationStep.Builder, ConnectorOperationStep> {
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepType").getter(getter(ConnectorOperationStep::stepTypeAsString)).setter(setter(Builder::stepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepType").build()).build();

    private static final SdkField<String> STEP_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepState").getter(getter(ConnectorOperationStep::stepStateAsString)).setter(setter(Builder::stepState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TYPE_FIELD,
            STEP_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepType;

    private final String stepState;

    private ConnectorOperationStep(BuilderImpl builder) {
        this.stepType = builder.stepType;
        this.stepState = builder.stepState;
    }

    /**
     * <p>
     * The step type of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link ConnectorOperationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return The step type of the operation.
     * @see ConnectorOperationStepType
     */
    public final ConnectorOperationStepType stepType() {
        return ConnectorOperationStepType.fromValue(stepType);
    }

    /**
     * <p>
     * The step type of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link ConnectorOperationStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stepTypeAsString}.
     * </p>
     * 
     * @return The step type of the operation.
     * @see ConnectorOperationStepType
     */
    public final String stepTypeAsString() {
        return stepType;
    }

    /**
     * <p>
     * The step state of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepState} will
     * return {@link ConnectorOperationStepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stepStateAsString}.
     * </p>
     * 
     * @return The step state of the operation.
     * @see ConnectorOperationStepState
     */
    public final ConnectorOperationStepState stepState() {
        return ConnectorOperationStepState.fromValue(stepState);
    }

    /**
     * <p>
     * The step state of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepState} will
     * return {@link ConnectorOperationStepState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stepStateAsString}.
     * </p>
     * 
     * @return The step state of the operation.
     * @see ConnectorOperationStepState
     */
    public final String stepStateAsString() {
        return stepState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stepStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperationStep)) {
            return false;
        }
        ConnectorOperationStep other = (ConnectorOperationStep) obj;
        return Objects.equals(stepTypeAsString(), other.stepTypeAsString())
                && Objects.equals(stepStateAsString(), other.stepStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorOperationStep").add("StepType", stepTypeAsString())
                .add("StepState", stepStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepType":
            return Optional.ofNullable(clazz.cast(stepTypeAsString()));
        case "stepState":
            return Optional.ofNullable(clazz.cast(stepStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepType", STEP_TYPE_FIELD);
        map.put("stepState", STEP_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperationStep, T> g) {
        return obj -> g.apply((ConnectorOperationStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorOperationStep> {
        /**
         * <p>
         * The step type of the operation.
         * </p>
         * 
         * @param stepType
         *        The step type of the operation.
         * @see ConnectorOperationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationStepType
         */
        Builder stepType(String stepType);

        /**
         * <p>
         * The step type of the operation.
         * </p>
         * 
         * @param stepType
         *        The step type of the operation.
         * @see ConnectorOperationStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationStepType
         */
        Builder stepType(ConnectorOperationStepType stepType);

        /**
         * <p>
         * The step state of the operation.
         * </p>
         * 
         * @param stepState
         *        The step state of the operation.
         * @see ConnectorOperationStepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationStepState
         */
        Builder stepState(String stepState);

        /**
         * <p>
         * The step state of the operation.
         * </p>
         * 
         * @param stepState
         *        The step state of the operation.
         * @see ConnectorOperationStepState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationStepState
         */
        Builder stepState(ConnectorOperationStepState stepState);
    }

    static final class BuilderImpl implements Builder {
        private String stepType;

        private String stepState;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperationStep model) {
            stepType(model.stepType);
            stepState(model.stepState);
        }

        public final String getStepType() {
            return stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(ConnectorOperationStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getStepState() {
            return stepState;
        }

        public final void setStepState(String stepState) {
            this.stepState = stepState;
        }

        @Override
        public final Builder stepState(String stepState) {
            this.stepState = stepState;
            return this;
        }

        @Override
        public final Builder stepState(ConnectorOperationStepState stepState) {
            this.stepState(stepState == null ? null : stepState.toString());
            return this;
        }

        @Override
        public ConnectorOperationStep build() {
            return new ConnectorOperationStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
