/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of a connector operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorOperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorOperationSummary.Builder, ConnectorOperationSummary> {
    private static final SdkField<String> CONNECTOR_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationArn").getter(getter(ConnectorOperationSummary::connectorOperationArn))
            .setter(setter(Builder::connectorOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationArn").build())
            .build();

    private static final SdkField<String> CONNECTOR_OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationType").getter(getter(ConnectorOperationSummary::connectorOperationTypeAsString))
            .setter(setter(Builder::connectorOperationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationType").build())
            .build();

    private static final SdkField<String> CONNECTOR_OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorOperationState").getter(getter(ConnectorOperationSummary::connectorOperationStateAsString))
            .setter(setter(Builder::connectorOperationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationState").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ConnectorOperationSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ConnectorOperationSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_OPERATION_ARN_FIELD,
            CONNECTOR_OPERATION_TYPE_FIELD, CONNECTOR_OPERATION_STATE_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectorOperationArn;

    private final String connectorOperationType;

    private final String connectorOperationState;

    private final Instant creationTime;

    private final Instant endTime;

    private ConnectorOperationSummary(BuilderImpl builder) {
        this.connectorOperationArn = builder.connectorOperationArn;
        this.connectorOperationType = builder.connectorOperationType;
        this.connectorOperationState = builder.connectorOperationState;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connector operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connector operation.
     */
    public final String connectorOperationArn() {
        return connectorOperationArn;
    }

    /**
     * <p>
     * The type of connector operation performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationType} will return {@link ConnectorOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #connectorOperationTypeAsString}.
     * </p>
     * 
     * @return The type of connector operation performed.
     * @see ConnectorOperationType
     */
    public final ConnectorOperationType connectorOperationType() {
        return ConnectorOperationType.fromValue(connectorOperationType);
    }

    /**
     * <p>
     * The type of connector operation performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationType} will return {@link ConnectorOperationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #connectorOperationTypeAsString}.
     * </p>
     * 
     * @return The type of connector operation performed.
     * @see ConnectorOperationType
     */
    public final String connectorOperationTypeAsString() {
        return connectorOperationType;
    }

    /**
     * <p>
     * The state of the connector operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationState} will return {@link ConnectorOperationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorOperationStateAsString}.
     * </p>
     * 
     * @return The state of the connector operation.
     * @see ConnectorOperationState
     */
    public final ConnectorOperationState connectorOperationState() {
        return ConnectorOperationState.fromValue(connectorOperationState);
    }

    /**
     * <p>
     * The state of the connector operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectorOperationState} will return {@link ConnectorOperationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #connectorOperationStateAsString}.
     * </p>
     * 
     * @return The state of the connector operation.
     * @see ConnectorOperationState
     */
    public final String connectorOperationStateAsString() {
        return connectorOperationState;
    }

    /**
     * <p>
     * The time when operation was created.
     * </p>
     * 
     * @return The time when operation was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when operation ended.
     * </p>
     * 
     * @return The time when operation ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperationSummary)) {
            return false;
        }
        ConnectorOperationSummary other = (ConnectorOperationSummary) obj;
        return Objects.equals(connectorOperationArn(), other.connectorOperationArn())
                && Objects.equals(connectorOperationTypeAsString(), other.connectorOperationTypeAsString())
                && Objects.equals(connectorOperationStateAsString(), other.connectorOperationStateAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorOperationSummary").add("ConnectorOperationArn", connectorOperationArn())
                .add("ConnectorOperationType", connectorOperationTypeAsString())
                .add("ConnectorOperationState", connectorOperationStateAsString()).add("CreationTime", creationTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorOperationArn":
            return Optional.ofNullable(clazz.cast(connectorOperationArn()));
        case "connectorOperationType":
            return Optional.ofNullable(clazz.cast(connectorOperationTypeAsString()));
        case "connectorOperationState":
            return Optional.ofNullable(clazz.cast(connectorOperationStateAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorOperationArn", CONNECTOR_OPERATION_ARN_FIELD);
        map.put("connectorOperationType", CONNECTOR_OPERATION_TYPE_FIELD);
        map.put("connectorOperationState", CONNECTOR_OPERATION_STATE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperationSummary, T> g) {
        return obj -> g.apply((ConnectorOperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorOperationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connector operation.
         * </p>
         * 
         * @param connectorOperationArn
         *        The Amazon Resource Name (ARN) of the connector operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOperationArn(String connectorOperationArn);

        /**
         * <p>
         * The type of connector operation performed.
         * </p>
         * 
         * @param connectorOperationType
         *        The type of connector operation performed.
         * @see ConnectorOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationType
         */
        Builder connectorOperationType(String connectorOperationType);

        /**
         * <p>
         * The type of connector operation performed.
         * </p>
         * 
         * @param connectorOperationType
         *        The type of connector operation performed.
         * @see ConnectorOperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationType
         */
        Builder connectorOperationType(ConnectorOperationType connectorOperationType);

        /**
         * <p>
         * The state of the connector operation.
         * </p>
         * 
         * @param connectorOperationState
         *        The state of the connector operation.
         * @see ConnectorOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationState
         */
        Builder connectorOperationState(String connectorOperationState);

        /**
         * <p>
         * The state of the connector operation.
         * </p>
         * 
         * @param connectorOperationState
         *        The state of the connector operation.
         * @see ConnectorOperationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorOperationState
         */
        Builder connectorOperationState(ConnectorOperationState connectorOperationState);

        /**
         * <p>
         * The time when operation was created.
         * </p>
         * 
         * @param creationTime
         *        The time when operation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when operation ended.
         * </p>
         * 
         * @param endTime
         *        The time when operation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String connectorOperationArn;

        private String connectorOperationType;

        private String connectorOperationState;

        private Instant creationTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperationSummary model) {
            connectorOperationArn(model.connectorOperationArn);
            connectorOperationType(model.connectorOperationType);
            connectorOperationState(model.connectorOperationState);
            creationTime(model.creationTime);
            endTime(model.endTime);
        }

        public final String getConnectorOperationArn() {
            return connectorOperationArn;
        }

        public final void setConnectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
        }

        @Override
        public final Builder connectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
            return this;
        }

        public final String getConnectorOperationType() {
            return connectorOperationType;
        }

        public final void setConnectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
        }

        @Override
        public final Builder connectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
            return this;
        }

        @Override
        public final Builder connectorOperationType(ConnectorOperationType connectorOperationType) {
            this.connectorOperationType(connectorOperationType == null ? null : connectorOperationType.toString());
            return this;
        }

        public final String getConnectorOperationState() {
            return connectorOperationState;
        }

        public final void setConnectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
        }

        @Override
        public final Builder connectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
            return this;
        }

        @Override
        public final Builder connectorOperationState(ConnectorOperationState connectorOperationState) {
            this.connectorOperationState(connectorOperationState == null ? null : connectorOperationState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ConnectorOperationSummary build() {
            return new ConnectorOperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
