/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<CreateConnectorResponse.Builder, CreateConnectorResponse> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorArn").getter(getter(CreateConnectorResponse::connectorArn))
            .setter(setter(Builder::connectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorArn").build()).build();

    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorName").getter(getter(CreateConnectorResponse::connectorName))
            .setter(setter(Builder::connectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()).build();

    private static final SdkField<String> CONNECTOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorState").getter(getter(CreateConnectorResponse::connectorStateAsString))
            .setter(setter(Builder::connectorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD,
            CONNECTOR_NAME_FIELD, CONNECTOR_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectorArn;

    private final String connectorName;

    private final String connectorState;

    private CreateConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorName = builder.connectorName;
        this.connectorState = builder.connectorState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon assigned to the connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon assigned to the connector.
     */
    public final String connectorArn() {
        return connectorArn;
    }

    /**
     * <p>
     * The name of the connector.
     * </p>
     * 
     * @return The name of the connector.
     */
    public final String connectorName() {
        return connectorName;
    }

    /**
     * <p>
     * The state of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorState}
     * will return {@link ConnectorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStateAsString}.
     * </p>
     * 
     * @return The state of the connector.
     * @see ConnectorState
     */
    public final ConnectorState connectorState() {
        return ConnectorState.fromValue(connectorState);
    }

    /**
     * <p>
     * The state of the connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorState}
     * will return {@link ConnectorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectorStateAsString}.
     * </p>
     * 
     * @return The state of the connector.
     * @see ConnectorState
     */
    public final String connectorStateAsString() {
        return connectorState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorResponse)) {
            return false;
        }
        CreateConnectorResponse other = (CreateConnectorResponse) obj;
        return Objects.equals(connectorArn(), other.connectorArn()) && Objects.equals(connectorName(), other.connectorName())
                && Objects.equals(connectorStateAsString(), other.connectorStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorResponse").add("ConnectorArn", connectorArn())
                .add("ConnectorName", connectorName()).add("ConnectorState", connectorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorArn":
            return Optional.ofNullable(clazz.cast(connectorArn()));
        case "connectorName":
            return Optional.ofNullable(clazz.cast(connectorName()));
        case "connectorState":
            return Optional.ofNullable(clazz.cast(connectorStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorArn", CONNECTOR_ARN_FIELD);
        map.put("connectorName", CONNECTOR_NAME_FIELD);
        map.put("connectorState", CONNECTOR_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorResponse, T> g) {
        return obj -> g.apply((CreateConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon assigned to the connector.
         * </p>
         * 
         * @param connectorArn
         *        The Amazon Resource Name (ARN) that Amazon assigned to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorArn(String connectorArn);

        /**
         * <p>
         * The name of the connector.
         * </p>
         * 
         * @param connectorName
         *        The name of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorName(String connectorName);

        /**
         * <p>
         * The state of the connector.
         * </p>
         * 
         * @param connectorState
         *        The state of the connector.
         * @see ConnectorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorState
         */
        Builder connectorState(String connectorState);

        /**
         * <p>
         * The state of the connector.
         * </p>
         * 
         * @param connectorState
         *        The state of the connector.
         * @see ConnectorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectorState
         */
        Builder connectorState(ConnectorState connectorState);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private String connectorArn;

        private String connectorName;

        private String connectorState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorResponse model) {
            super(model);
            connectorArn(model.connectorArn);
            connectorName(model.connectorName);
            connectorState(model.connectorState);
        }

        public final String getConnectorArn() {
            return connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorName() {
            return connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorState() {
            return connectorState;
        }

        public final void setConnectorState(String connectorState) {
            this.connectorState = connectorState;
        }

        @Override
        public final Builder connectorState(String connectorState) {
            this.connectorState = connectorState;
            return this;
        }

        @Override
        public final Builder connectorState(ConnectorState connectorState) {
            this.connectorState(connectorState == null ? null : connectorState.toString());
            return this;
        }

        @Override
        public CreateConnectorResponse build() {
            return new CreateConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
