/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomPluginResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<CreateCustomPluginResponse.Builder, CreateCustomPluginResponse> {
    private static final SdkField<String> CUSTOM_PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginArn").getter(getter(CreateCustomPluginResponse::customPluginArn))
            .setter(setter(Builder::customPluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginArn").build()).build();

    private static final SdkField<String> CUSTOM_PLUGIN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginState").getter(getter(CreateCustomPluginResponse::customPluginStateAsString))
            .setter(setter(Builder::customPluginState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginState").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCustomPluginResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("revision")
            .getter(getter(CreateCustomPluginResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_PLUGIN_ARN_FIELD,
            CUSTOM_PLUGIN_STATE_FIELD, NAME_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customPluginArn;

    private final String customPluginState;

    private final String name;

    private final Long revision;

    private CreateCustomPluginResponse(BuilderImpl builder) {
        super(builder);
        this.customPluginArn = builder.customPluginArn;
        this.customPluginState = builder.customPluginState;
        this.name = builder.name;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.
     */
    public final String customPluginArn() {
        return customPluginArn;
    }

    /**
     * <p>
     * The state of the custom plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customPluginState}
     * will return {@link CustomPluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customPluginStateAsString}.
     * </p>
     * 
     * @return The state of the custom plugin.
     * @see CustomPluginState
     */
    public final CustomPluginState customPluginState() {
        return CustomPluginState.fromValue(customPluginState);
    }

    /**
     * <p>
     * The state of the custom plugin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customPluginState}
     * will return {@link CustomPluginState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customPluginStateAsString}.
     * </p>
     * 
     * @return The state of the custom plugin.
     * @see CustomPluginState
     */
    public final String customPluginStateAsString() {
        return customPluginState;
    }

    /**
     * <p>
     * The name of the custom plugin.
     * </p>
     * 
     * @return The name of the custom plugin.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The revision of the custom plugin.
     * </p>
     * 
     * @return The revision of the custom plugin.
     */
    public final Long revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customPluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(customPluginStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomPluginResponse)) {
            return false;
        }
        CreateCustomPluginResponse other = (CreateCustomPluginResponse) obj;
        return Objects.equals(customPluginArn(), other.customPluginArn())
                && Objects.equals(customPluginStateAsString(), other.customPluginStateAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomPluginResponse").add("CustomPluginArn", customPluginArn())
                .add("CustomPluginState", customPluginStateAsString()).add("Name", name()).add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customPluginArn":
            return Optional.ofNullable(clazz.cast(customPluginArn()));
        case "customPluginState":
            return Optional.ofNullable(clazz.cast(customPluginStateAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customPluginArn", CUSTOM_PLUGIN_ARN_FIELD);
        map.put("customPluginState", CUSTOM_PLUGIN_STATE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomPluginResponse, T> g) {
        return obj -> g.apply((CreateCustomPluginResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomPluginResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.
         * </p>
         * 
         * @param customPluginArn
         *        The Amazon Resource Name (ARN) that Amazon assigned to the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginArn(String customPluginArn);

        /**
         * <p>
         * The state of the custom plugin.
         * </p>
         * 
         * @param customPluginState
         *        The state of the custom plugin.
         * @see CustomPluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginState
         */
        Builder customPluginState(String customPluginState);

        /**
         * <p>
         * The state of the custom plugin.
         * </p>
         * 
         * @param customPluginState
         *        The state of the custom plugin.
         * @see CustomPluginState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomPluginState
         */
        Builder customPluginState(CustomPluginState customPluginState);

        /**
         * <p>
         * The name of the custom plugin.
         * </p>
         * 
         * @param name
         *        The name of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The revision of the custom plugin.
         * </p>
         * 
         * @param revision
         *        The revision of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private String customPluginArn;

        private String customPluginState;

        private String name;

        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomPluginResponse model) {
            super(model);
            customPluginArn(model.customPluginArn);
            customPluginState(model.customPluginState);
            name(model.name);
            revision(model.revision);
        }

        public final String getCustomPluginArn() {
            return customPluginArn;
        }

        public final void setCustomPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
        }

        @Override
        public final Builder customPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
            return this;
        }

        public final String getCustomPluginState() {
            return customPluginState;
        }

        public final void setCustomPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
        }

        @Override
        public final Builder customPluginState(String customPluginState) {
            this.customPluginState = customPluginState;
            return this;
        }

        @Override
        public final Builder customPluginState(CustomPluginState customPluginState) {
            this.customPluginState(customPluginState == null ? null : customPluginState.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public CreateCustomPluginResponse build() {
            return new CreateCustomPluginResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
