/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The client authentication information used in order to authenticate with the Apache Kafka cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaClusterClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<KafkaClusterClientAuthentication.Builder, KafkaClusterClientAuthentication> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(KafkaClusterClientAuthentication::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private KafkaClusterClientAuthentication(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
    }

    /**
     * <p>
     * The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client
     * authentication is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link KafkaClusterClientAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no
     *         client authentication is used.
     * @see KafkaClusterClientAuthenticationType
     */
    public final KafkaClusterClientAuthenticationType authenticationType() {
        return KafkaClusterClientAuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no client
     * authentication is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link KafkaClusterClientAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no
     *         client authentication is used.
     * @see KafkaClusterClientAuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaClusterClientAuthentication)) {
            return false;
        }
        KafkaClusterClientAuthentication other = (KafkaClusterClientAuthentication) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KafkaClusterClientAuthentication").add("AuthenticationType", authenticationTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KafkaClusterClientAuthentication, T> g) {
        return obj -> g.apply((KafkaClusterClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaClusterClientAuthentication> {
        /**
         * <p>
         * The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no
         * client authentication is used.
         * </p>
         * 
         * @param authenticationType
         *        The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that
         *        no client authentication is used.
         * @see KafkaClusterClientAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KafkaClusterClientAuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that no
         * client authentication is used.
         * </p>
         * 
         * @param authenticationType
         *        The type of client authentication used to connect to the Apache Kafka cluster. Value NONE means that
         *        no client authentication is used.
         * @see KafkaClusterClientAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KafkaClusterClientAuthenticationType
         */
        Builder authenticationType(KafkaClusterClientAuthenticationType authenticationType);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaClusterClientAuthentication model) {
            authenticationType(model.authenticationType);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(KafkaClusterClientAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        @Override
        public KafkaClusterClientAuthentication build() {
            return new KafkaClusterClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
