/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorOperationsResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<ListConnectorOperationsResponse.Builder, ListConnectorOperationsResponse> {
    private static final SdkField<List<ConnectorOperationSummary>> CONNECTOR_OPERATIONS_FIELD = SdkField
            .<List<ConnectorOperationSummary>> builder(MarshallingType.LIST)
            .memberName("connectorOperations")
            .getter(getter(ListConnectorOperationsResponse::connectorOperations))
            .setter(setter(Builder::connectorOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectorOperationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectorOperationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConnectorOperationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_OPERATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConnectorOperationSummary> connectorOperations;

    private final String nextToken;

    private ListConnectorOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectorOperations = builder.connectorOperations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectorOperations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectorOperations() {
        return connectorOperations != null && !(connectorOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of connector operation descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectorOperations} method.
     * </p>
     * 
     * @return An array of connector operation descriptions.
     */
    public final List<ConnectorOperationSummary> connectorOperations() {
        return connectorOperations;
    }

    /**
     * <p>
     * If the response is truncated, it includes a NextToken. Send this NextToken in a subsequent request to continue
     * listing from where it left off.
     * </p>
     * 
     * @return If the response is truncated, it includes a NextToken. Send this NextToken in a subsequent request to
     *         continue listing from where it left off.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectorOperations() ? connectorOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorOperationsResponse)) {
            return false;
        }
        ListConnectorOperationsResponse other = (ListConnectorOperationsResponse) obj;
        return hasConnectorOperations() == other.hasConnectorOperations()
                && Objects.equals(connectorOperations(), other.connectorOperations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorOperationsResponse")
                .add("ConnectorOperations", hasConnectorOperations() ? connectorOperations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectorOperations":
            return Optional.ofNullable(clazz.cast(connectorOperations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectorOperations", CONNECTOR_OPERATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorOperationsResponse, T> g) {
        return obj -> g.apply((ListConnectorOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConnectorOperationsResponse> {
        /**
         * <p>
         * An array of connector operation descriptions.
         * </p>
         * 
         * @param connectorOperations
         *        An array of connector operation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOperations(Collection<ConnectorOperationSummary> connectorOperations);

        /**
         * <p>
         * An array of connector operation descriptions.
         * </p>
         * 
         * @param connectorOperations
         *        An array of connector operation descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOperations(ConnectorOperationSummary... connectorOperations);

        /**
         * <p>
         * An array of connector operation descriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #connectorOperations(List<ConnectorOperationSummary>)}.
         * 
         * @param connectorOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorOperations(java.util.Collection<ConnectorOperationSummary>)
         */
        Builder connectorOperations(Consumer<ConnectorOperationSummary.Builder>... connectorOperations);

        /**
         * <p>
         * If the response is truncated, it includes a NextToken. Send this NextToken in a subsequent request to
         * continue listing from where it left off.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a NextToken. Send this NextToken in a subsequent request to
         *        continue listing from where it left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private List<ConnectorOperationSummary> connectorOperations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorOperationsResponse model) {
            super(model);
            connectorOperations(model.connectorOperations);
            nextToken(model.nextToken);
        }

        public final List<ConnectorOperationSummary.Builder> getConnectorOperations() {
            List<ConnectorOperationSummary.Builder> result = ___listOfConnectorOperationSummaryCopier
                    .copyToBuilder(this.connectorOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectorOperations(Collection<ConnectorOperationSummary.BuilderImpl> connectorOperations) {
            this.connectorOperations = ___listOfConnectorOperationSummaryCopier.copyFromBuilder(connectorOperations);
        }

        @Override
        public final Builder connectorOperations(Collection<ConnectorOperationSummary> connectorOperations) {
            this.connectorOperations = ___listOfConnectorOperationSummaryCopier.copy(connectorOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorOperations(ConnectorOperationSummary... connectorOperations) {
            connectorOperations(Arrays.asList(connectorOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorOperations(Consumer<ConnectorOperationSummary.Builder>... connectorOperations) {
            connectorOperations(Stream.of(connectorOperations)
                    .map(c -> ConnectorOperationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectorOperationsResponse build() {
            return new ListConnectorOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
