/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of an object in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Location implements SdkPojo, Serializable, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketArn").getter(getter(S3Location::bucketArn)).setter(setter(Builder::bucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()).build();

    private static final SdkField<String> FILE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileKey").getter(getter(S3Location::fileKey)).setter(setter(Builder::fileKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileKey").build()).build();

    private static final SdkField<String> OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectVersion").getter(getter(S3Location::objectVersion)).setter(setter(Builder::objectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            FILE_KEY_FIELD, OBJECT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketArn;

    private final String fileKey;

    private final String objectVersion;

    private S3Location(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.fileKey = builder.fileKey;
        this.objectVersion = builder.objectVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an S3 bucket.
     */
    public final String bucketArn() {
        return bucketArn;
    }

    /**
     * <p>
     * The file key for an object in an S3 bucket.
     * </p>
     * 
     * @return The file key for an object in an S3 bucket.
     */
    public final String fileKey() {
        return fileKey;
    }

    /**
     * <p>
     * The version of an object in an S3 bucket.
     * </p>
     * 
     * @return The version of an object in an S3 bucket.
     */
    public final String objectVersion() {
        return objectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        return Objects.equals(bucketArn(), other.bucketArn()) && Objects.equals(fileKey(), other.fileKey())
                && Objects.equals(objectVersion(), other.objectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Location").add("BucketArn", bucketArn()).add("FileKey", fileKey())
                .add("ObjectVersion", objectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketArn":
            return Optional.ofNullable(clazz.cast(bucketArn()));
        case "fileKey":
            return Optional.ofNullable(clazz.cast(fileKey()));
        case "objectVersion":
            return Optional.ofNullable(clazz.cast(objectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketArn", BUCKET_ARN_FIELD);
        map.put("fileKey", FILE_KEY_FIELD);
        map.put("objectVersion", OBJECT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an S3 bucket.
         * </p>
         * 
         * @param bucketArn
         *        The Amazon Resource Name (ARN) of an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketArn(String bucketArn);

        /**
         * <p>
         * The file key for an object in an S3 bucket.
         * </p>
         * 
         * @param fileKey
         *        The file key for an object in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);

        /**
         * <p>
         * The version of an object in an S3 bucket.
         * </p>
         * 
         * @param objectVersion
         *        The version of an object in an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectVersion(String objectVersion);
    }

    static final class BuilderImpl implements Builder {
        private String bucketArn;

        private String fileKey;

        private String objectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            bucketArn(model.bucketArn);
            fileKey(model.fileKey);
            objectVersion(model.objectVersion);
        }

        public final String getBucketArn() {
            return bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getFileKey() {
            return fileKey;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final String getObjectVersion() {
            return objectVersion;
        }

        public final void setObjectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
        }

        @Override
        public final Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
