/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Workers can send worker logs to different destination types. This configuration specifies the details of these
 * destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerLogDelivery implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerLogDelivery.Builder, WorkerLogDelivery> {
    private static final SdkField<CloudWatchLogsLogDelivery> CLOUD_WATCH_LOGS_FIELD = SdkField
            .<CloudWatchLogsLogDelivery> builder(MarshallingType.SDK_POJO).memberName("cloudWatchLogs")
            .getter(getter(WorkerLogDelivery::cloudWatchLogs)).setter(setter(Builder::cloudWatchLogs))
            .constructor(CloudWatchLogsLogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()).build();

    private static final SdkField<FirehoseLogDelivery> FIREHOSE_FIELD = SdkField
            .<FirehoseLogDelivery> builder(MarshallingType.SDK_POJO).memberName("firehose")
            .getter(getter(WorkerLogDelivery::firehose)).setter(setter(Builder::firehose))
            .constructor(FirehoseLogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final SdkField<S3LogDelivery> S3_FIELD = SdkField.<S3LogDelivery> builder(MarshallingType.SDK_POJO)
            .memberName("s3").getter(getter(WorkerLogDelivery::s3)).setter(setter(Builder::s3))
            .constructor(S3LogDelivery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD,
            FIREHOSE_FIELD, S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsLogDelivery cloudWatchLogs;

    private final FirehoseLogDelivery firehose;

    private final S3LogDelivery s3;

    private WorkerLogDelivery(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.firehose = builder.firehose;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Details about delivering logs to Amazon CloudWatch Logs.
     */
    public final CloudWatchLogsLogDelivery cloudWatchLogs() {
        return cloudWatchLogs;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon Kinesis Data Firehose.
     * </p>
     * 
     * @return Details about delivering logs to Amazon Kinesis Data Firehose.
     */
    public final FirehoseLogDelivery firehose() {
        return firehose;
    }

    /**
     * <p>
     * Details about delivering logs to Amazon S3.
     * </p>
     * 
     * @return Details about delivering logs to Amazon S3.
     */
    public final S3LogDelivery s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerLogDelivery)) {
            return false;
        }
        WorkerLogDelivery other = (WorkerLogDelivery) obj;
        return Objects.equals(cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(firehose(), other.firehose())
                && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerLogDelivery").add("CloudWatchLogs", cloudWatchLogs()).add("Firehose", firehose())
                .add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogs":
            return Optional.ofNullable(clazz.cast(cloudWatchLogs()));
        case "firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("firehose", FIREHOSE_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerLogDelivery, T> g) {
        return obj -> g.apply((WorkerLogDelivery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerLogDelivery> {
        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchLogs
         *        Details about delivering logs to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogs(CloudWatchLogsLogDelivery cloudWatchLogs);

        /**
         * <p>
         * Details about delivering logs to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsLogDelivery.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsLogDelivery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsLogDelivery.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogs(CloudWatchLogsLogDelivery)}.
         * 
         * @param cloudWatchLogs
         *        a consumer that will call methods on {@link CloudWatchLogsLogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogs(CloudWatchLogsLogDelivery)
         */
        default Builder cloudWatchLogs(Consumer<CloudWatchLogsLogDelivery.Builder> cloudWatchLogs) {
            return cloudWatchLogs(CloudWatchLogsLogDelivery.builder().applyMutation(cloudWatchLogs).build());
        }

        /**
         * <p>
         * Details about delivering logs to Amazon Kinesis Data Firehose.
         * </p>
         * 
         * @param firehose
         *        Details about delivering logs to Amazon Kinesis Data Firehose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseLogDelivery firehose);

        /**
         * <p>
         * Details about delivering logs to Amazon Kinesis Data Firehose.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirehoseLogDelivery.Builder} avoiding the
         * need to create one manually via {@link FirehoseLogDelivery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirehoseLogDelivery.Builder#build()} is called immediately and
         * its result is passed to {@link #firehose(FirehoseLogDelivery)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseLogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseLogDelivery)
         */
        default Builder firehose(Consumer<FirehoseLogDelivery.Builder> firehose) {
            return firehose(FirehoseLogDelivery.builder().applyMutation(firehose).build());
        }

        /**
         * <p>
         * Details about delivering logs to Amazon S3.
         * </p>
         * 
         * @param s3
         *        Details about delivering logs to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3LogDelivery s3);

        /**
         * <p>
         * Details about delivering logs to Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LogDelivery.Builder} avoiding the need
         * to create one manually via {@link S3LogDelivery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3LogDelivery.Builder#build()} is called immediately and its
         * result is passed to {@link #s3(S3LogDelivery)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3LogDelivery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3LogDelivery)
         */
        default Builder s3(Consumer<S3LogDelivery.Builder> s3) {
            return s3(S3LogDelivery.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsLogDelivery cloudWatchLogs;

        private FirehoseLogDelivery firehose;

        private S3LogDelivery s3;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerLogDelivery model) {
            cloudWatchLogs(model.cloudWatchLogs);
            firehose(model.firehose);
            s3(model.s3);
        }

        public final CloudWatchLogsLogDelivery.Builder getCloudWatchLogs() {
            return cloudWatchLogs != null ? cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsLogDelivery.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsLogDelivery cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final FirehoseLogDelivery.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseLogDelivery.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseLogDelivery firehose) {
            this.firehose = firehose;
            return this;
        }

        public final S3LogDelivery.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3LogDelivery.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3LogDelivery s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public WorkerLogDelivery build() {
            return new WorkerLogDelivery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
