/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectAsyncClient;
import software.amazon.awssdk.services.kafkaconnect.KafkaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.kafkaconnect.internal.KafkaConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kafkaconnect.model.BadRequestException;
import software.amazon.awssdk.services.kafkaconnect.model.ConflictException;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DeleteWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorOperationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorOperationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationRequest;
import software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.kafkaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.kafkaconnect.model.KafkaConnectException;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorOperationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListConnectorsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListCustomPluginsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsRequest;
import software.amazon.awssdk.services.kafkaconnect.model.ListWorkerConfigurationsResponse;
import software.amazon.awssdk.services.kafkaconnect.model.NotFoundException;
import software.amazon.awssdk.services.kafkaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kafkaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.kafkaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.kafkaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.kafkaconnect.model.UnauthorizedException;
import software.amazon.awssdk.services.kafkaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.kafkaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.kafkaconnect.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.kafkaconnect.transform.CreateConnectorRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.CreateCustomPluginRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.CreateWorkerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DeleteConnectorRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DeleteCustomPluginRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DeleteWorkerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DescribeConnectorOperationRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DescribeConnectorRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DescribeCustomPluginRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.DescribeWorkerConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.ListConnectorOperationsRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.ListConnectorsRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.ListCustomPluginsRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.ListWorkerConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kafkaconnect.transform.UpdateConnectorRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKafkaConnectAsyncClient
implements KafkaConnectAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKafkaConnectAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKafkaConnectAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"KafkaConnect#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateConnectorResponse> createConnector(CreateConnectorRequest createConnectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConnectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createConnectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$createConnector$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$createConnector$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomPluginResponse> createCustomPlugin(CreateCustomPluginRequest createCustomPluginRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomPluginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomPlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomPluginResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomPlugin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomPluginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomPluginRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$createCustomPlugin$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$createCustomPlugin$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateWorkerConfigurationResponse> createWorkerConfiguration(CreateWorkerConfigurationRequest createWorkerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createWorkerConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createWorkerConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkerConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkerConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateWorkerConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createWorkerConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$createWorkerConfiguration$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$createWorkerConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteConnectorResponse> deleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteConnectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$deleteConnector$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$deleteConnector$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomPluginResponse> deleteCustomPlugin(DeleteCustomPluginRequest deleteCustomPluginRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomPluginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomPlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomPluginResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomPlugin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomPluginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomPluginRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$deleteCustomPlugin$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$deleteCustomPlugin$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteWorkerConfigurationResponse> deleteWorkerConfiguration(DeleteWorkerConfigurationRequest deleteWorkerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWorkerConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteWorkerConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkerConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkerConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteWorkerConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteWorkerConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$deleteWorkerConfiguration$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$deleteWorkerConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConnectorResponse> describeConnector(DescribeConnectorRequest describeConnectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConnectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$describeConnector$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$describeConnector$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeConnectorOperationResponse> describeConnectorOperation(DescribeConnectorOperationRequest describeConnectorOperationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConnectorOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeConnectorOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConnectorOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConnectorOperationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConnectorOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeConnectorOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeConnectorOperationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$describeConnectorOperation$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$describeConnectorOperation$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCustomPluginResponse> describeCustomPlugin(DescribeCustomPluginRequest describeCustomPluginRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCustomPluginRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeCustomPluginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomPlugin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomPluginResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomPlugin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCustomPluginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCustomPluginRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$describeCustomPlugin$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$describeCustomPlugin$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkerConfigurationResponse> describeWorkerConfiguration(DescribeWorkerConfigurationRequest describeWorkerConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWorkerConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeWorkerConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkerConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkerConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkerConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeWorkerConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeWorkerConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$describeWorkerConfiguration$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$describeWorkerConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListConnectorOperationsResponse> listConnectorOperations(ListConnectorOperationsRequest listConnectorOperationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectorOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listConnectorOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectorOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectorOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListConnectorOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConnectorOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$listConnectorOperations$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$listConnectorOperations$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListConnectorsResponse> listConnectors(ListConnectorsRequest listConnectorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConnectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listConnectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConnectors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConnectorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConnectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListConnectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConnectorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$listConnectors$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$listConnectors$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCustomPluginsResponse> listCustomPlugins(ListCustomPluginsRequest listCustomPluginsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCustomPluginsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listCustomPluginsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomPlugins");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomPluginsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomPlugins").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCustomPluginsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCustomPluginsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$listCustomPlugins$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$listCustomPlugins$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$listTagsForResource$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$listTagsForResource$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListWorkerConfigurationsResponse> listWorkerConfigurations(ListWorkerConfigurationsRequest listWorkerConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWorkerConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listWorkerConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkerConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkerConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkerConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListWorkerConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listWorkerConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$listWorkerConfigurations$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$listWorkerConfigurations$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$tagResource$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$tagResource$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$untagResource$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$untagResource$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateConnectorResponse> updateConnector(UpdateConnectorRequest updateConnectorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConnectorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKafkaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateConnectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"KafkaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConnector");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConnectorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConnector").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateConnectorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateConnectorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKafkaConnectAsyncClient.lambda$updateConnector$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKafkaConnectAsyncClient.lambda$updateConnector$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final KafkaConnectServiceClientConfiguration serviceClientConfiguration() {
        return new KafkaConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "kafkaconnect";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KafkaConnectException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KafkaConnectServiceClientConfigurationBuilder serviceConfigBuilder = new KafkaConnectServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateConnector$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConnector$70(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$66(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$62(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listWorkerConfigurations$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkerConfigurations$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListWorkerConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$54(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCustomPlugins$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomPlugins$50(List metricPublishers, MetricCollector apiCallMetricCollector, ListCustomPluginsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listConnectors$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectors$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListConnectorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listConnectorOperations$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConnectorOperations$42(List metricPublishers, MetricCollector apiCallMetricCollector, ListConnectorOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeWorkerConfiguration$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkerConfiguration$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeWorkerConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCustomPlugin$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomPlugin$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCustomPluginResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeConnectorOperation$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnectorOperation$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeConnectorOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeConnector$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConnector$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteWorkerConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkerConfiguration$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteWorkerConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomPlugin$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomPlugin$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomPluginResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteConnector$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnector$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createWorkerConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkerConfiguration$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateWorkerConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomPlugin$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomPlugin$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomPluginResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createConnector$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConnector$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateConnectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

