/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDocumentRequest extends KendraRequest implements
        ToCopyableBuilder<BatchDeleteDocumentRequest.Builder, BatchDeleteDocumentRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDeleteDocumentRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<List<String>> DOCUMENT_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchDeleteDocumentRequest::documentIdList))
            .setter(setter(Builder::documentIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD,
            DOCUMENT_ID_LIST_FIELD));

    private final String indexId;

    private final List<String> documentIdList;

    private BatchDeleteDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.documentIdList = builder.documentIdList;
    }

    /**
     * <p>
     * The identifier of the index that contains the documents to delete.
     * </p>
     * 
     * @return The identifier of the index that contains the documents to delete.
     */
    public String indexId() {
        return indexId;
    }

    /**
     * <p>
     * One or more identifiers for documents to delete from the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more identifiers for documents to delete from the index.
     */
    public List<String> documentIdList() {
        return documentIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(documentIdList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentRequest)) {
            return false;
        }
        BatchDeleteDocumentRequest other = (BatchDeleteDocumentRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(documentIdList(), other.documentIdList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDeleteDocumentRequest").add("IndexId", indexId()).add("DocumentIdList", documentIdList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "DocumentIdList":
            return Optional.ofNullable(clazz.cast(documentIdList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentRequest, T> g) {
        return obj -> g.apply((BatchDeleteDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteDocumentRequest> {
        /**
         * <p>
         * The identifier of the index that contains the documents to delete.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that contains the documents to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * One or more identifiers for documents to delete from the index.
         * </p>
         * 
         * @param documentIdList
         *        One or more identifiers for documents to delete from the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdList(Collection<String> documentIdList);

        /**
         * <p>
         * One or more identifiers for documents to delete from the index.
         * </p>
         * 
         * @param documentIdList
         *        One or more identifiers for documents to delete from the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdList(String... documentIdList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private List<String> documentIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentRequest model) {
            super(model);
            indexId(model.indexId);
            documentIdList(model.documentIdList);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final Collection<String> getDocumentIdList() {
            return documentIdList;
        }

        @Override
        public final Builder documentIdList(Collection<String> documentIdList) {
            this.documentIdList = DocumentIdListCopier.copy(documentIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdList(String... documentIdList) {
            documentIdList(Arrays.asList(documentIdList));
            return this;
        }

        public final void setDocumentIdList(Collection<String> documentIdList) {
            this.documentIdList = DocumentIdListCopier.copy(documentIdList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteDocumentRequest build() {
            return new BatchDeleteDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
