/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single query result.
 * </p>
 * <p>
 * A query result contains information about a document returned by the query. This includes the original location of
 * the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the
 * query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResultItem implements SdkPojo, Serializable, ToCopyableBuilder<QueryResultItem.Builder, QueryResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryResultItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryResultItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<AdditionalResultAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<AdditionalResultAttribute>> builder(MarshallingType.LIST)
            .getter(getter(QueryResultItem::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalResultAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalResultAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryResultItem::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).getter(getter(QueryResultItem::documentTitle))
            .setter(setter(Builder::documentTitle)).constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).getter(getter(QueryResultItem::documentExcerpt))
            .setter(setter(Builder::documentExcerpt)).constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()).build();

    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryResultItem::documentURI)).setter(setter(Builder::documentURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()).build();

    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .getter(getter(QueryResultItem::documentAttributes))
            .setter(setter(Builder::documentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            ADDITIONAL_ATTRIBUTES_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD, DOCUMENT_URI_FIELD,
            DOCUMENT_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final List<AdditionalResultAttribute> additionalAttributes;

    private final String documentId;

    private final TextWithHighlights documentTitle;

    private final TextWithHighlights documentExcerpt;

    private final String documentURI;

    private final List<DocumentAttribute> documentAttributes;

    private QueryResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.additionalAttributes = builder.additionalAttributes;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
    }

    /**
     * <p>
     * The unique identifier for the query result.
     * </p>
     * 
     * @return The unique identifier for the query result.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The type of document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document.
     * @see QueryResultType
     */
    public QueryResultType type() {
        return QueryResultType.fromValue(type);
    }

    /**
     * <p>
     * The type of document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document.
     * @see QueryResultType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return
     */
    public List<AdditionalResultAttribute> additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The unique identifier for the document.
     * </p>
     * 
     * @return The unique identifier for the document.
     */
    public String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The title of the document. Contains the text of the title and information for highlighting the relevant terms in
     * the title.
     * </p>
     * 
     * @return The title of the document. Contains the text of the title and information for highlighting the relevant
     *         terms in the title.
     */
    public TextWithHighlights documentTitle() {
        return documentTitle;
    }

    /**
     * <p>
     * An extract of the text in the document. Contains information about highlighting the relevant terms in the
     * excerpt.
     * </p>
     * 
     * @return An extract of the text in the document. Contains information about highlighting the relevant terms in the
     *         excerpt.
     */
    public TextWithHighlights documentExcerpt() {
        return documentExcerpt;
    }

    /**
     * <p>
     * The URI of the original location of the document.
     * </p>
     * 
     * @return The URI of the original location of the document.
     */
    public String documentURI() {
        return documentURI;
    }

    /**
     * <p>
     * An array of document attributes for the document that the query result maps to. For example, the document author
     * (Author) or the source URI (SourceUri) of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of document attributes for the document that the query result maps to. For example, the document
     *         author (Author) or the source URI (SourceUri) of the document.
     */
    public List<DocumentAttribute> documentAttributes() {
        return documentAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultItem)) {
            return false;
        }
        QueryResultItem other = (QueryResultItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(additionalAttributes(), other.additionalAttributes())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(documentTitle(), other.documentTitle())
                && Objects.equals(documentExcerpt(), other.documentExcerpt())
                && Objects.equals(documentURI(), other.documentURI())
                && Objects.equals(documentAttributes(), other.documentAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryResultItem").add("Id", id()).add("Type", typeAsString())
                .add("AdditionalAttributes", additionalAttributes()).add("DocumentId", documentId())
                .add("DocumentTitle", documentTitle()).add("DocumentExcerpt", documentExcerpt())
                .add("DocumentURI", documentURI()).add("DocumentAttributes", documentAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "DocumentTitle":
            return Optional.ofNullable(clazz.cast(documentTitle()));
        case "DocumentExcerpt":
            return Optional.ofNullable(clazz.cast(documentExcerpt()));
        case "DocumentURI":
            return Optional.ofNullable(clazz.cast(documentURI()));
        case "DocumentAttributes":
            return Optional.ofNullable(clazz.cast(documentAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultItem, T> g) {
        return obj -> g.apply((QueryResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryResultItem> {
        /**
         * <p>
         * The unique identifier for the query result.
         * </p>
         * 
         * @param id
         *        The unique identifier for the query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of document.
         * </p>
         * 
         * @param type
         *        The type of document.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of document.
         * </p>
         * 
         * @param type
         *        The type of document.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(QueryResultType type);

        /**
         * <p/>
         * 
         * @param additionalAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes);

        /**
         * <p/>
         * 
         * @param additionalAttributes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AdditionalResultAttribute... additionalAttributes);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<AdditionalResultAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<AdditionalResultAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalResultAttribute>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalAttributes(List<AdditionalResultAttribute>)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on {@link List<AdditionalResultAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(List<AdditionalResultAttribute>)
         */
        Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder>... additionalAttributes);

        /**
         * <p>
         * The unique identifier for the document.
         * </p>
         * 
         * @param documentId
         *        The unique identifier for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The title of the document. Contains the text of the title and information for highlighting the relevant terms
         * in the title.
         * </p>
         * 
         * @param documentTitle
         *        The title of the document. Contains the text of the title and information for highlighting the
         *        relevant terms in the title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitle(TextWithHighlights documentTitle);

        /**
         * <p>
         * The title of the document. Contains the text of the title and information for highlighting the relevant terms
         * in the title.
         * </p>
         * This is a convenience that creates an instance of the {@link TextWithHighlights.Builder} avoiding the need to
         * create one manually via {@link TextWithHighlights#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentTitle(TextWithHighlights)}.
         * 
         * @param documentTitle
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentTitle(TextWithHighlights)
         */
        default Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return documentTitle(TextWithHighlights.builder().applyMutation(documentTitle).build());
        }

        /**
         * <p>
         * An extract of the text in the document. Contains information about highlighting the relevant terms in the
         * excerpt.
         * </p>
         * 
         * @param documentExcerpt
         *        An extract of the text in the document. Contains information about highlighting the relevant terms in
         *        the excerpt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentExcerpt(TextWithHighlights documentExcerpt);

        /**
         * <p>
         * An extract of the text in the document. Contains information about highlighting the relevant terms in the
         * excerpt.
         * </p>
         * This is a convenience that creates an instance of the {@link TextWithHighlights.Builder} avoiding the need to
         * create one manually via {@link TextWithHighlights#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentExcerpt(TextWithHighlights)}.
         * 
         * @param documentExcerpt
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentExcerpt(TextWithHighlights)
         */
        default Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return documentExcerpt(TextWithHighlights.builder().applyMutation(documentExcerpt).build());
        }

        /**
         * <p>
         * The URI of the original location of the document.
         * </p>
         * 
         * @param documentURI
         *        The URI of the original location of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentURI(String documentURI);

        /**
         * <p>
         * An array of document attributes for the document that the query result maps to. For example, the document
         * author (Author) or the source URI (SourceUri) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document attributes for the document that the query result maps to. For example, the
         *        document author (Author) or the source URI (SourceUri) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(Collection<DocumentAttribute> documentAttributes);

        /**
         * <p>
         * An array of document attributes for the document that the query result maps to. For example, the document
         * author (Author) or the source URI (SourceUri) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document attributes for the document that the query result maps to. For example, the
         *        document author (Author) or the source URI (SourceUri) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(DocumentAttribute... documentAttributes);

        /**
         * <p>
         * An array of document attributes for the document that the query result maps to. For example, the document
         * author (Author) or the source URI (SourceUri) of the document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #documentAttributes(List<DocumentAttribute>)}.
         * 
         * @param documentAttributes
         *        a consumer that will call methods on {@link List<DocumentAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributes(List<DocumentAttribute>)
         */
        Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private List<AdditionalResultAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private String documentId;

        private TextWithHighlights documentTitle;

        private TextWithHighlights documentExcerpt;

        private String documentURI;

        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultItem model) {
            id(model.id);
            type(model.type);
            additionalAttributes(model.additionalAttributes);
            documentId(model.documentId);
            documentTitle(model.documentTitle);
            documentExcerpt(model.documentExcerpt);
            documentURI(model.documentURI);
            documentAttributes(model.documentAttributes);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<AdditionalResultAttribute.Builder> getAdditionalAttributes() {
            return additionalAttributes != null ? additionalAttributes.stream().map(AdditionalResultAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalResultAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder>... additionalAttributes) {
            additionalAttributes(Stream.of(additionalAttributes)
                    .map(c -> AdditionalResultAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAttributes(Collection<AdditionalResultAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        public final String getDocumentId() {
            return documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return documentTitle != null ? documentTitle.toBuilder() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return documentExcerpt != null ? documentExcerpt.toBuilder() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        public final String getDocumentURI() {
            return documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        public final Collection<DocumentAttribute.Builder> getDocumentAttributes() {
            return documentAttributes != null ? documentAttributes.stream().map(DocumentAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute... documentAttributes) {
            documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes) {
            documentAttributes(Stream.of(documentAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public QueryResultItem build() {
            return new QueryResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
