/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about how Amazon Kendra should use the columns of a database in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnConfiguration.Builder, ColumnConfiguration> {
    private static final SdkField<String> DOCUMENT_ID_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnConfiguration::documentIdColumnName)).setter(setter(Builder::documentIdColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdColumnName").build())
            .build();

    private static final SdkField<String> DOCUMENT_DATA_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnConfiguration::documentDataColumnName)).setter(setter(Builder::documentDataColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataColumnName").build())
            .build();

    private static final SdkField<String> DOCUMENT_TITLE_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ColumnConfiguration::documentTitleColumnName)).setter(setter(Builder::documentTitleColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleColumnName").build())
            .build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .getter(getter(ColumnConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANGE_DETECTING_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ColumnConfiguration::changeDetectingColumns))
            .setter(setter(Builder::changeDetectingColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeDetectingColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_COLUMN_NAME_FIELD,
            DOCUMENT_DATA_COLUMN_NAME_FIELD, DOCUMENT_TITLE_COLUMN_NAME_FIELD, FIELD_MAPPINGS_FIELD,
            CHANGE_DETECTING_COLUMNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentIdColumnName;

    private final String documentDataColumnName;

    private final String documentTitleColumnName;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private final List<String> changeDetectingColumns;

    private ColumnConfiguration(BuilderImpl builder) {
        this.documentIdColumnName = builder.documentIdColumnName;
        this.documentDataColumnName = builder.documentDataColumnName;
        this.documentTitleColumnName = builder.documentTitleColumnName;
        this.fieldMappings = builder.fieldMappings;
        this.changeDetectingColumns = builder.changeDetectingColumns;
    }

    /**
     * <p>
     * The column that provides the document's unique identifier.
     * </p>
     * 
     * @return The column that provides the document's unique identifier.
     */
    public String documentIdColumnName() {
        return documentIdColumnName;
    }

    /**
     * <p>
     * The column that contains the contents of the document.
     * </p>
     * 
     * @return The column that contains the contents of the document.
     */
    public String documentDataColumnName() {
        return documentDataColumnName;
    }

    /**
     * <p>
     * The column that contains the title of the document.
     * </p>
     * 
     * @return The column that contains the title of the document.
     */
    public String documentTitleColumnName() {
        return documentTitleColumnName;
    }

    /**
     * <p>
     * An array of objects that map database column names to the corresponding fields in an index. You must first create
     * the fields in the index using the <a>UpdateIndex</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects that map database column names to the corresponding fields in an index. You must
     *         first create the fields in the index using the <a>UpdateIndex</a> operation.
     */
    public List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    /**
     * <p>
     * One to five columns that indicate when a document in the database has changed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One to five columns that indicate when a document in the database has changed.
     */
    public List<String> changeDetectingColumns() {
        return changeDetectingColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentIdColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(documentDataColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMappings());
        hashCode = 31 * hashCode + Objects.hashCode(changeDetectingColumns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnConfiguration)) {
            return false;
        }
        ColumnConfiguration other = (ColumnConfiguration) obj;
        return Objects.equals(documentIdColumnName(), other.documentIdColumnName())
                && Objects.equals(documentDataColumnName(), other.documentDataColumnName())
                && Objects.equals(documentTitleColumnName(), other.documentTitleColumnName())
                && Objects.equals(fieldMappings(), other.fieldMappings())
                && Objects.equals(changeDetectingColumns(), other.changeDetectingColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ColumnConfiguration").add("DocumentIdColumnName", documentIdColumnName())
                .add("DocumentDataColumnName", documentDataColumnName())
                .add("DocumentTitleColumnName", documentTitleColumnName()).add("FieldMappings", fieldMappings())
                .add("ChangeDetectingColumns", changeDetectingColumns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentIdColumnName":
            return Optional.ofNullable(clazz.cast(documentIdColumnName()));
        case "DocumentDataColumnName":
            return Optional.ofNullable(clazz.cast(documentDataColumnName()));
        case "DocumentTitleColumnName":
            return Optional.ofNullable(clazz.cast(documentTitleColumnName()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        case "ChangeDetectingColumns":
            return Optional.ofNullable(clazz.cast(changeDetectingColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnConfiguration, T> g) {
        return obj -> g.apply((ColumnConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnConfiguration> {
        /**
         * <p>
         * The column that provides the document's unique identifier.
         * </p>
         * 
         * @param documentIdColumnName
         *        The column that provides the document's unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdColumnName(String documentIdColumnName);

        /**
         * <p>
         * The column that contains the contents of the document.
         * </p>
         * 
         * @param documentDataColumnName
         *        The column that contains the contents of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDataColumnName(String documentDataColumnName);

        /**
         * <p>
         * The column that contains the title of the document.
         * </p>
         * 
         * @param documentTitleColumnName
         *        The column that contains the title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleColumnName(String documentTitleColumnName);

        /**
         * <p>
         * An array of objects that map database column names to the corresponding fields in an index. You must first
         * create the fields in the index using the <a>UpdateIndex</a> operation.
         * </p>
         * 
         * @param fieldMappings
         *        An array of objects that map database column names to the corresponding fields in an index. You must
         *        first create the fields in the index using the <a>UpdateIndex</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * An array of objects that map database column names to the corresponding fields in an index. You must first
         * create the fields in the index using the <a>UpdateIndex</a> operation.
         * </p>
         * 
         * @param fieldMappings
         *        An array of objects that map database column names to the corresponding fields in an index. You must
         *        first create the fields in the index using the <a>UpdateIndex</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * An array of objects that map database column names to the corresponding fields in an index. You must first
         * create the fields in the index using the <a>UpdateIndex</a> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);

        /**
         * <p>
         * One to five columns that indicate when a document in the database has changed.
         * </p>
         * 
         * @param changeDetectingColumns
         *        One to five columns that indicate when a document in the database has changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDetectingColumns(Collection<String> changeDetectingColumns);

        /**
         * <p>
         * One to five columns that indicate when a document in the database has changed.
         * </p>
         * 
         * @param changeDetectingColumns
         *        One to five columns that indicate when a document in the database has changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeDetectingColumns(String... changeDetectingColumns);
    }

    static final class BuilderImpl implements Builder {
        private String documentIdColumnName;

        private String documentDataColumnName;

        private String documentTitleColumnName;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private List<String> changeDetectingColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnConfiguration model) {
            documentIdColumnName(model.documentIdColumnName);
            documentDataColumnName(model.documentDataColumnName);
            documentTitleColumnName(model.documentTitleColumnName);
            fieldMappings(model.fieldMappings);
            changeDetectingColumns(model.changeDetectingColumns);
        }

        public final String getDocumentIdColumnName() {
            return documentIdColumnName;
        }

        @Override
        public final Builder documentIdColumnName(String documentIdColumnName) {
            this.documentIdColumnName = documentIdColumnName;
            return this;
        }

        public final void setDocumentIdColumnName(String documentIdColumnName) {
            this.documentIdColumnName = documentIdColumnName;
        }

        public final String getDocumentDataColumnName() {
            return documentDataColumnName;
        }

        @Override
        public final Builder documentDataColumnName(String documentDataColumnName) {
            this.documentDataColumnName = documentDataColumnName;
            return this;
        }

        public final void setDocumentDataColumnName(String documentDataColumnName) {
            this.documentDataColumnName = documentDataColumnName;
        }

        public final String getDocumentTitleColumnName() {
            return documentTitleColumnName;
        }

        @Override
        public final Builder documentTitleColumnName(String documentTitleColumnName) {
            this.documentTitleColumnName = documentTitleColumnName;
            return this;
        }

        public final void setDocumentTitleColumnName(String documentTitleColumnName) {
            this.documentTitleColumnName = documentTitleColumnName;
        }

        public final Collection<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            return fieldMappings != null ? fieldMappings.stream().map(DataSourceToIndexFieldMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        public final Collection<String> getChangeDetectingColumns() {
            return changeDetectingColumns;
        }

        @Override
        public final Builder changeDetectingColumns(Collection<String> changeDetectingColumns) {
            this.changeDetectingColumns = ChangeDetectingColumnsCopier.copy(changeDetectingColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeDetectingColumns(String... changeDetectingColumns) {
            changeDetectingColumns(Arrays.asList(changeDetectingColumns));
            return this;
        }

        public final void setChangeDetectingColumns(Collection<String> changeDetectingColumns) {
            this.changeDetectingColumns = ChangeDetectingColumnsCopier.copy(changeDetectingColumns);
        }

        @Override
        public ColumnConfiguration build() {
            return new ColumnConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
