/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about text documents indexed in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextDocumentStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<TextDocumentStatistics.Builder, TextDocumentStatistics> {
    private static final SdkField<Integer> INDEXED_TEXT_DOCUMENTS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(TextDocumentStatistics::indexedTextDocumentsCount))
            .setter(setter(Builder::indexedTextDocumentsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedTextDocumentsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INDEXED_TEXT_DOCUMENTS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer indexedTextDocumentsCount;

    private TextDocumentStatistics(BuilderImpl builder) {
        this.indexedTextDocumentsCount = builder.indexedTextDocumentsCount;
    }

    /**
     * <p>
     * The number of text documents indexed.
     * </p>
     * 
     * @return The number of text documents indexed.
     */
    public Integer indexedTextDocumentsCount() {
        return indexedTextDocumentsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexedTextDocumentsCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDocumentStatistics)) {
            return false;
        }
        TextDocumentStatistics other = (TextDocumentStatistics) obj;
        return Objects.equals(indexedTextDocumentsCount(), other.indexedTextDocumentsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TextDocumentStatistics").add("IndexedTextDocumentsCount", indexedTextDocumentsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexedTextDocumentsCount":
            return Optional.ofNullable(clazz.cast(indexedTextDocumentsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextDocumentStatistics, T> g) {
        return obj -> g.apply((TextDocumentStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextDocumentStatistics> {
        /**
         * <p>
         * The number of text documents indexed.
         * </p>
         * 
         * @param indexedTextDocumentsCount
         *        The number of text documents indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedTextDocumentsCount(Integer indexedTextDocumentsCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer indexedTextDocumentsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDocumentStatistics model) {
            indexedTextDocumentsCount(model.indexedTextDocumentsCount);
        }

        public final Integer getIndexedTextDocumentsCount() {
            return indexedTextDocumentsCount;
        }

        @Override
        public final Builder indexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
            return this;
        }

        public final void setIndexedTextDocumentsCount(Integer indexedTextDocumentsCount) {
            this.indexedTextDocumentsCount = indexedTextDocumentsCount;
        }

        @Override
        public TextDocumentStatistics build() {
            return new TextDocumentStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
