/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIndexRequest extends KendraRequest implements
        ToCopyableBuilder<UpdateIndexRequest.Builder, UpdateIndexRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIndexRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIndexRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIndexRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateIndexRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD = SdkField
            .<List<DocumentMetadataConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(UpdateIndexRequest::documentMetadataConfigurationUpdates))
            .setter(setter(Builder::documentMetadataConfigurationUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DocumentMetadataConfigurationUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentMetadataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentMetadataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ROLE_ARN_FIELD, DESCRIPTION_FIELD, DOCUMENT_METADATA_CONFIGURATION_UPDATES_FIELD));

    private final String id;

    private final String name;

    private final String roleArn;

    private final String description;

    private final List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates;

    private UpdateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.documentMetadataConfigurationUpdates = builder.documentMetadataConfigurationUpdates;
    }

    /**
     * <p>
     * The identifier of the index to update.
     * </p>
     * 
     * @return The identifier of the index to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the index to update.
     * </p>
     * 
     * @return The name of the index to update.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.
     * </p>
     * 
     * @return A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A new description for the index.
     * </p>
     * 
     * @return A new description for the index.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The document metadata to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The document metadata to update.
     */
    public List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates() {
        return documentMetadataConfigurationUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadataConfigurationUpdates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIndexRequest)) {
            return false;
        }
        UpdateIndexRequest other = (UpdateIndexRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description())
                && Objects.equals(documentMetadataConfigurationUpdates(), other.documentMetadataConfigurationUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateIndexRequest").add("Id", id()).add("Name", name()).add("RoleArn", roleArn())
                .add("Description", description())
                .add("DocumentMetadataConfigurationUpdates", documentMetadataConfigurationUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DocumentMetadataConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(documentMetadataConfigurationUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIndexRequest, T> g) {
        return obj -> g.apply((UpdateIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIndexRequest> {
        /**
         * <p>
         * The identifier of the index to update.
         * </p>
         * 
         * @param id
         *        The identifier of the index to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the index to update.
         * </p>
         * 
         * @param name
         *        The name of the index to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.
         * </p>
         * 
         * @param roleArn
         *        A new IAM role that gives Amazon Kendra permission to access your Amazon CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A new description for the index.
         * </p>
         * 
         * @param description
         *        A new description for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The document metadata to update.
         * </p>
         * 
         * @param documentMetadataConfigurationUpdates
         *        The document metadata to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates);

        /**
         * <p>
         * The document metadata to update.
         * </p>
         * 
         * @param documentMetadataConfigurationUpdates
         *        The document metadata to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurationUpdates(DocumentMetadataConfiguration... documentMetadataConfigurationUpdates);

        /**
         * <p>
         * The document metadata to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentMetadataConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<DocumentMetadataConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentMetadataConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentMetadataConfigurationUpdates(List<DocumentMetadataConfiguration>)}.
         * 
         * @param documentMetadataConfigurationUpdates
         *        a consumer that will call methods on {@link List<DocumentMetadataConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadataConfigurationUpdates(List<DocumentMetadataConfiguration>)
         */
        Builder documentMetadataConfigurationUpdates(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurationUpdates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String roleArn;

        private String description;

        private List<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIndexRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            roleArn(model.roleArn);
            description(model.description);
            documentMetadataConfigurationUpdates(model.documentMetadataConfigurationUpdates);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurationUpdates() {
            return documentMetadataConfigurationUpdates != null ? documentMetadataConfigurationUpdates.stream()
                    .map(DocumentMetadataConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier
                    .copy(documentMetadataConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(
                DocumentMetadataConfiguration... documentMetadataConfigurationUpdates) {
            documentMetadataConfigurationUpdates(Arrays.asList(documentMetadataConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurationUpdates(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurationUpdates) {
            documentMetadataConfigurationUpdates(Stream.of(documentMetadataConfigurationUpdates)
                    .map(c -> DocumentMetadataConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentMetadataConfigurationUpdates(
                Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurationUpdates) {
            this.documentMetadataConfigurationUpdates = DocumentMetadataConfigurationListCopier
                    .copyFromBuilder(documentMetadataConfigurationUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIndexRequest build() {
            return new UpdateIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
