/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFaqsResponse extends KendraResponse implements
        ToCopyableBuilder<ListFaqsResponse.Builder, ListFaqsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFaqsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FaqSummary>> FAQ_SUMMARY_ITEMS_FIELD = SdkField
            .<List<FaqSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListFaqsResponse::faqSummaryItems))
            .setter(setter(Builder::faqSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqSummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaqSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaqSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FAQ_SUMMARY_ITEMS_FIELD));

    private final String nextToken;

    private final List<FaqSummary> faqSummaryItems;

    private ListFaqsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.faqSummaryItems = builder.faqSummaryItems;
    }

    /**
     * <p>
     * The <code>ListFaqs</code> operation returns a page of FAQs at a time. The maximum size of the page is set by the
     * <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Kendra returns
     * the <code>NextPage</code> token. Include the token in the next request to the <code>ListFaqs</code> operation to
     * return the next page of FAQs.
     * </p>
     * 
     * @return The <code>ListFaqs</code> operation returns a page of FAQs at a time. The maximum size of the page is set
     *         by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon
     *         Kendra returns the <code>NextPage</code> token. Include the token in the next request to the
     *         <code>ListFaqs</code> operation to return the next page of FAQs.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the FaqSummaryItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFaqSummaryItems() {
        return faqSummaryItems != null && !(faqSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * information about the FAQs associated with the specified index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFaqSummaryItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return information about the FAQs associated with the specified index.
     */
    public List<FaqSummary> faqSummaryItems() {
        return faqSummaryItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(faqSummaryItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFaqsResponse)) {
            return false;
        }
        ListFaqsResponse other = (ListFaqsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(faqSummaryItems(), other.faqSummaryItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFaqsResponse").add("NextToken", nextToken()).add("FaqSummaryItems", faqSummaryItems())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FaqSummaryItems":
            return Optional.ofNullable(clazz.cast(faqSummaryItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFaqsResponse, T> g) {
        return obj -> g.apply((ListFaqsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFaqsResponse> {
        /**
         * <p>
         * The <code>ListFaqs</code> operation returns a page of FAQs at a time. The maximum size of the page is set by
         * the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Kendra
         * returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListFaqs</code>
         * operation to return the next page of FAQs.
         * </p>
         * 
         * @param nextToken
         *        The <code>ListFaqs</code> operation returns a page of FAQs at a time. The maximum size of the page is
         *        set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size,
         *        Amazon Kendra returns the <code>NextPage</code> token. Include the token in the next request to the
         *        <code>ListFaqs</code> operation to return the next page of FAQs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * information about the FAQs associated with the specified index.
         * </p>
         * 
         * @param faqSummaryItems
         *        information about the FAQs associated with the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqSummaryItems(Collection<FaqSummary> faqSummaryItems);

        /**
         * <p>
         * information about the FAQs associated with the specified index.
         * </p>
         * 
         * @param faqSummaryItems
         *        information about the FAQs associated with the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqSummaryItems(FaqSummary... faqSummaryItems);

        /**
         * <p>
         * information about the FAQs associated with the specified index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaqSummary>.Builder} avoiding the need to
         * create one manually via {@link List<FaqSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaqSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #faqSummaryItems(List<FaqSummary>)}.
         * 
         * @param faqSummaryItems
         *        a consumer that will call methods on {@link List<FaqSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faqSummaryItems(List<FaqSummary>)
         */
        Builder faqSummaryItems(Consumer<FaqSummary.Builder>... faqSummaryItems);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FaqSummary> faqSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFaqsResponse model) {
            super(model);
            nextToken(model.nextToken);
            faqSummaryItems(model.faqSummaryItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FaqSummary.Builder> getFaqSummaryItems() {
            return faqSummaryItems != null ? faqSummaryItems.stream().map(FaqSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder faqSummaryItems(Collection<FaqSummary> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copy(faqSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(FaqSummary... faqSummaryItems) {
            faqSummaryItems(Arrays.asList(faqSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(Consumer<FaqSummary.Builder>... faqSummaryItems) {
            faqSummaryItems(Stream.of(faqSummaryItems).map(c -> FaqSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFaqSummaryItems(Collection<FaqSummary.BuilderImpl> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copyFromBuilder(faqSummaryItems);
        }

        @Override
        public ListFaqsResponse build() {
            return new ListFaqsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
