/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gathers information about when a particular result was clicked by a user. Your application uses the
 * <a>SubmitFeedback</a> operation to provide click information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClickFeedback implements SdkPojo, Serializable, ToCopyableBuilder<ClickFeedback.Builder, ClickFeedback> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClickFeedback::resultId)).setter(setter(Builder::resultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()).build();

    private static final SdkField<Instant> CLICK_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ClickFeedback::clickTime)).setter(setter(Builder::clickTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClickTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD,
            CLICK_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resultId;

    private final Instant clickTime;

    private ClickFeedback(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.clickTime = builder.clickTime;
    }

    /**
     * <p>
     * The unique identifier of the search result that was clicked.
     * </p>
     * 
     * @return The unique identifier of the search result that was clicked.
     */
    public String resultId() {
        return resultId;
    }

    /**
     * <p>
     * The Unix timestamp of the data and time that the result was clicked.
     * </p>
     * 
     * @return The Unix timestamp of the data and time that the result was clicked.
     */
    public Instant clickTime() {
        return clickTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultId());
        hashCode = 31 * hashCode + Objects.hashCode(clickTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClickFeedback)) {
            return false;
        }
        ClickFeedback other = (ClickFeedback) obj;
        return Objects.equals(resultId(), other.resultId()) && Objects.equals(clickTime(), other.clickTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClickFeedback").add("ResultId", resultId()).add("ClickTime", clickTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultId":
            return Optional.ofNullable(clazz.cast(resultId()));
        case "ClickTime":
            return Optional.ofNullable(clazz.cast(clickTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClickFeedback, T> g) {
        return obj -> g.apply((ClickFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClickFeedback> {
        /**
         * <p>
         * The unique identifier of the search result that was clicked.
         * </p>
         * 
         * @param resultId
         *        The unique identifier of the search result that was clicked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultId(String resultId);

        /**
         * <p>
         * The Unix timestamp of the data and time that the result was clicked.
         * </p>
         * 
         * @param clickTime
         *        The Unix timestamp of the data and time that the result was clicked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clickTime(Instant clickTime);
    }

    static final class BuilderImpl implements Builder {
        private String resultId;

        private Instant clickTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClickFeedback model) {
            resultId(model.resultId);
            clickTime(model.clickTime);
        }

        public final String getResultId() {
            return resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public final Instant getClickTime() {
            return clickTime;
        }

        @Override
        public final Builder clickTime(Instant clickTime) {
            this.clickTime = clickTime;
            return this;
        }

        public final void setClickTime(Instant clickTime) {
            this.clickTime = clickTime;
        }

        @Override
        public ClickFeedback build() {
            return new ClickFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
