/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a custom document attribute. You can only provide one value for a custom attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentAttributeValue.Builder, DocumentAttributeValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentAttributeValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DocumentAttributeValue::stringListValue))
            .setter(setter(Builder::stringListValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringListValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DocumentAttributeValue::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongValue").build()).build();

    private static final SdkField<Instant> DATE_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DocumentAttributeValue::dateValue)).setter(setter(Builder::dateValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            STRING_LIST_VALUE_FIELD, LONG_VALUE_FIELD, DATE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final List<String> stringListValue;

    private final Long longValue;

    private final Instant dateValue;

    private DocumentAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.stringListValue = builder.stringListValue;
        this.longValue = builder.longValue;
        this.dateValue = builder.dateValue;
    }

    /**
     * <p>
     * A string, such as "department".
     * </p>
     * 
     * @return A string, such as "department".
     */
    public String stringValue() {
        return stringValue;
    }

    /**
     * Returns true if the StringListValue property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStringListValue() {
        return stringListValue != null && !(stringListValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStringListValue()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of strings.
     */
    public List<String> stringListValue() {
        return stringListValue;
    }

    /**
     * <p>
     * A long integer value.
     * </p>
     * 
     * @return A long integer value.
     */
    public Long longValue() {
        return longValue;
    }

    /**
     * <p>
     * A date value expressed as seconds from the Unix epoch.
     * </p>
     * 
     * @return A date value expressed as seconds from the Unix epoch.
     */
    public Instant dateValue() {
        return dateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringListValue());
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(dateValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValue)) {
            return false;
        }
        DocumentAttributeValue other = (DocumentAttributeValue) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(stringListValue(), other.stringListValue())
                && Objects.equals(longValue(), other.longValue()) && Objects.equals(dateValue(), other.dateValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DocumentAttributeValue").add("StringValue", stringValue())
                .add("StringListValue", stringListValue()).add("LongValue", longValue()).add("DateValue", dateValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "StringListValue":
            return Optional.ofNullable(clazz.cast(stringListValue()));
        case "LongValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "DateValue":
            return Optional.ofNullable(clazz.cast(dateValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValue, T> g) {
        return obj -> g.apply((DocumentAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentAttributeValue> {
        /**
         * <p>
         * A string, such as "department".
         * </p>
         * 
         * @param stringValue
         *        A string, such as "department".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * A list of strings.
         * </p>
         * 
         * @param stringListValue
         *        A list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(Collection<String> stringListValue);

        /**
         * <p>
         * A list of strings.
         * </p>
         * 
         * @param stringListValue
         *        A list of strings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(String... stringListValue);

        /**
         * <p>
         * A long integer value.
         * </p>
         * 
         * @param longValue
         *        A long integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * A date value expressed as seconds from the Unix epoch.
         * </p>
         * 
         * @param dateValue
         *        A date value expressed as seconds from the Unix epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateValue(Instant dateValue);
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();

        private Long longValue;

        private Instant dateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValue model) {
            stringValue(model.stringValue);
            stringListValue(model.stringListValue);
            longValue(model.longValue);
            dateValue(model.dateValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final Collection<String> getStringListValue() {
            return stringListValue;
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String... stringListValue) {
            stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            this.stringListValue = DocumentAttributeStringListValueCopier.copy(stringListValue);
        }

        public final Long getLongValue() {
            return longValue;
        }

        @Override
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        public final Instant getDateValue() {
            return dateValue;
        }

        @Override
        public final Builder dateValue(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDateValue(Instant dateValue) {
            this.dateValue = dateValue;
        }

        @Override
        public DocumentAttributeValue build() {
            return new DocumentAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
