/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeIndexResponse.Builder, DescribeIndexResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeIndexResponse::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeIndexResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeIndexResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<List<DocumentMetadataConfiguration>> DOCUMENT_METADATA_CONFIGURATIONS_FIELD = SdkField
            .<List<DocumentMetadataConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(DescribeIndexResponse::documentMetadataConfigurations))
            .setter(setter(Builder::documentMetadataConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadataConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentMetadataConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentMetadataConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IndexStatistics> INDEX_STATISTICS_FIELD = SdkField
            .<IndexStatistics> builder(MarshallingType.SDK_POJO).getter(getter(DescribeIndexResponse::indexStatistics))
            .setter(setter(Builder::indexStatistics)).constructor(IndexStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatistics").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, DOCUMENT_METADATA_CONFIGURATIONS_FIELD, INDEX_STATISTICS_FIELD, ERROR_MESSAGE_FIELD));

    private final String name;

    private final String id;

    private final String roleArn;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final String status;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<DocumentMetadataConfiguration> documentMetadataConfigurations;

    private final IndexStatistics indexStatistics;

    private final String errorMessage;

    private DescribeIndexResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.id = builder.id;
        this.roleArn = builder.roleArn;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.documentMetadataConfigurations = builder.documentMetadataConfigurations;
        this.indexStatistics = builder.indexStatistics;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the index.
     * </p>
     * 
     * @return The name of the index.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * the name of the index.
     * </p>
     * 
     * @return the name of the index.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon
     * Cloudwatch logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your
     *         Amazon Cloudwatch logs.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The identifier of the AWS KMS customer master key (CMK) used to encrypt your data. Amazon Kendra doesn't support
     * asymmetric CMKs.
     * </p>
     * 
     * @return The identifier of the AWS KMS customer master key (CMK) used to encrypt your data. Amazon Kendra doesn't
     *         support asymmetric CMKs.
     */
    public ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public IndexStatus status() {
        return IndexStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
     * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a message
     * that explains why.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
     *         the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
     *         a message that explains why.
     * @see IndexStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the index.
     * </p>
     * 
     * @return The description of the index.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Unix datetime that the index was created.
     * </p>
     * 
     * @return The Unix datetime that the index was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix datetime that the index was last updated.
     * </p>
     * 
     * @return The Unix datetime that the index was last updated.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns true if the DocumentMetadataConfigurations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasDocumentMetadataConfigurations() {
        return documentMetadataConfigurations != null && !(documentMetadataConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for any metadata applied to the documents in the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocumentMetadataConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration settings for any metadata applied to the documents in the index.
     */
    public List<DocumentMetadataConfiguration> documentMetadataConfigurations() {
        return documentMetadataConfigurations;
    }

    /**
     * <p>
     * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
     * </p>
     * 
     * @return Provides information about the number of FAQ questions and answers and the number of text documents
     *         indexed.
     */
    public IndexStatistics indexStatistics() {
        return indexStatistics;
    }

    /**
     * <p>
     * When th e<code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
     * message that explains why.
     * </p>
     * 
     * @return When th e<code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         contains a message that explains why.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(documentMetadataConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(documentMetadataConfigurations(), other.documentMetadataConfigurations())
                && Objects.equals(indexStatistics(), other.indexStatistics())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIndexResponse").add("Name", name()).add("Id", id()).add("RoleArn", roleArn())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration()).add("Status", statusAsString())
                .add("Description", description()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("DocumentMetadataConfigurations", documentMetadataConfigurations())
                .add("IndexStatistics", indexStatistics()).add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DocumentMetadataConfigurations":
            return Optional.ofNullable(clazz.cast(documentMetadataConfigurations()));
        case "IndexStatistics":
            return Optional.ofNullable(clazz.cast(indexStatistics()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexResponse, T> g) {
        return obj -> g.apply((DescribeIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIndexResponse> {
        /**
         * <p>
         * The name of the index.
         * </p>
         * 
         * @param name
         *        The name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * the name of the index.
         * </p>
         * 
         * @param id
         *        the name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon
         * Cloudwatch logs.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your
         *        Amazon Cloudwatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The identifier of the AWS KMS customer master key (CMK) used to encrypt your data. Amazon Kendra doesn't
         * support asymmetric CMKs.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The identifier of the AWS KMS customer master key (CMK) used to encrypt your data. Amazon Kendra
         *        doesn't support asymmetric CMKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The identifier of the AWS KMS customer master key (CMK) used to encrypt your data. Amazon Kendra doesn't
         * support asymmetric CMKs.
         * </p>
         * This is a convenience that creates an instance of the {@link ServerSideEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If the
         * <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains a
         * message that explains why.
         * </p>
         * 
         * @param status
         *        The current status of the index. When the value is <code>ACTIVE</code>, the index is ready for use. If
         *        the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder status(IndexStatus status);

        /**
         * <p>
         * The description of the index.
         * </p>
         * 
         * @param description
         *        The description of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Unix datetime that the index was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix datetime that the index was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix datetime that the index was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix datetime that the index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * 
         * @param documentMetadataConfigurations
         *        Configuration settings for any metadata applied to the documents in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurations(Collection<DocumentMetadataConfiguration> documentMetadataConfigurations);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * 
         * @param documentMetadataConfigurations
         *        Configuration settings for any metadata applied to the documents in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentMetadataConfigurations(DocumentMetadataConfiguration... documentMetadataConfigurations);

        /**
         * <p>
         * Configuration settings for any metadata applied to the documents in the index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentMetadataConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<DocumentMetadataConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentMetadataConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #documentMetadataConfigurations(List<DocumentMetadataConfiguration>)}.
         * 
         * @param documentMetadataConfigurations
         *        a consumer that will call methods on {@link List<DocumentMetadataConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentMetadataConfigurations(List<DocumentMetadataConfiguration>)
         */
        Builder documentMetadataConfigurations(Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurations);

        /**
         * <p>
         * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
         * </p>
         * 
         * @param indexStatistics
         *        Provides information about the number of FAQ questions and answers and the number of text documents
         *        indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatistics(IndexStatistics indexStatistics);

        /**
         * <p>
         * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
         * </p>
         * This is a convenience that creates an instance of the {@link IndexStatistics.Builder} avoiding the need to
         * create one manually via {@link IndexStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link IndexStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #indexStatistics(IndexStatistics)}.
         * 
         * @param indexStatistics
         *        a consumer that will call methods on {@link IndexStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexStatistics(IndexStatistics)
         */
        default Builder indexStatistics(Consumer<IndexStatistics.Builder> indexStatistics) {
            return indexStatistics(IndexStatistics.builder().applyMutation(indexStatistics).build());
        }

        /**
         * <p>
         * When th e<code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field contains
         * a message that explains why.
         * </p>
         * 
         * @param errorMessage
         *        When th e<code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        contains a message that explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String name;

        private String id;

        private String roleArn;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private String status;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private List<DocumentMetadataConfiguration> documentMetadataConfigurations = DefaultSdkAutoConstructList.getInstance();

        private IndexStatistics indexStatistics;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexResponse model) {
            super(model);
            name(model.name);
            id(model.id);
            roleArn(model.roleArn);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            status(model.status);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            documentMetadataConfigurations(model.documentMetadataConfigurations);
            indexStatistics(model.indexStatistics);
            errorMessage(model.errorMessage);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final Collection<DocumentMetadataConfiguration.Builder> getDocumentMetadataConfigurations() {
            return documentMetadataConfigurations != null ? documentMetadataConfigurations.stream()
                    .map(DocumentMetadataConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentMetadataConfigurations(
                Collection<DocumentMetadataConfiguration> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier.copy(documentMetadataConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(DocumentMetadataConfiguration... documentMetadataConfigurations) {
            documentMetadataConfigurations(Arrays.asList(documentMetadataConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentMetadataConfigurations(
                Consumer<DocumentMetadataConfiguration.Builder>... documentMetadataConfigurations) {
            documentMetadataConfigurations(Stream.of(documentMetadataConfigurations)
                    .map(c -> DocumentMetadataConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentMetadataConfigurations(
                Collection<DocumentMetadataConfiguration.BuilderImpl> documentMetadataConfigurations) {
            this.documentMetadataConfigurations = DocumentMetadataConfigurationListCopier
                    .copyFromBuilder(documentMetadataConfigurations);
        }

        public final IndexStatistics.Builder getIndexStatistics() {
            return indexStatistics != null ? indexStatistics.toBuilder() : null;
        }

        @Override
        public final Builder indexStatistics(IndexStatistics indexStatistics) {
            this.indexStatistics = indexStatistics;
            return this;
        }

        public final void setIndexStatistics(IndexStatistics.BuilderImpl indexStatistics) {
            this.indexStatistics = indexStatistics != null ? indexStatistics.build() : null;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public DescribeIndexResponse build() {
            return new DescribeIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
