/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a synchronization job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSyncJob implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSyncJob.Builder, DataSourceSyncJob> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSourceSyncJob::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSourceSyncJob::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DataSourceSyncJob::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSourceSyncJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSourceSyncJob::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSourceSyncJob::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> DATA_SOURCE_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataSourceSyncJob::dataSourceErrorCode)).setter(setter(Builder::dataSourceErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceErrorCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, DATA_SOURCE_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final Instant startTime;

    private final Instant endTime;

    private final String status;

    private final String errorMessage;

    private final String errorCode;

    private final String dataSourceErrorCode;

    private DataSourceSyncJob(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.dataSourceErrorCode = builder.dataSourceErrorCode;
    }

    /**
     * <p>
     * A unique identifier for the synchronization job.
     * </p>
     * 
     * @return A unique identifier for the synchronization job.
     */
    public String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The UNIX datetime that the synchronization job was started.
     * </p>
     * 
     * @return The UNIX datetime that the synchronization job was started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The UNIX datetime that the synchronization job was completed.
     * </p>
     * 
     * @return The UNIX datetime that the synchronization job was completed.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The execution status of the synchronization job. When the <code>Status</code> field is set to
     * <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>, the
     * <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The execution status of the synchronization job. When the <code>Status</code> field is set to
     *         <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>
     *         , the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * @see DataSourceSyncJobStatus
     */
    public DataSourceSyncJobStatus status() {
        return DataSourceSyncJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The execution status of the synchronization job. When the <code>Status</code> field is set to
     * <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>, the
     * <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceSyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The execution status of the synchronization job. When the <code>Status</code> field is set to
     *         <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>
     *         , the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
     * @see DataSourceSyncJobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the synchronization to fail.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the synchronization to fail.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains a the
     * reason that the synchronization failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains
     *         a the reason that the synchronization failed.
     * @see ErrorCode
     */
    public ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains a the
     * reason that the synchronization failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains
     *         a the reason that the synchronization failed.
     * @see ErrorCode
     */
    public String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * If the reason that the synchronization failed is due to an error with the underlying data source, this field
     * contains a code that identifies the error.
     * </p>
     * 
     * @return If the reason that the synchronization failed is due to an error with the underlying data source, this
     *         field contains a code that identifies the error.
     */
    public String dataSourceErrorCode() {
        return dataSourceErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceErrorCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSyncJob)) {
            return false;
        }
        DataSourceSyncJob other = (DataSourceSyncJob) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(dataSourceErrorCode(), other.dataSourceErrorCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSourceSyncJob").add("ExecutionId", executionId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Status", statusAsString()).add("ErrorMessage", errorMessage())
                .add("ErrorCode", errorCodeAsString()).add("DataSourceErrorCode", dataSourceErrorCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "DataSourceErrorCode":
            return Optional.ofNullable(clazz.cast(dataSourceErrorCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSyncJob, T> g) {
        return obj -> g.apply((DataSourceSyncJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSyncJob> {
        /**
         * <p>
         * A unique identifier for the synchronization job.
         * </p>
         * 
         * @param executionId
         *        A unique identifier for the synchronization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The UNIX datetime that the synchronization job was started.
         * </p>
         * 
         * @param startTime
         *        The UNIX datetime that the synchronization job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The UNIX datetime that the synchronization job was completed.
         * </p>
         * 
         * @param endTime
         *        The UNIX datetime that the synchronization job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The execution status of the synchronization job. When the <code>Status</code> field is set to
         * <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>,
         * the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
         * </p>
         * 
         * @param status
         *        The execution status of the synchronization job. When the <code>Status</code> field is set to
         *        <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to
         *        <code>FAILED</code>, the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the
         *        reason for the failure.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The execution status of the synchronization job. When the <code>Status</code> field is set to
         * <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to <code>FAILED</code>,
         * the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the reason for the failure.
         * </p>
         * 
         * @param status
         *        The execution status of the synchronization job. When the <code>Status</code> field is set to
         *        <code>SUCCEEDED</code>, the synchronization job is done. If the status code is set to
         *        <code>FAILED</code>, the <code>ErrorCode</code> and <code>ErrorMessage</code> fields give you the
         *        reason for the failure.
         * @see DataSourceSyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceSyncJobStatus
         */
        Builder status(DataSourceSyncJobStatus status);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
         * description of the error that caused the synchronization to fail.
         * </p>
         * 
         * @param errorMessage
         *        If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the synchronization to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains a
         * the reason that the synchronization failed.
         * </p>
         * 
         * @param errorCode
         *        If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field
         *        contains a the reason that the synchronization failed.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field contains a
         * the reason that the synchronization failed.
         * </p>
         * 
         * @param errorCode
         *        If the <code>Status</code> field is set to <code>FAILED</code>, the <code>ErrorCode</code> field
         *        contains a the reason that the synchronization failed.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * If the reason that the synchronization failed is due to an error with the underlying data source, this field
         * contains a code that identifies the error.
         * </p>
         * 
         * @param dataSourceErrorCode
         *        If the reason that the synchronization failed is due to an error with the underlying data source, this
         *        field contains a code that identifies the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceErrorCode(String dataSourceErrorCode);
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private Instant startTime;

        private Instant endTime;

        private String status;

        private String errorMessage;

        private String errorCode;

        private String dataSourceErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSyncJob model) {
            executionId(model.executionId);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            dataSourceErrorCode(model.dataSourceErrorCode);
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceSyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCodeAsString() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getDataSourceErrorCode() {
            return dataSourceErrorCode;
        }

        @Override
        public final Builder dataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
            return this;
        }

        public final void setDataSourceErrorCode(String dataSourceErrorCode) {
            this.dataSourceErrorCode = dataSourceErrorCode;
        }

        @Override
        public DataSourceSyncJob build() {
            return new DataSourceSyncJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
