/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a Amazon Kendra data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DataSourceConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final SdkField<SharePointConfiguration> SHARE_POINT_CONFIGURATION_FIELD = SdkField
            .<SharePointConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceConfiguration::sharePointConfiguration)).setter(setter(Builder::sharePointConfiguration))
            .constructor(SharePointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharePointConfiguration").build())
            .build();

    private static final SdkField<DatabaseConfiguration> DATABASE_CONFIGURATION_FIELD = SdkField
            .<DatabaseConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataSourceConfiguration::databaseConfiguration)).setter(setter(Builder::databaseConfiguration))
            .constructor(DatabaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD,
            SHARE_POINT_CONFIGURATION_FIELD, DATABASE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DataSourceConfiguration s3Configuration;

    private final SharePointConfiguration sharePointConfiguration;

    private final DatabaseConfiguration databaseConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
        this.sharePointConfiguration = builder.sharePointConfiguration;
        this.databaseConfiguration = builder.databaseConfiguration;
    }

    /**
     * <p>
     * Provides information to create a connector for a document repository in an Amazon S3 bucket.
     * </p>
     * 
     * @return Provides information to create a connector for a document repository in an Amazon S3 bucket.
     */
    public S3DataSourceConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * Provides information necessary to create a connector for a Microsoft SharePoint site.
     * </p>
     * 
     * @return Provides information necessary to create a connector for a Microsoft SharePoint site.
     */
    public SharePointConfiguration sharePointConfiguration() {
        return sharePointConfiguration;
    }

    /**
     * <p>
     * Provides information necessary to create a connector for a database.
     * </p>
     * 
     * @return Provides information necessary to create a connector for a database.
     */
    public DatabaseConfiguration databaseConfiguration() {
        return databaseConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(sharePointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(databaseConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(sharePointConfiguration(), other.sharePointConfiguration())
                && Objects.equals(databaseConfiguration(), other.databaseConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataSourceConfiguration").add("S3Configuration", s3Configuration())
                .add("SharePointConfiguration", sharePointConfiguration()).add("DatabaseConfiguration", databaseConfiguration())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "SharePointConfiguration":
            return Optional.ofNullable(clazz.cast(sharePointConfiguration()));
        case "DatabaseConfiguration":
            return Optional.ofNullable(clazz.cast(databaseConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * Provides information to create a connector for a document repository in an Amazon S3 bucket.
         * </p>
         * 
         * @param s3Configuration
         *        Provides information to create a connector for a document repository in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DataSourceConfiguration s3Configuration);

        /**
         * <p>
         * Provides information to create a connector for a document repository in an Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DataSourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3DataSourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DataSourceConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DataSourceConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DataSourceConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * Provides information necessary to create a connector for a Microsoft SharePoint site.
         * </p>
         * 
         * @param sharePointConfiguration
         *        Provides information necessary to create a connector for a Microsoft SharePoint site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePointConfiguration(SharePointConfiguration sharePointConfiguration);

        /**
         * <p>
         * Provides information necessary to create a connector for a Microsoft SharePoint site.
         * </p>
         * This is a convenience that creates an instance of the {@link SharePointConfiguration.Builder} avoiding the
         * need to create one manually via {@link SharePointConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SharePointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sharePointConfiguration(SharePointConfiguration)}.
         * 
         * @param sharePointConfiguration
         *        a consumer that will call methods on {@link SharePointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharePointConfiguration(SharePointConfiguration)
         */
        default Builder sharePointConfiguration(Consumer<SharePointConfiguration.Builder> sharePointConfiguration) {
            return sharePointConfiguration(SharePointConfiguration.builder().applyMutation(sharePointConfiguration).build());
        }

        /**
         * <p>
         * Provides information necessary to create a connector for a database.
         * </p>
         * 
         * @param databaseConfiguration
         *        Provides information necessary to create a connector for a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration);

        /**
         * <p>
         * Provides information necessary to create a connector for a database.
         * </p>
         * This is a convenience that creates an instance of the {@link DatabaseConfiguration.Builder} avoiding the need
         * to create one manually via {@link DatabaseConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatabaseConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #databaseConfiguration(DatabaseConfiguration)}.
         * 
         * @param databaseConfiguration
         *        a consumer that will call methods on {@link DatabaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseConfiguration(DatabaseConfiguration)
         */
        default Builder databaseConfiguration(Consumer<DatabaseConfiguration.Builder> databaseConfiguration) {
            return databaseConfiguration(DatabaseConfiguration.builder().applyMutation(databaseConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataSourceConfiguration s3Configuration;

        private SharePointConfiguration sharePointConfiguration;

        private DatabaseConfiguration databaseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            s3Configuration(model.s3Configuration);
            sharePointConfiguration(model.sharePointConfiguration);
            databaseConfiguration(model.databaseConfiguration);
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        @Override
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        public final SharePointConfiguration.Builder getSharePointConfiguration() {
            return sharePointConfiguration != null ? sharePointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sharePointConfiguration(SharePointConfiguration sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration;
            return this;
        }

        public final void setSharePointConfiguration(SharePointConfiguration.BuilderImpl sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration != null ? sharePointConfiguration.build() : null;
        }

        public final DatabaseConfiguration.Builder getDatabaseConfiguration() {
            return databaseConfiguration != null ? databaseConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder databaseConfiguration(DatabaseConfiguration databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration;
            return this;
        }

        public final void setDatabaseConfiguration(DatabaseConfiguration.BuilderImpl databaseConfiguration) {
            this.databaseConfiguration = databaseConfiguration != null ? databaseConfiguration.build() : null;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
