/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.model.AccessDeniedException;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest;
import software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponse;
import software.amazon.awssdk.services.kendra.model.ConflictException;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.CreateFaqRequest;
import software.amazon.awssdk.services.kendra.model.CreateFaqResponse;
import software.amazon.awssdk.services.kendra.model.CreateIndexRequest;
import software.amazon.awssdk.services.kendra.model.CreateIndexResponse;
import software.amazon.awssdk.services.kendra.model.DeleteFaqRequest;
import software.amazon.awssdk.services.kendra.model.DeleteFaqResponse;
import software.amazon.awssdk.services.kendra.model.DeleteIndexRequest;
import software.amazon.awssdk.services.kendra.model.DeleteIndexResponse;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.DescribeFaqRequest;
import software.amazon.awssdk.services.kendra.model.DescribeFaqResponse;
import software.amazon.awssdk.services.kendra.model.DescribeIndexRequest;
import software.amazon.awssdk.services.kendra.model.DescribeIndexResponse;
import software.amazon.awssdk.services.kendra.model.InternalServerException;
import software.amazon.awssdk.services.kendra.model.KendraException;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsResponse;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.kendra.model.ListFaqsRequest;
import software.amazon.awssdk.services.kendra.model.ListFaqsResponse;
import software.amazon.awssdk.services.kendra.model.ListIndicesRequest;
import software.amazon.awssdk.services.kendra.model.ListIndicesResponse;
import software.amazon.awssdk.services.kendra.model.QueryRequest;
import software.amazon.awssdk.services.kendra.model.QueryResponse;
import software.amazon.awssdk.services.kendra.model.ResourceAlreadyExistException;
import software.amazon.awssdk.services.kendra.model.ResourceInUseException;
import software.amazon.awssdk.services.kendra.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kendra.model.ResourceUnavailableException;
import software.amazon.awssdk.services.kendra.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StartDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobRequest;
import software.amazon.awssdk.services.kendra.model.StopDataSourceSyncJobResponse;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackRequest;
import software.amazon.awssdk.services.kendra.model.SubmitFeedbackResponse;
import software.amazon.awssdk.services.kendra.model.ThrottlingException;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.kendra.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.kendra.model.UpdateIndexRequest;
import software.amazon.awssdk.services.kendra.model.UpdateIndexResponse;
import software.amazon.awssdk.services.kendra.model.ValidationException;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourceSyncJobsIterable;
import software.amazon.awssdk.services.kendra.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.kendra.paginators.ListIndicesIterable;
import software.amazon.awssdk.services.kendra.transform.BatchDeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.BatchPutDocumentRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeFaqRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourceSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListFaqsRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StartDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.StopDataSourceSyncJobRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.SubmitFeedbackRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kendra.transform.UpdateIndexRequestMarshaller;

@SdkInternalApi
final class DefaultKendraClient
implements KendraClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKendraClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kendra";
    }

    @Override
    public BatchDeleteDocumentResponse batchDeleteDocument(BatchDeleteDocumentRequest batchDeleteDocumentRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDeleteDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDeleteDocumentRequest).withMarshaller((Marshaller)new BatchDeleteDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchPutDocumentResponse batchPutDocument(BatchPutDocumentRequest batchPutDocumentRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchPutDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchPutDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchPutDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchPutDocumentRequest).withMarshaller((Marshaller)new BatchPutDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataSourceRequest).withMarshaller((Marshaller)new CreateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateFaqResponse createFaq(CreateFaqRequest createFaqRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFaqRequest).withMarshaller((Marshaller)new CreateFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws ValidationException, ResourceAlreadyExistException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIndexRequest).withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFaqResponse deleteFaq(DeleteFaqRequest deleteFaqRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFaqRequest).withMarshaller((Marshaller)new DeleteFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIndexRequest).withMarshaller((Marshaller)new DeleteIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDataSourceRequest).withMarshaller((Marshaller)new DescribeDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFaqResponse describeFaq(DescribeFaqRequest describeFaqRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFaqResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFaqResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFaq").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFaqRequest).withMarshaller((Marshaller)new DescribeFaqRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeIndexResponse describeIndex(DescribeIndexRequest describeIndexRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIndexRequest).withMarshaller((Marshaller)new DescribeIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDataSourceSyncJobsResponse listDataSourceSyncJobs(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourceSyncJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDataSourceSyncJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSourceSyncJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourceSyncJobsRequest).withMarshaller((Marshaller)new ListDataSourceSyncJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDataSourceSyncJobsIterable listDataSourceSyncJobsPaginator(ListDataSourceSyncJobsRequest listDataSourceSyncJobsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListDataSourceSyncJobsIterable(this, this.applyPaginatorUserAgent(listDataSourceSyncJobsRequest));
    }

    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataSourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDataSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataSources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataSourcesRequest).withMarshaller((Marshaller)new ListDataSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListDataSourcesIterable(this, this.applyPaginatorUserAgent(listDataSourcesRequest));
    }

    @Override
    public ListFaqsResponse listFaqs(ListFaqsRequest listFaqsRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFaqsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFaqsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFaqs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFaqsRequest).withMarshaller((Marshaller)new ListFaqsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListIndicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIndicesRequest).withMarshaller((Marshaller)new ListIndicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListIndicesIterable listIndicesPaginator(ListIndicesRequest listIndicesRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        return new ListIndicesIterable(this, this.applyPaginatorUserAgent(listIndicesRequest));
    }

    @Override
    public QueryResponse query(QueryRequest queryRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryRequest).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartDataSourceSyncJobResponse startDataSourceSyncJob(StartDataSourceSyncJobRequest startDataSourceSyncJobRequest) throws ValidationException, ResourceNotFoundException, ResourceInUseException, ThrottlingException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDataSourceSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartDataSourceSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDataSourceSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDataSourceSyncJobRequest).withMarshaller((Marshaller)new StartDataSourceSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopDataSourceSyncJobResponse stopDataSourceSyncJob(StopDataSourceSyncJobRequest stopDataSourceSyncJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDataSourceSyncJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopDataSourceSyncJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDataSourceSyncJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDataSourceSyncJobRequest).withMarshaller((Marshaller)new StopDataSourceSyncJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SubmitFeedbackResponse submitFeedback(SubmitFeedbackRequest submitFeedbackRequest) throws ValidationException, ResourceUnavailableException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubmitFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SubmitFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubmitFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)submitFeedbackRequest).withMarshaller((Marshaller)new SubmitFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataSourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDataSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataSource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataSourceRequest).withMarshaller((Marshaller)new UpdateDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, KendraException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIndexRequest).withMarshaller((Marshaller)new UpdateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KendraException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistException").exceptionBuilderSupplier(ResourceAlreadyExistException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends KendraRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.88").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KendraRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

