/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides user and group information for document access filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Principal implements SdkPojo, Serializable, ToCopyableBuilder<Principal.Builder, Principal> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Principal::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Principal::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Principal::accessAsString)).setter(setter(Builder::access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String access;

    private Principal(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.access = builder.access;
    }

    /**
     * <p>
     * The name of the user or group.
     * </p>
     * 
     * @return The name of the user or group.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of principal.
     * @see PrincipalType
     */
    public PrincipalType type() {
        return PrincipalType.fromValue(type);
    }

    /**
     * <p>
     * The type of principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of principal.
     * @see PrincipalType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Whether to allow or deny access to the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ReadAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessAsString}.
     * </p>
     * 
     * @return Whether to allow or deny access to the principal.
     * @see ReadAccessType
     */
    public ReadAccessType access() {
        return ReadAccessType.fromValue(access);
    }

    /**
     * <p>
     * Whether to allow or deny access to the principal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #access} will
     * return {@link ReadAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessAsString}.
     * </p>
     * 
     * @return Whether to allow or deny access to the principal.
     * @see ReadAccessType
     */
    public String accessAsString() {
        return access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(accessAsString(), other.accessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Principal").add("Name", name()).add("Type", typeAsString()).add("Access", accessAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Access":
            return Optional.ofNullable(clazz.cast(accessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Principal> {
        /**
         * <p>
         * The name of the user or group.
         * </p>
         * 
         * @param name
         *        The name of the user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of principal.
         * </p>
         * 
         * @param type
         *        The type of principal.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of principal.
         * </p>
         * 
         * @param type
         *        The type of principal.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder type(PrincipalType type);

        /**
         * <p>
         * Whether to allow or deny access to the principal.
         * </p>
         * 
         * @param access
         *        Whether to allow or deny access to the principal.
         * @see ReadAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadAccessType
         */
        Builder access(String access);

        /**
         * <p>
         * Whether to allow or deny access to the principal.
         * </p>
         * 
         * @param access
         *        Whether to allow or deny access to the principal.
         * @see ReadAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadAccessType
         */
        Builder access(ReadAccessType access);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String access;

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            name(model.name);
            type(model.type);
            access(model.access);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PrincipalType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAccessAsString() {
            return access;
        }

        @Override
        public final Builder access(String access) {
            this.access = access;
            return this;
        }

        @Override
        public final Builder access(ReadAccessType access) {
            this.access(access == null ? null : access.toString());
            return this;
        }

        public final void setAccess(String access) {
            this.access = access;
        }

        @Override
        public Principal build() {
            return new Principal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
