/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of documents and the number of questions and answers in an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexStatistics implements SdkPojo, Serializable, ToCopyableBuilder<IndexStatistics.Builder, IndexStatistics> {
    private static final SdkField<FaqStatistics> FAQ_STATISTICS_FIELD = SdkField
            .<FaqStatistics> builder(MarshallingType.SDK_POJO).getter(getter(IndexStatistics::faqStatistics))
            .setter(setter(Builder::faqStatistics)).constructor(FaqStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqStatistics").build()).build();

    private static final SdkField<TextDocumentStatistics> TEXT_DOCUMENT_STATISTICS_FIELD = SdkField
            .<TextDocumentStatistics> builder(MarshallingType.SDK_POJO).getter(getter(IndexStatistics::textDocumentStatistics))
            .setter(setter(Builder::textDocumentStatistics)).constructor(TextDocumentStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDocumentStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAQ_STATISTICS_FIELD,
            TEXT_DOCUMENT_STATISTICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FaqStatistics faqStatistics;

    private final TextDocumentStatistics textDocumentStatistics;

    private IndexStatistics(BuilderImpl builder) {
        this.faqStatistics = builder.faqStatistics;
        this.textDocumentStatistics = builder.textDocumentStatistics;
    }

    /**
     * <p>
     * The number of question and answer topics in the index.
     * </p>
     * 
     * @return The number of question and answer topics in the index.
     */
    public FaqStatistics faqStatistics() {
        return faqStatistics;
    }

    /**
     * <p>
     * The number of text documents indexed.
     * </p>
     * 
     * @return The number of text documents indexed.
     */
    public TextDocumentStatistics textDocumentStatistics() {
        return textDocumentStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(faqStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(textDocumentStatistics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexStatistics)) {
            return false;
        }
        IndexStatistics other = (IndexStatistics) obj;
        return Objects.equals(faqStatistics(), other.faqStatistics())
                && Objects.equals(textDocumentStatistics(), other.textDocumentStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IndexStatistics").add("FaqStatistics", faqStatistics())
                .add("TextDocumentStatistics", textDocumentStatistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaqStatistics":
            return Optional.ofNullable(clazz.cast(faqStatistics()));
        case "TextDocumentStatistics":
            return Optional.ofNullable(clazz.cast(textDocumentStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexStatistics, T> g) {
        return obj -> g.apply((IndexStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexStatistics> {
        /**
         * <p>
         * The number of question and answer topics in the index.
         * </p>
         * 
         * @param faqStatistics
         *        The number of question and answer topics in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faqStatistics(FaqStatistics faqStatistics);

        /**
         * <p>
         * The number of question and answer topics in the index.
         * </p>
         * This is a convenience that creates an instance of the {@link FaqStatistics.Builder} avoiding the need to
         * create one manually via {@link FaqStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaqStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #faqStatistics(FaqStatistics)}.
         * 
         * @param faqStatistics
         *        a consumer that will call methods on {@link FaqStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faqStatistics(FaqStatistics)
         */
        default Builder faqStatistics(Consumer<FaqStatistics.Builder> faqStatistics) {
            return faqStatistics(FaqStatistics.builder().applyMutation(faqStatistics).build());
        }

        /**
         * <p>
         * The number of text documents indexed.
         * </p>
         * 
         * @param textDocumentStatistics
         *        The number of text documents indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDocumentStatistics(TextDocumentStatistics textDocumentStatistics);

        /**
         * <p>
         * The number of text documents indexed.
         * </p>
         * This is a convenience that creates an instance of the {@link TextDocumentStatistics.Builder} avoiding the
         * need to create one manually via {@link TextDocumentStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextDocumentStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #textDocumentStatistics(TextDocumentStatistics)}.
         * 
         * @param textDocumentStatistics
         *        a consumer that will call methods on {@link TextDocumentStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDocumentStatistics(TextDocumentStatistics)
         */
        default Builder textDocumentStatistics(Consumer<TextDocumentStatistics.Builder> textDocumentStatistics) {
            return textDocumentStatistics(TextDocumentStatistics.builder().applyMutation(textDocumentStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FaqStatistics faqStatistics;

        private TextDocumentStatistics textDocumentStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexStatistics model) {
            faqStatistics(model.faqStatistics);
            textDocumentStatistics(model.textDocumentStatistics);
        }

        public final FaqStatistics.Builder getFaqStatistics() {
            return faqStatistics != null ? faqStatistics.toBuilder() : null;
        }

        @Override
        public final Builder faqStatistics(FaqStatistics faqStatistics) {
            this.faqStatistics = faqStatistics;
            return this;
        }

        public final void setFaqStatistics(FaqStatistics.BuilderImpl faqStatistics) {
            this.faqStatistics = faqStatistics != null ? faqStatistics.build() : null;
        }

        public final TextDocumentStatistics.Builder getTextDocumentStatistics() {
            return textDocumentStatistics != null ? textDocumentStatistics.toBuilder() : null;
        }

        @Override
        public final Builder textDocumentStatistics(TextDocumentStatistics textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics;
            return this;
        }

        public final void setTextDocumentStatistics(TextDocumentStatistics.BuilderImpl textDocumentStatistics) {
            this.textDocumentStatistics = textDocumentStatistics != null ? textDocumentStatistics.build() : null;
        }

        @Override
        public IndexStatistics build() {
            return new IndexStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
