/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the properties of a custom index field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadataConfiguration.Builder, DocumentMetadataConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentMetadataConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DocumentMetadataConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Relevance> RELEVANCE_FIELD = SdkField.<Relevance> builder(MarshallingType.SDK_POJO)
            .getter(getter(DocumentMetadataConfiguration::relevance)).setter(setter(Builder::relevance))
            .constructor(Relevance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relevance").build()).build();

    private static final SdkField<Search> SEARCH_FIELD = SdkField.<Search> builder(MarshallingType.SDK_POJO)
            .getter(getter(DocumentMetadataConfiguration::search)).setter(setter(Builder::search)).constructor(Search::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Search").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            RELEVANCE_FIELD, SEARCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final Relevance relevance;

    private final Search search;

    private DocumentMetadataConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.relevance = builder.relevance;
        this.search = builder.search;
    }

    /**
     * <p>
     * The name of the index field.
     * </p>
     * 
     * @return The name of the index field.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the index field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the index field.
     * @see DocumentAttributeValueType
     */
    public DocumentAttributeValueType type() {
        return DocumentAttributeValueType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the index field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DocumentAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the index field.
     * @see DocumentAttributeValueType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Provides manual tuning parameters to determine how the field affects the search results.
     * </p>
     * 
     * @return Provides manual tuning parameters to determine how the field affects the search results.
     */
    public Relevance relevance() {
        return relevance;
    }

    /**
     * <p>
     * Provides information about how the field is used during a search.
     * </p>
     * 
     * @return Provides information about how the field is used during a search.
     */
    public Search search() {
        return search;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(relevance());
        hashCode = 31 * hashCode + Objects.hashCode(search());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadataConfiguration)) {
            return false;
        }
        DocumentMetadataConfiguration other = (DocumentMetadataConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(relevance(), other.relevance()) && Objects.equals(search(), other.search());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DocumentMetadataConfiguration").add("Name", name()).add("Type", typeAsString())
                .add("Relevance", relevance()).add("Search", search()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Relevance":
            return Optional.ofNullable(clazz.cast(relevance()));
        case "Search":
            return Optional.ofNullable(clazz.cast(search()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadataConfiguration, T> g) {
        return obj -> g.apply((DocumentMetadataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadataConfiguration> {
        /**
         * <p>
         * The name of the index field.
         * </p>
         * 
         * @param name
         *        The name of the index field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the index field.
         * </p>
         * 
         * @param type
         *        The data type of the index field.
         * @see DocumentAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeValueType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the index field.
         * </p>
         * 
         * @param type
         *        The data type of the index field.
         * @see DocumentAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeValueType
         */
        Builder type(DocumentAttributeValueType type);

        /**
         * <p>
         * Provides manual tuning parameters to determine how the field affects the search results.
         * </p>
         * 
         * @param relevance
         *        Provides manual tuning parameters to determine how the field affects the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevance(Relevance relevance);

        /**
         * <p>
         * Provides manual tuning parameters to determine how the field affects the search results.
         * </p>
         * This is a convenience that creates an instance of the {@link Relevance.Builder} avoiding the need to create
         * one manually via {@link Relevance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Relevance.Builder#build()} is called immediately and its result
         * is passed to {@link #relevance(Relevance)}.
         * 
         * @param relevance
         *        a consumer that will call methods on {@link Relevance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relevance(Relevance)
         */
        default Builder relevance(Consumer<Relevance.Builder> relevance) {
            return relevance(Relevance.builder().applyMutation(relevance).build());
        }

        /**
         * <p>
         * Provides information about how the field is used during a search.
         * </p>
         * 
         * @param search
         *        Provides information about how the field is used during a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder search(Search search);

        /**
         * <p>
         * Provides information about how the field is used during a search.
         * </p>
         * This is a convenience that creates an instance of the {@link Search.Builder} avoiding the need to create one
         * manually via {@link Search#builder()}.
         *
         * When the {@link Consumer} completes, {@link Search.Builder#build()} is called immediately and its result is
         * passed to {@link #search(Search)}.
         * 
         * @param search
         *        a consumer that will call methods on {@link Search.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #search(Search)
         */
        default Builder search(Consumer<Search.Builder> search) {
            return search(Search.builder().applyMutation(search).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private Relevance relevance;

        private Search search;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadataConfiguration model) {
            name(model.name);
            type(model.type);
            relevance(model.relevance);
            search(model.search);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentAttributeValueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Relevance.Builder getRelevance() {
            return relevance != null ? relevance.toBuilder() : null;
        }

        @Override
        public final Builder relevance(Relevance relevance) {
            this.relevance = relevance;
            return this;
        }

        public final void setRelevance(Relevance.BuilderImpl relevance) {
            this.relevance = relevance != null ? relevance.build() : null;
        }

        public final Search.Builder getSearch() {
            return search != null ? search.toBuilder() : null;
        }

        @Override
        public final Builder search(Search search) {
            this.search = search;
            return this;
        }

        public final void setSearch(Search.BuilderImpl search) {
            this.search = search != null ? search.build() : null;
        }

        @Override
        public DocumentMetadataConfiguration build() {
            return new DocumentMetadataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
