/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for crawling knowledge articles in the ServiceNow site.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNowKnowledgeArticleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNowKnowledgeArticleConfiguration.Builder, ServiceNowKnowledgeArticleConfiguration> {
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::crawlAttachments)).setter(setter(Builder::crawlAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()).build();

    private static final SdkField<List<String>> INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::includeAttachmentFilePatterns))
            .setter(setter(Builder::includeAttachmentFilePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAttachmentFilePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::excludeAttachmentFilePatterns))
            .setter(setter(Builder::excludeAttachmentFilePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeAttachmentFilePatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::documentDataFieldName))
            .setter(setter(Builder::documentDataFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build())
            .build();

    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::documentTitleFieldName))
            .setter(setter(Builder::documentTitleFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build())
            .build();

    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField
            .<List<DataSourceToIndexFieldMapping>> builder(MarshallingType.LIST)
            .getter(getter(ServiceNowKnowledgeArticleConfiguration::fieldMappings))
            .setter(setter(Builder::fieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ATTACHMENTS_FIELD,
            INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, DOCUMENT_DATA_FIELD_NAME_FIELD,
            DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean crawlAttachments;

    private final List<String> includeAttachmentFilePatterns;

    private final List<String> excludeAttachmentFilePatterns;

    private final String documentDataFieldName;

    private final String documentTitleFieldName;

    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private ServiceNowKnowledgeArticleConfiguration(BuilderImpl builder) {
        this.crawlAttachments = builder.crawlAttachments;
        this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
        this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    /**
     * <p>
     * Indicates whether Amazon Kendra should index attachments to knowledge articles.
     * </p>
     * 
     * @return Indicates whether Amazon Kendra should index attachments to knowledge articles.
     */
    public Boolean crawlAttachments() {
        return crawlAttachments;
    }

    /**
     * Returns true if the IncludeAttachmentFilePatterns property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasIncludeAttachmentFilePatterns() {
        return includeAttachmentFilePatterns != null && !(includeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are not
     * indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludeAttachmentFilePatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern
     *         are not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>.
     */
    public List<String> includeAttachmentFilePatterns() {
        return includeAttachmentFilePatterns;
    }

    /**
     * Returns true if the ExcludeAttachmentFilePatterns property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasExcludeAttachmentFilePatterns() {
        return excludeAttachmentFilePatterns != null && !(excludeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are not
     * indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludeAttachmentFilePatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern
     *         are not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>
     */
    public List<String> excludeAttachmentFilePatterns() {
        return excludeAttachmentFilePatterns;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
     * </p>
     * 
     * @return The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra
     *         index.
     */
    public String documentDataFieldName() {
        return documentDataFieldName;
    }

    /**
     * <p>
     * The name of the ServiceNow field that is mapped to the index document title field.
     * </p>
     * 
     * @return The name of the ServiceNow field that is mapped to the index document title field.
     */
    public String documentTitleFieldName() {
        return documentTitleFieldName;
    }

    /**
     * Returns true if the FieldMappings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFieldMappings() {
        return fieldMappings != null && !(fieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you map
     * the field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before
     *         you map the field.
     */
    public List<DataSourceToIndexFieldMapping> fieldMappings() {
        return fieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(includeAttachmentFilePatterns());
        hashCode = 31 * hashCode + Objects.hashCode(excludeAttachmentFilePatterns());
        hashCode = 31 * hashCode + Objects.hashCode(documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMappings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowKnowledgeArticleConfiguration)) {
            return false;
        }
        ServiceNowKnowledgeArticleConfiguration other = (ServiceNowKnowledgeArticleConfiguration) obj;
        return Objects.equals(crawlAttachments(), other.crawlAttachments())
                && Objects.equals(includeAttachmentFilePatterns(), other.includeAttachmentFilePatterns())
                && Objects.equals(excludeAttachmentFilePatterns(), other.excludeAttachmentFilePatterns())
                && Objects.equals(documentDataFieldName(), other.documentDataFieldName())
                && Objects.equals(documentTitleFieldName(), other.documentTitleFieldName())
                && Objects.equals(fieldMappings(), other.fieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceNowKnowledgeArticleConfiguration").add("CrawlAttachments", crawlAttachments())
                .add("IncludeAttachmentFilePatterns", includeAttachmentFilePatterns())
                .add("ExcludeAttachmentFilePatterns", excludeAttachmentFilePatterns())
                .add("DocumentDataFieldName", documentDataFieldName()).add("DocumentTitleFieldName", documentTitleFieldName())
                .add("FieldMappings", fieldMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlAttachments":
            return Optional.ofNullable(clazz.cast(crawlAttachments()));
        case "IncludeAttachmentFilePatterns":
            return Optional.ofNullable(clazz.cast(includeAttachmentFilePatterns()));
        case "ExcludeAttachmentFilePatterns":
            return Optional.ofNullable(clazz.cast(excludeAttachmentFilePatterns()));
        case "DocumentDataFieldName":
            return Optional.ofNullable(clazz.cast(documentDataFieldName()));
        case "DocumentTitleFieldName":
            return Optional.ofNullable(clazz.cast(documentTitleFieldName()));
        case "FieldMappings":
            return Optional.ofNullable(clazz.cast(fieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowKnowledgeArticleConfiguration, T> g) {
        return obj -> g.apply((ServiceNowKnowledgeArticleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNowKnowledgeArticleConfiguration> {
        /**
         * <p>
         * Indicates whether Amazon Kendra should index attachments to knowledge articles.
         * </p>
         * 
         * @param crawlAttachments
         *        Indicates whether Amazon Kendra should index attachments to knowledge articles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlAttachments(Boolean crawlAttachments);

        /**
         * <p>
         * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are
         * not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>.
         * </p>
         * 
         * @param includeAttachmentFilePatterns
         *        List of regular expressions applied to knowledge articles. Items that don't match the inclusion
         *        pattern are not indexed. The regex is applied to the field specified in the
         *        <code>PatternTargetField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns);

        /**
         * <p>
         * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are
         * not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>.
         * </p>
         * 
         * @param includeAttachmentFilePatterns
         *        List of regular expressions applied to knowledge articles. Items that don't match the inclusion
         *        pattern are not indexed. The regex is applied to the field specified in the
         *        <code>PatternTargetField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAttachmentFilePatterns(String... includeAttachmentFilePatterns);

        /**
         * <p>
         * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are
         * not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>
         * </p>
         * 
         * @param excludeAttachmentFilePatterns
         *        List of regular expressions applied to knowledge articles. Items that don't match the inclusion
         *        pattern are not indexed. The regex is applied to the field specified in the
         *        <code>PatternTargetField</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns);

        /**
         * <p>
         * List of regular expressions applied to knowledge articles. Items that don't match the inclusion pattern are
         * not indexed. The regex is applied to the field specified in the <code>PatternTargetField</code>
         * </p>
         * 
         * @param excludeAttachmentFilePatterns
         *        List of regular expressions applied to knowledge articles. Items that don't match the inclusion
         *        pattern are not indexed. The regex is applied to the field specified in the
         *        <code>PatternTargetField</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeAttachmentFilePatterns(String... excludeAttachmentFilePatterns);

        /**
         * <p>
         * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra
         * index.
         * </p>
         * 
         * @param documentDataFieldName
         *        The name of the ServiceNow field that is mapped to the index document contents field in the Amazon
         *        Kendra index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDataFieldName(String documentDataFieldName);

        /**
         * <p>
         * The name of the ServiceNow field that is mapped to the index document title field.
         * </p>
         * 
         * @param documentTitleFieldName
         *        The name of the ServiceNow field that is mapped to the index document title field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitleFieldName(String documentTitleFieldName);

        /**
         * <p>
         * Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you
         * map the field.
         * </p>
         * 
         * @param fieldMappings
         *        Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field
         *        before you map the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings);

        /**
         * <p>
         * Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you
         * map the field.
         * </p>
         * 
         * @param fieldMappings
         *        Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field
         *        before you map the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings);

        /**
         * <p>
         * Mapping between ServiceNow fields and Amazon Kendra index fields. You must create the index field before you
         * map the field.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSourceToIndexFieldMapping>.Builder}
         * avoiding the need to create one manually via {@link List<DataSourceToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSourceToIndexFieldMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMappings(List<DataSourceToIndexFieldMapping>)}.
         * 
         * @param fieldMappings
         *        a consumer that will call methods on {@link List<DataSourceToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMappings(List<DataSourceToIndexFieldMapping>)
         */
        Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private Boolean crawlAttachments;

        private List<String> includeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private String documentDataFieldName;

        private String documentTitleFieldName;

        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowKnowledgeArticleConfiguration model) {
            crawlAttachments(model.crawlAttachments);
            includeAttachmentFilePatterns(model.includeAttachmentFilePatterns);
            excludeAttachmentFilePatterns(model.excludeAttachmentFilePatterns);
            documentDataFieldName(model.documentDataFieldName);
            documentTitleFieldName(model.documentTitleFieldName);
            fieldMappings(model.fieldMappings);
        }

        public final Boolean getCrawlAttachments() {
            return crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final Collection<String> getIncludeAttachmentFilePatterns() {
            return includeAttachmentFilePatterns;
        }

        @Override
        public final Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeAttachmentFilePatterns(String... includeAttachmentFilePatterns) {
            includeAttachmentFilePatterns(Arrays.asList(includeAttachmentFilePatterns));
            return this;
        }

        public final void setIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
        }

        public final Collection<String> getExcludeAttachmentFilePatterns() {
            return excludeAttachmentFilePatterns;
        }

        @Override
        public final Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAttachmentFilePatterns(String... excludeAttachmentFilePatterns) {
            excludeAttachmentFilePatterns(Arrays.asList(excludeAttachmentFilePatterns));
            return this;
        }

        public final void setExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
        }

        public final String getDocumentDataFieldName() {
            return documentDataFieldName;
        }

        @Override
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        public final String getDocumentTitleFieldName() {
            return documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        public final Collection<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            return fieldMappings != null ? fieldMappings.stream().map(DataSourceToIndexFieldMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping... fieldMappings) {
            fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder>... fieldMappings) {
            fieldMappings(Stream.of(fieldMappings).map(c -> DataSourceToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public ServiceNowKnowledgeArticleConfiguration build() {
            return new ServiceNowKnowledgeArticleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
