/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the information necessary to connect to a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionConfiguration.Builder, ConnectionConfiguration> {
    private static final SdkField<String> DATABASE_HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionConfiguration::databaseHost)).setter(setter(Builder::databaseHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseHost").build()).build();

    private static final SdkField<Integer> DATABASE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ConnectionConfiguration::databasePort)).setter(setter(Builder::databasePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabasePort").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionConfiguration::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionConfiguration::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_HOST_FIELD,
            DATABASE_PORT_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, SECRET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseHost;

    private final Integer databasePort;

    private final String databaseName;

    private final String tableName;

    private final String secretArn;

    private ConnectionConfiguration(BuilderImpl builder) {
        this.databaseHost = builder.databaseHost;
        this.databasePort = builder.databasePort;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.secretArn = builder.secretArn;
    }

    /**
     * <p>
     * The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6
     * address.
     * </p>
     * 
     * @return The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or
     *         IPv6 address.
     */
    public String databaseHost() {
        return databaseHost;
    }

    /**
     * <p>
     * The port that the database uses for connections.
     * </p>
     * 
     * @return The port that the database uses for connections.
     */
    public Integer databasePort() {
        return databasePort;
    }

    /**
     * <p>
     * The name of the database containing the document data.
     * </p>
     * 
     * @return The name of the database containing the document data.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table that contains the document data.
     * </p>
     * 
     * @return The name of the table that contains the document data.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager. The credentials should be a
     * user/password pair. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data Source</a>.
     * For more information about AWS Secrets Manager, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is AWS Secrets Manager </a>
     * in the <i>AWS Secrets Manager</i> user guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager. The credentials should be a
     *         user/password pair. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data
     *         Source</a>. For more information about AWS Secrets Manager, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is AWS Secrets
     *         Manager </a> in the <i>AWS Secrets Manager</i> user guide.
     */
    public String secretArn() {
        return secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseHost());
        hashCode = 31 * hashCode + Objects.hashCode(databasePort());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration) obj;
        return Objects.equals(databaseHost(), other.databaseHost()) && Objects.equals(databasePort(), other.databasePort())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(secretArn(), other.secretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionConfiguration").add("DatabaseHost", databaseHost())
                .add("DatabasePort", databasePort()).add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("SecretArn", secretArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseHost":
            return Optional.ofNullable(clazz.cast(databaseHost()));
        case "DatabasePort":
            return Optional.ofNullable(clazz.cast(databasePort()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionConfiguration, T> g) {
        return obj -> g.apply((ConnectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionConfiguration> {
        /**
         * <p>
         * The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6
         * address.
         * </p>
         * 
         * @param databaseHost
         *        The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4
         *        or IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseHost(String databaseHost);

        /**
         * <p>
         * The port that the database uses for connections.
         * </p>
         * 
         * @param databasePort
         *        The port that the database uses for connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databasePort(Integer databasePort);

        /**
         * <p>
         * The name of the database containing the document data.
         * </p>
         * 
         * @param databaseName
         *        The name of the database containing the document data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table that contains the document data.
         * </p>
         * 
         * @param tableName
         *        The name of the table that contains the document data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager. The credentials should be a
         * user/password pair. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data
         * Source</a>. For more information about AWS Secrets Manager, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is AWS Secrets Manager
         * </a> in the <i>AWS Secrets Manager</i> user guide.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager. The credentials should be
         *        a user/password pair. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data
         *        Source</a>. For more information about AWS Secrets Manager, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is AWS Secrets
         *        Manager </a> in the <i>AWS Secrets Manager</i> user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);
    }

    static final class BuilderImpl implements Builder {
        private String databaseHost;

        private Integer databasePort;

        private String databaseName;

        private String tableName;

        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionConfiguration model) {
            databaseHost(model.databaseHost);
            databasePort(model.databasePort);
            databaseName(model.databaseName);
            tableName(model.tableName);
            secretArn(model.secretArn);
        }

        public final String getDatabaseHost() {
            return databaseHost;
        }

        @Override
        public final Builder databaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
            return this;
        }

        public final void setDatabaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
        }

        public final Integer getDatabasePort() {
            return databasePort;
        }

        @Override
        public final Builder databasePort(Integer databasePort) {
            this.databasePort = databasePort;
            return this;
        }

        public final void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public ConnectionConfiguration build() {
            return new ConnectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
