/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFaqRequest extends KendraRequest implements
        ToCopyableBuilder<CreateFaqRequest.Builder, CreateFaqRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFaqRequest::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFaqRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFaqRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<S3Path> S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFaqRequest::s3Path)).setter(setter(Builder::s3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFaqRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateFaqRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFaqRequest::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, S3_PATH_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, FILE_FORMAT_FIELD));

    private final String indexId;

    private final String name;

    private final String description;

    private final S3Path s3Path;

    private final String roleArn;

    private final List<Tag> tags;

    private final String fileFormat;

    private CreateFaqRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.s3Path = builder.s3Path;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.fileFormat = builder.fileFormat;
    }

    /**
     * <p>
     * The identifier of the index that contains the FAQ.
     * </p>
     * 
     * @return The identifier of the index that contains the FAQ.
     */
    public String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The name that should be associated with the FAQ.
     * </p>
     * 
     * @return The name that should be associated with the FAQ.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the FAQ.
     * </p>
     * 
     * @return A description of the FAQ.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The S3 location of the FAQ input data.
     * </p>
     * 
     * @return The S3 location of the FAQ input data.
     */
    public S3Path s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon
     * Kendra</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs.
     *         For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles
     *         for Amazon Kendra</a>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources and
     * to control access to resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
     *         resources and to control access to resources.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs
     * attributes in a header, and a JSON format that includes custom attributes.
     * </p>
     * <p>
     * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
     * parameter.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
     * questions and answers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the input file. You can choose between a basic CSV format, a CSV format that includes
     *         customs attributes in a header, and a JSON format that includes custom attributes.</p>
     *         <p>
     *         The format must match the format of the file stored in the S3 bucket identified in the
     *         <code>S3Path</code> parameter.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
     *         answers</a>.
     * @see FaqFileFormat
     */
    public FaqFileFormat fileFormat() {
        return FaqFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs
     * attributes in a header, and a JSON format that includes custom attributes.
     * </p>
     * <p>
     * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
     * parameter.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
     * questions and answers</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FaqFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the input file. You can choose between a basic CSV format, a CSV format that includes
     *         customs attributes in a header, and a JSON format that includes custom attributes.</p>
     *         <p>
     *         The format must match the format of the file stored in the S3 bucket identified in the
     *         <code>S3Path</code> parameter.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
     *         answers</a>.
     * @see FaqFileFormat
     */
    public String fileFormatAsString() {
        return fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFaqRequest)) {
            return false;
        }
        CreateFaqRequest other = (CreateFaqRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(tags(), other.tags())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFaqRequest").add("IndexId", indexId()).add("Name", name())
                .add("Description", description()).add("S3Path", s3Path()).add("RoleArn", roleArn()).add("Tags", tags())
                .add("FileFormat", fileFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFaqRequest, T> g) {
        return obj -> g.apply((CreateFaqRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFaqRequest> {
        /**
         * <p>
         * The identifier of the index that contains the FAQ.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index that contains the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The name that should be associated with the FAQ.
         * </p>
         * 
         * @param name
         *        The name that should be associated with the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the FAQ.
         * </p>
         * 
         * @param description
         *        A description of the FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The S3 location of the FAQ input data.
         * </p>
         * 
         * @param s3Path
         *        The S3 location of the FAQ input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(S3Path s3Path);

        /**
         * <p>
         * The S3 location of the FAQ input data.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Path.Builder} avoiding the need to create one
         * manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Path(S3Path)}.
         * 
         * @param s3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Path(S3Path)
         */
        default Builder s3Path(Consumer<S3Path.Builder> s3Path) {
            return s3Path(S3Path.builder().applyMutation(s3Path).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the FAQs. For
         * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
         * Amazon Kendra</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the S3 bucket that contains the
         *        FAQs. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for Amazon Kendra</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your
         *        resources and to control access to resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that identify the FAQ. You can use the tags to identify and organize your resources
         * and to control access to resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs
         * attributes in a header, and a JSON format that includes custom attributes.
         * </p>
         * <p>
         * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
         * parameter.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
         * questions and answers</a>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the input file. You can choose between a basic CSV format, a CSV format that includes
         *        customs attributes in a header, and a JSON format that includes custom attributes.</p>
         *        <p>
         *        The format must match the format of the file stored in the S3 bucket identified in the
         *        <code>S3Path</code> parameter.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
         *        answers</a>.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format of the input file. You can choose between a basic CSV format, a CSV format that includes customs
         * attributes in a header, and a JSON format that includes custom attributes.
         * </p>
         * <p>
         * The format must match the format of the file stored in the S3 bucket identified in the <code>S3Path</code>
         * parameter.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding
         * questions and answers</a>.
         * </p>
         * 
         * @param fileFormat
         *        The format of the input file. You can choose between a basic CSV format, a CSV format that includes
         *        customs attributes in a header, and a JSON format that includes custom attributes.</p>
         *        <p>
         *        The format must match the format of the file stored in the S3 bucket identified in the
         *        <code>S3Path</code> parameter.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html">Adding questions and
         *        answers</a>.
         * @see FaqFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FaqFileFormat
         */
        Builder fileFormat(FaqFileFormat fileFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String name;

        private String description;

        private S3Path s3Path;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFaqRequest model) {
            super(model);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            s3Path(model.s3Path);
            roleArn(model.roleArn);
            tags(model.tags);
            fileFormat(model.fileFormat);
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final S3Path.Builder getS3Path() {
            return s3Path != null ? s3Path.toBuilder() : null;
        }

        @Override
        public final Builder s3Path(S3Path s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final void setS3Path(S3Path.BuilderImpl s3Path) {
            this.s3Path = s3Path != null ? s3Path.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FaqFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFaqRequest build() {
            return new CreateFaqRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
