/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteDocumentResponse extends KendraResponse implements
        ToCopyableBuilder<BatchDeleteDocumentResponse.Builder, BatchDeleteDocumentResponse> {
    private static final SdkField<List<BatchDeleteDocumentResponseFailedDocument>> FAILED_DOCUMENTS_FIELD = SdkField
            .<List<BatchDeleteDocumentResponseFailedDocument>> builder(MarshallingType.LIST)
            .memberName("FailedDocuments")
            .getter(getter(BatchDeleteDocumentResponse::failedDocuments))
            .setter(setter(Builder::failedDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDeleteDocumentResponseFailedDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchDeleteDocumentResponseFailedDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_DOCUMENTS_FIELD));

    private final List<BatchDeleteDocumentResponseFailedDocument> failedDocuments;

    private BatchDeleteDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.failedDocuments = builder.failedDocuments;
    }

    /**
     * Returns true if the FailedDocuments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFailedDocuments() {
        return failedDocuments != null && !(failedDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of documents that could not be removed from the index. Each entry contains an error message that indicates
     * why the document couldn't be removed from the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedDocuments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of documents that could not be removed from the index. Each entry contains an error message that
     *         indicates why the document couldn't be removed from the index.
     */
    public List<BatchDeleteDocumentResponseFailedDocument> failedDocuments() {
        return failedDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedDocuments());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteDocumentResponse)) {
            return false;
        }
        BatchDeleteDocumentResponse other = (BatchDeleteDocumentResponse) obj;
        return Objects.equals(failedDocuments(), other.failedDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDeleteDocumentResponse").add("FailedDocuments", failedDocuments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedDocuments":
            return Optional.ofNullable(clazz.cast(failedDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteDocumentResponse, T> g) {
        return obj -> g.apply((BatchDeleteDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteDocumentResponse> {
        /**
         * <p>
         * A list of documents that could not be removed from the index. Each entry contains an error message that
         * indicates why the document couldn't be removed from the index.
         * </p>
         * 
         * @param failedDocuments
         *        A list of documents that could not be removed from the index. Each entry contains an error message
         *        that indicates why the document couldn't be removed from the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument> failedDocuments);

        /**
         * <p>
         * A list of documents that could not be removed from the index. Each entry contains an error message that
         * indicates why the document couldn't be removed from the index.
         * </p>
         * 
         * @param failedDocuments
         *        A list of documents that could not be removed from the index. Each entry contains an error message
         *        that indicates why the document couldn't be removed from the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDocuments(BatchDeleteDocumentResponseFailedDocument... failedDocuments);

        /**
         * <p>
         * A list of documents that could not be removed from the index. Each entry contains an error message that
         * indicates why the document couldn't be removed from the index.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchDeleteDocumentResponseFailedDocument>.Builder} avoiding the need to create one manually via
         * {@link List<BatchDeleteDocumentResponseFailedDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchDeleteDocumentResponseFailedDocument>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedDocuments(List<BatchDeleteDocumentResponseFailedDocument>)}.
         * 
         * @param failedDocuments
         *        a consumer that will call methods on {@link List<BatchDeleteDocumentResponseFailedDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedDocuments(List<BatchDeleteDocumentResponseFailedDocument>)
         */
        Builder failedDocuments(Consumer<BatchDeleteDocumentResponseFailedDocument.Builder>... failedDocuments);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<BatchDeleteDocumentResponseFailedDocument> failedDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteDocumentResponse model) {
            super(model);
            failedDocuments(model.failedDocuments);
        }

        public final Collection<BatchDeleteDocumentResponseFailedDocument.Builder> getFailedDocuments() {
            return failedDocuments != null ? failedDocuments.stream().map(BatchDeleteDocumentResponseFailedDocument::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument> failedDocuments) {
            this.failedDocuments = BatchDeleteDocumentResponseFailedDocumentsCopier.copy(failedDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(BatchDeleteDocumentResponseFailedDocument... failedDocuments) {
            failedDocuments(Arrays.asList(failedDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(Consumer<BatchDeleteDocumentResponseFailedDocument.Builder>... failedDocuments) {
            failedDocuments(Stream.of(failedDocuments)
                    .map(c -> BatchDeleteDocumentResponseFailedDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedDocuments(Collection<BatchDeleteDocumentResponseFailedDocument.BuilderImpl> failedDocuments) {
            this.failedDocuments = BatchDeleteDocumentResponseFailedDocumentsCopier.copyFromBuilder(failedDocuments);
        }

        @Override
        public BatchDeleteDocumentResponse build() {
            return new BatchDeleteDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
