/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResponse extends KendraResponse implements ToCopyableBuilder<QueryResponse.Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(QueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<List<QueryResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<QueryResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(QueryResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField
            .<List<FacetResult>> builder(MarshallingType.LIST)
            .memberName("FacetResults")
            .getter(getter(QueryResponse::facetResults))
            .setter(setter(Builder::facetResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FacetResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FacetResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfResults").getter(getter(QueryResponse::totalNumberOfResults))
            .setter(setter(Builder::totalNumberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            RESULT_ITEMS_FIELD, FACET_RESULTS_FIELD, TOTAL_NUMBER_OF_RESULTS_FIELD));

    private final String queryId;

    private final List<QueryResultItem> resultItems;

    private final List<FacetResult> facetResults;

    private final Integer totalNumberOfResults;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.resultItems = builder.resultItems;
        this.facetResults = builder.facetResults;
        this.totalNumberOfResults = builder.totalNumberOfResults;
    }

    /**
     * <p>
     * The unique identifier for the search. You use <code>QueryId</code> to identify the search when using the feedback
     * API.
     * </p>
     * 
     * @return The unique identifier for the search. You use <code>QueryId</code> to identify the search when using the
     *         feedback API.
     */
    public String queryId() {
        return queryId;
    }

    /**
     * Returns true if the ResultItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The results of the search.
     */
    public List<QueryResultItem> resultItems() {
        return resultItems;
    }

    /**
     * Returns true if the FacetResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFacetResults() {
        return facetResults != null && !(facetResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that was
     * specified in the <code>Facets</code> input parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFacetResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that
     *         was specified in the <code>Facets</code> input parameter.
     */
    public List<FacetResult> facetResults() {
        return facetResults;
    }

    /**
     * <p>
     * The total number of items found by the search; however, you can only retrieve up to 100 items. For example, if
     * the search found 192 items, you can only retrieve the first 100 of the items.
     * </p>
     * 
     * @return The total number of items found by the search; however, you can only retrieve up to 100 items. For
     *         example, if the search found 192 items, you can only retrieve the first 100 of the items.
     */
    public Integer totalNumberOfResults() {
        return totalNumberOfResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(resultItems());
        hashCode = 31 * hashCode + Objects.hashCode(facetResults());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(resultItems(), other.resultItems())
                && Objects.equals(facetResults(), other.facetResults())
                && Objects.equals(totalNumberOfResults(), other.totalNumberOfResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryResponse").add("QueryId", queryId()).add("ResultItems", resultItems())
                .add("FacetResults", facetResults()).add("TotalNumberOfResults", totalNumberOfResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        case "FacetResults":
            return Optional.ofNullable(clazz.cast(facetResults()));
        case "TotalNumberOfResults":
            return Optional.ofNullable(clazz.cast(totalNumberOfResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, QueryResponse> {
        /**
         * <p>
         * The unique identifier for the search. You use <code>QueryId</code> to identify the search when using the
         * feedback API.
         * </p>
         * 
         * @param queryId
         *        The unique identifier for the search. You use <code>QueryId</code> to identify the search when using
         *        the feedback API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The results of the search.
         * </p>
         * 
         * @param resultItems
         *        The results of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<QueryResultItem> resultItems);

        /**
         * <p>
         * The results of the search.
         * </p>
         * 
         * @param resultItems
         *        The results of the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(QueryResultItem... resultItems);

        /**
         * <p>
         * The results of the search.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QueryResultItem>.Builder} avoiding the need
         * to create one manually via {@link List<QueryResultItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueryResultItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #resultItems(List<QueryResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on {@link List<QueryResultItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(List<QueryResultItem>)
         */
        Builder resultItems(Consumer<QueryResultItem.Builder>... resultItems);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that was
         * specified in the <code>Facets</code> input parameter.
         * </p>
         * 
         * @param facetResults
         *        Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that
         *        was specified in the <code>Facets</code> input parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(Collection<FacetResult> facetResults);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that was
         * specified in the <code>Facets</code> input parameter.
         * </p>
         * 
         * @param facetResults
         *        Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that
         *        was specified in the <code>Facets</code> input parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetResults(FacetResult... facetResults);

        /**
         * <p>
         * Contains the facet results. A <code>FacetResult</code> contains the counts for each attribute key that was
         * specified in the <code>Facets</code> input parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FacetResult>.Builder} avoiding the need to
         * create one manually via {@link List<FacetResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FacetResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #facetResults(List<FacetResult>)}.
         * 
         * @param facetResults
         *        a consumer that will call methods on {@link List<FacetResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #facetResults(List<FacetResult>)
         */
        Builder facetResults(Consumer<FacetResult.Builder>... facetResults);

        /**
         * <p>
         * The total number of items found by the search; however, you can only retrieve up to 100 items. For example,
         * if the search found 192 items, you can only retrieve the first 100 of the items.
         * </p>
         * 
         * @param totalNumberOfResults
         *        The total number of items found by the search; however, you can only retrieve up to 100 items. For
         *        example, if the search found 192 items, you can only retrieve the first 100 of the items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfResults(Integer totalNumberOfResults);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String queryId;

        private List<QueryResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();

        private Integer totalNumberOfResults;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            queryId(model.queryId);
            resultItems(model.resultItems);
            facetResults(model.facetResults);
            totalNumberOfResults(model.totalNumberOfResults);
        }

        public final String getQueryId() {
            return queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public final Collection<QueryResultItem.Builder> getResultItems() {
            return resultItems != null ? resultItems.stream().map(QueryResultItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultItems(Collection<QueryResultItem> resultItems) {
            this.resultItems = QueryResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(QueryResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<QueryResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> QueryResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResultItems(Collection<QueryResultItem.BuilderImpl> resultItems) {
            this.resultItems = QueryResultItemListCopier.copyFromBuilder(resultItems);
        }

        public final Collection<FacetResult.Builder> getFacetResults() {
            return facetResults != null ? facetResults.stream().map(FacetResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult... facetResults) {
            facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder>... facetResults) {
            facetResults(Stream.of(facetResults).map(c -> FacetResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        public final Integer getTotalNumberOfResults() {
            return totalNumberOfResults;
        }

        @Override
        public final Builder totalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
            return this;
        }

        public final void setTotalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
