/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for the knowlege article types that Amazon Kendra indexes. Amazon Kendra indexes
 * standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge
 * articles, but not both
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceKnowledgeArticleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceKnowledgeArticleConfiguration.Builder, SalesforceKnowledgeArticleConfiguration> {
    private static final SdkField<List<String>> INCLUDED_STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludedStates")
            .getter(getter(SalesforceKnowledgeArticleConfiguration::includedStatesAsStrings))
            .setter(setter(Builder::includedStatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SalesforceStandardKnowledgeArticleTypeConfiguration> STANDARD_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATION_FIELD = SdkField
            .<SalesforceStandardKnowledgeArticleTypeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("StandardKnowledgeArticleTypeConfiguration")
            .getter(getter(SalesforceKnowledgeArticleConfiguration::standardKnowledgeArticleTypeConfiguration))
            .setter(setter(Builder::standardKnowledgeArticleTypeConfiguration))
            .constructor(SalesforceStandardKnowledgeArticleTypeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("StandardKnowledgeArticleTypeConfiguration").build()).build();

    private static final SdkField<List<SalesforceCustomKnowledgeArticleTypeConfiguration>> CUSTOM_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATIONS_FIELD = SdkField
            .<List<SalesforceCustomKnowledgeArticleTypeConfiguration>> builder(MarshallingType.LIST)
            .memberName("CustomKnowledgeArticleTypeConfigurations")
            .getter(getter(SalesforceKnowledgeArticleConfiguration::customKnowledgeArticleTypeConfigurations))
            .setter(setter(Builder::customKnowledgeArticleTypeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CustomKnowledgeArticleTypeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SalesforceCustomKnowledgeArticleTypeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SalesforceCustomKnowledgeArticleTypeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_STATES_FIELD,
            STANDARD_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATION_FIELD, CUSTOM_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> includedStates;

    private final SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration;

    private final List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations;

    private SalesforceKnowledgeArticleConfiguration(BuilderImpl builder) {
        this.includedStates = builder.includedStates;
        this.standardKnowledgeArticleTypeConfiguration = builder.standardKnowledgeArticleTypeConfiguration;
        this.customKnowledgeArticleTypeConfigurations = builder.customKnowledgeArticleTypeConfigurations;
    }

    /**
     * <p>
     * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
     * specify at least one state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludedStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You
     *         must specify at least one state.
     */
    public List<SalesforceKnowledgeArticleState> includedStates() {
        return SalesforceKnowledgeArticleStateListCopier.copyStringToEnum(includedStates);
    }

    /**
     * Returns true if the IncludedStates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIncludedStates() {
        return includedStates != null && !(includedStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
     * specify at least one state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIncludedStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You
     *         must specify at least one state.
     */
    public List<String> includedStatesAsStrings() {
        return includedStates;
    }

    /**
     * <p>
     * Provides configuration information for standard Salesforce knowledge articles.
     * </p>
     * 
     * @return Provides configuration information for standard Salesforce knowledge articles.
     */
    public SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration() {
        return standardKnowledgeArticleTypeConfiguration;
    }

    /**
     * Returns true if the CustomKnowledgeArticleTypeConfigurations property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasCustomKnowledgeArticleTypeConfigurations() {
        return customKnowledgeArticleTypeConfigurations != null
                && !(customKnowledgeArticleTypeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides configuration information for custom Salesforce knowledge articles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomKnowledgeArticleTypeConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides configuration information for custom Salesforce knowledge articles.
     */
    public List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations() {
        return customKnowledgeArticleTypeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includedStatesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(standardKnowledgeArticleTypeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customKnowledgeArticleTypeConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceKnowledgeArticleConfiguration)) {
            return false;
        }
        SalesforceKnowledgeArticleConfiguration other = (SalesforceKnowledgeArticleConfiguration) obj;
        return Objects.equals(includedStatesAsStrings(), other.includedStatesAsStrings())
                && Objects.equals(standardKnowledgeArticleTypeConfiguration(), other.standardKnowledgeArticleTypeConfiguration())
                && Objects.equals(customKnowledgeArticleTypeConfigurations(), other.customKnowledgeArticleTypeConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SalesforceKnowledgeArticleConfiguration").add("IncludedStates", includedStatesAsStrings())
                .add("StandardKnowledgeArticleTypeConfiguration", standardKnowledgeArticleTypeConfiguration())
                .add("CustomKnowledgeArticleTypeConfigurations", customKnowledgeArticleTypeConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludedStates":
            return Optional.ofNullable(clazz.cast(includedStatesAsStrings()));
        case "StandardKnowledgeArticleTypeConfiguration":
            return Optional.ofNullable(clazz.cast(standardKnowledgeArticleTypeConfiguration()));
        case "CustomKnowledgeArticleTypeConfigurations":
            return Optional.ofNullable(clazz.cast(customKnowledgeArticleTypeConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceKnowledgeArticleConfiguration, T> g) {
        return obj -> g.apply((SalesforceKnowledgeArticleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceKnowledgeArticleConfiguration> {
        /**
         * <p>
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
         * specify at least one state.
         * </p>
         * 
         * @param includedStates
         *        Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         *        You must specify at least one state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStatesWithStrings(Collection<String> includedStates);

        /**
         * <p>
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
         * specify at least one state.
         * </p>
         * 
         * @param includedStates
         *        Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         *        You must specify at least one state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStatesWithStrings(String... includedStates);

        /**
         * <p>
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
         * specify at least one state.
         * </p>
         * 
         * @param includedStates
         *        Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         *        You must specify at least one state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStates(Collection<SalesforceKnowledgeArticleState> includedStates);

        /**
         * <p>
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. You must
         * specify at least one state.
         * </p>
         * 
         * @param includedStates
         *        Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         *        You must specify at least one state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedStates(SalesforceKnowledgeArticleState... includedStates);

        /**
         * <p>
         * Provides configuration information for standard Salesforce knowledge articles.
         * </p>
         * 
         * @param standardKnowledgeArticleTypeConfiguration
         *        Provides configuration information for standard Salesforce knowledge articles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardKnowledgeArticleTypeConfiguration(
                SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration);

        /**
         * <p>
         * Provides configuration information for standard Salesforce knowledge articles.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SalesforceStandardKnowledgeArticleTypeConfiguration.Builder} avoiding the need to create one manually
         * via {@link SalesforceStandardKnowledgeArticleTypeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link SalesforceStandardKnowledgeArticleTypeConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration)}.
         * 
         * @param standardKnowledgeArticleTypeConfiguration
         *        a consumer that will call methods on
         *        {@link SalesforceStandardKnowledgeArticleTypeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration)
         */
        default Builder standardKnowledgeArticleTypeConfiguration(
                Consumer<SalesforceStandardKnowledgeArticleTypeConfiguration.Builder> standardKnowledgeArticleTypeConfiguration) {
            return standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration.builder()
                    .applyMutation(standardKnowledgeArticleTypeConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration information for custom Salesforce knowledge articles.
         * </p>
         * 
         * @param customKnowledgeArticleTypeConfigurations
         *        Provides configuration information for custom Salesforce knowledge articles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customKnowledgeArticleTypeConfigurations(
                Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations);

        /**
         * <p>
         * Provides configuration information for custom Salesforce knowledge articles.
         * </p>
         * 
         * @param customKnowledgeArticleTypeConfigurations
         *        Provides configuration information for custom Salesforce knowledge articles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customKnowledgeArticleTypeConfigurations(
                SalesforceCustomKnowledgeArticleTypeConfiguration... customKnowledgeArticleTypeConfigurations);

        /**
         * <p>
         * Provides configuration information for custom Salesforce knowledge articles.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <SalesforceCustomKnowledgeArticleTypeConfiguration>.Builder} avoiding the need to create one manually via
         * {@link List<SalesforceCustomKnowledgeArticleTypeConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <SalesforceCustomKnowledgeArticleTypeConfiguration>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #customKnowledgeArticleTypeConfigurations(List<SalesforceCustomKnowledgeArticleTypeConfiguration>)}.
         * 
         * @param customKnowledgeArticleTypeConfigurations
         *        a consumer that will call methods on {@link List
         *        <SalesforceCustomKnowledgeArticleTypeConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customKnowledgeArticleTypeConfigurations(List<SalesforceCustomKnowledgeArticleTypeConfiguration>)
         */
        Builder customKnowledgeArticleTypeConfigurations(
                Consumer<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder>... customKnowledgeArticleTypeConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<String> includedStates = DefaultSdkAutoConstructList.getInstance();

        private SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration;

        private List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceKnowledgeArticleConfiguration model) {
            includedStatesWithStrings(model.includedStates);
            standardKnowledgeArticleTypeConfiguration(model.standardKnowledgeArticleTypeConfiguration);
            customKnowledgeArticleTypeConfigurations(model.customKnowledgeArticleTypeConfigurations);
        }

        public final Collection<String> getIncludedStates() {
            return includedStates;
        }

        @Override
        public final Builder includedStatesWithStrings(Collection<String> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copy(includedStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedStatesWithStrings(String... includedStates) {
            includedStatesWithStrings(Arrays.asList(includedStates));
            return this;
        }

        @Override
        public final Builder includedStates(Collection<SalesforceKnowledgeArticleState> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copyEnumToString(includedStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedStates(SalesforceKnowledgeArticleState... includedStates) {
            includedStates(Arrays.asList(includedStates));
            return this;
        }

        public final void setIncludedStates(Collection<String> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copy(includedStates);
        }

        public final SalesforceStandardKnowledgeArticleTypeConfiguration.Builder getStandardKnowledgeArticleTypeConfiguration() {
            return standardKnowledgeArticleTypeConfiguration != null ? standardKnowledgeArticleTypeConfiguration.toBuilder()
                    : null;
        }

        @Override
        public final Builder standardKnowledgeArticleTypeConfiguration(
                SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration) {
            this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
            return this;
        }

        public final void setStandardKnowledgeArticleTypeConfiguration(
                SalesforceStandardKnowledgeArticleTypeConfiguration.BuilderImpl standardKnowledgeArticleTypeConfiguration) {
            this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration != null ? standardKnowledgeArticleTypeConfiguration
                    .build() : null;
        }

        public final Collection<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder> getCustomKnowledgeArticleTypeConfigurations() {
            return customKnowledgeArticleTypeConfigurations != null ? customKnowledgeArticleTypeConfigurations.stream()
                    .map(SalesforceCustomKnowledgeArticleTypeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customKnowledgeArticleTypeConfigurations(
                Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations = SalesforceCustomKnowledgeArticleTypeConfigurationListCopier
                    .copy(customKnowledgeArticleTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKnowledgeArticleTypeConfigurations(
                SalesforceCustomKnowledgeArticleTypeConfiguration... customKnowledgeArticleTypeConfigurations) {
            customKnowledgeArticleTypeConfigurations(Arrays.asList(customKnowledgeArticleTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKnowledgeArticleTypeConfigurations(
                Consumer<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder>... customKnowledgeArticleTypeConfigurations) {
            customKnowledgeArticleTypeConfigurations(Stream.of(customKnowledgeArticleTypeConfigurations)
                    .map(c -> SalesforceCustomKnowledgeArticleTypeConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCustomKnowledgeArticleTypeConfigurations(
                Collection<SalesforceCustomKnowledgeArticleTypeConfiguration.BuilderImpl> customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations = SalesforceCustomKnowledgeArticleTypeConfigurationListCopier
                    .copyFromBuilder(customKnowledgeArticleTypeConfigurations);
        }

        @Override
        public SalesforceKnowledgeArticleConfiguration build() {
            return new SalesforceKnowledgeArticleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
