/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information required to connect to a ServiceNow data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNowConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNowConfiguration.Builder, ServiceNowConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostUrl").getter(getter(ServiceNowConfiguration::hostUrl)).setter(setter(Builder::hostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostUrl").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ServiceNowConfiguration::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SERVICE_NOW_BUILD_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNowBuildVersion").getter(getter(ServiceNowConfiguration::serviceNowBuildVersionAsString))
            .setter(setter(Builder::serviceNowBuildVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNowBuildVersion").build())
            .build();

    private static final SdkField<ServiceNowKnowledgeArticleConfiguration> KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD = SdkField
            .<ServiceNowKnowledgeArticleConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KnowledgeArticleConfiguration")
            .getter(getter(ServiceNowConfiguration::knowledgeArticleConfiguration))
            .setter(setter(Builder::knowledgeArticleConfiguration))
            .constructor(ServiceNowKnowledgeArticleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeArticleConfiguration")
                    .build()).build();

    private static final SdkField<ServiceNowServiceCatalogConfiguration> SERVICE_CATALOG_CONFIGURATION_FIELD = SdkField
            .<ServiceNowServiceCatalogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceCatalogConfiguration")
            .getter(getter(ServiceNowConfiguration::serviceCatalogConfiguration))
            .setter(setter(Builder::serviceCatalogConfiguration))
            .constructor(ServiceNowServiceCatalogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD,
            SECRET_ARN_FIELD, SERVICE_NOW_BUILD_VERSION_FIELD, KNOWLEDGE_ARTICLE_CONFIGURATION_FIELD,
            SERVICE_CATALOG_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostUrl;

    private final String secretArn;

    private final String serviceNowBuildVersion;

    private final ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration;

    private final ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration;

    private ServiceNowConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.secretArn = builder.secretArn;
        this.serviceNowBuildVersion = builder.serviceNowBuildVersion;
        this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
        this.serviceCatalogConfiguration = builder.serviceCatalogConfiguration;
    }

    /**
     * <p>
     * The ServiceNow instance that the data source connects to. The host endpoint should look like the following:
     * <code>{instance}.service-now.com.</code>
     * </p>
     * 
     * @return The ServiceNow instance that the data source connects to. The host endpoint should look like the
     *         following: <code>{instance}.service-now.com.</code>
     */
    public String hostUrl() {
        return hostUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Secret Manager secret that contains the user name and password required
     * to connect to the ServiceNow instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Secret Manager secret that contains the user name and password
     *         required to connect to the ServiceNow instance.
     */
    public String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The identifier of the release that the ServiceNow host is running. If the host is not running the
     * <code>LONDON</code> release, use <code>OTHERS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNowBuildVersion} will return {@link ServiceNowBuildVersionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serviceNowBuildVersionAsString}.
     * </p>
     * 
     * @return The identifier of the release that the ServiceNow host is running. If the host is not running the
     *         <code>LONDON</code> release, use <code>OTHERS</code>.
     * @see ServiceNowBuildVersionType
     */
    public ServiceNowBuildVersionType serviceNowBuildVersion() {
        return ServiceNowBuildVersionType.fromValue(serviceNowBuildVersion);
    }

    /**
     * <p>
     * The identifier of the release that the ServiceNow host is running. If the host is not running the
     * <code>LONDON</code> release, use <code>OTHERS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNowBuildVersion} will return {@link ServiceNowBuildVersionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serviceNowBuildVersionAsString}.
     * </p>
     * 
     * @return The identifier of the release that the ServiceNow host is running. If the host is not running the
     *         <code>LONDON</code> release, use <code>OTHERS</code>.
     * @see ServiceNowBuildVersionType
     */
    public String serviceNowBuildVersionAsString() {
        return serviceNowBuildVersion;
    }

    /**
     * <p>
     * Provides configuration information for crawling knowledge articles in the ServiceNow site.
     * </p>
     * 
     * @return Provides configuration information for crawling knowledge articles in the ServiceNow site.
     */
    public ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration() {
        return knowledgeArticleConfiguration;
    }

    /**
     * <p>
     * Provides configuration information for crawling service catalogs in the ServiceNow site.
     * </p>
     * 
     * @return Provides configuration information for crawling service catalogs in the ServiceNow site.
     */
    public ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration() {
        return serviceCatalogConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNowBuildVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeArticleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCatalogConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowConfiguration)) {
            return false;
        }
        ServiceNowConfiguration other = (ServiceNowConfiguration) obj;
        return Objects.equals(hostUrl(), other.hostUrl()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(serviceNowBuildVersionAsString(), other.serviceNowBuildVersionAsString())
                && Objects.equals(knowledgeArticleConfiguration(), other.knowledgeArticleConfiguration())
                && Objects.equals(serviceCatalogConfiguration(), other.serviceCatalogConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceNowConfiguration").add("HostUrl", hostUrl()).add("SecretArn", secretArn())
                .add("ServiceNowBuildVersion", serviceNowBuildVersionAsString())
                .add("KnowledgeArticleConfiguration", knowledgeArticleConfiguration())
                .add("ServiceCatalogConfiguration", serviceCatalogConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostUrl":
            return Optional.ofNullable(clazz.cast(hostUrl()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "ServiceNowBuildVersion":
            return Optional.ofNullable(clazz.cast(serviceNowBuildVersionAsString()));
        case "KnowledgeArticleConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeArticleConfiguration()));
        case "ServiceCatalogConfiguration":
            return Optional.ofNullable(clazz.cast(serviceCatalogConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowConfiguration, T> g) {
        return obj -> g.apply((ServiceNowConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNowConfiguration> {
        /**
         * <p>
         * The ServiceNow instance that the data source connects to. The host endpoint should look like the following:
         * <code>{instance}.service-now.com.</code>
         * </p>
         * 
         * @param hostUrl
         *        The ServiceNow instance that the data source connects to. The host endpoint should look like the
         *        following: <code>{instance}.service-now.com.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostUrl(String hostUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Secret Manager secret that contains the user name and password
         * required to connect to the ServiceNow instance.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the AWS Secret Manager secret that contains the user name and
         *        password required to connect to the ServiceNow instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The identifier of the release that the ServiceNow host is running. If the host is not running the
         * <code>LONDON</code> release, use <code>OTHERS</code>.
         * </p>
         * 
         * @param serviceNowBuildVersion
         *        The identifier of the release that the ServiceNow host is running. If the host is not running the
         *        <code>LONDON</code> release, use <code>OTHERS</code>.
         * @see ServiceNowBuildVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowBuildVersionType
         */
        Builder serviceNowBuildVersion(String serviceNowBuildVersion);

        /**
         * <p>
         * The identifier of the release that the ServiceNow host is running. If the host is not running the
         * <code>LONDON</code> release, use <code>OTHERS</code>.
         * </p>
         * 
         * @param serviceNowBuildVersion
         *        The identifier of the release that the ServiceNow host is running. If the host is not running the
         *        <code>LONDON</code> release, use <code>OTHERS</code>.
         * @see ServiceNowBuildVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNowBuildVersionType
         */
        Builder serviceNowBuildVersion(ServiceNowBuildVersionType serviceNowBuildVersion);

        /**
         * <p>
         * Provides configuration information for crawling knowledge articles in the ServiceNow site.
         * </p>
         * 
         * @param knowledgeArticleConfiguration
         *        Provides configuration information for crawling knowledge articles in the ServiceNow site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration);

        /**
         * <p>
         * Provides configuration information for crawling knowledge articles in the ServiceNow site.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowKnowledgeArticleConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceNowKnowledgeArticleConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowKnowledgeArticleConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration)}.
         * 
         * @param knowledgeArticleConfiguration
         *        a consumer that will call methods on {@link ServiceNowKnowledgeArticleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration)
         */
        default Builder knowledgeArticleConfiguration(
                Consumer<ServiceNowKnowledgeArticleConfiguration.Builder> knowledgeArticleConfiguration) {
            return knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration.builder()
                    .applyMutation(knowledgeArticleConfiguration).build());
        }

        /**
         * <p>
         * Provides configuration information for crawling service catalogs in the ServiceNow site.
         * </p>
         * 
         * @param serviceCatalogConfiguration
         *        Provides configuration information for crawling service catalogs in the ServiceNow site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration);

        /**
         * <p>
         * Provides configuration information for crawling service catalogs in the ServiceNow site.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowServiceCatalogConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceNowServiceCatalogConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowServiceCatalogConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration)}.
         * 
         * @param serviceCatalogConfiguration
         *        a consumer that will call methods on {@link ServiceNowServiceCatalogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration)
         */
        default Builder serviceCatalogConfiguration(
                Consumer<ServiceNowServiceCatalogConfiguration.Builder> serviceCatalogConfiguration) {
            return serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration.builder()
                    .applyMutation(serviceCatalogConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hostUrl;

        private String secretArn;

        private String serviceNowBuildVersion;

        private ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration;

        private ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowConfiguration model) {
            hostUrl(model.hostUrl);
            secretArn(model.secretArn);
            serviceNowBuildVersion(model.serviceNowBuildVersion);
            knowledgeArticleConfiguration(model.knowledgeArticleConfiguration);
            serviceCatalogConfiguration(model.serviceCatalogConfiguration);
        }

        public final String getHostUrl() {
            return hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getServiceNowBuildVersion() {
            return serviceNowBuildVersion;
        }

        @Override
        public final Builder serviceNowBuildVersion(String serviceNowBuildVersion) {
            this.serviceNowBuildVersion = serviceNowBuildVersion;
            return this;
        }

        @Override
        public final Builder serviceNowBuildVersion(ServiceNowBuildVersionType serviceNowBuildVersion) {
            this.serviceNowBuildVersion(serviceNowBuildVersion == null ? null : serviceNowBuildVersion.toString());
            return this;
        }

        public final void setServiceNowBuildVersion(String serviceNowBuildVersion) {
            this.serviceNowBuildVersion = serviceNowBuildVersion;
        }

        public final ServiceNowKnowledgeArticleConfiguration.Builder getKnowledgeArticleConfiguration() {
            return knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfiguration knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
            return this;
        }

        public final void setKnowledgeArticleConfiguration(
                ServiceNowKnowledgeArticleConfiguration.BuilderImpl knowledgeArticleConfiguration) {
            this.knowledgeArticleConfiguration = knowledgeArticleConfiguration != null ? knowledgeArticleConfiguration.build()
                    : null;
        }

        public final ServiceNowServiceCatalogConfiguration.Builder getServiceCatalogConfiguration() {
            return serviceCatalogConfiguration != null ? serviceCatalogConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfiguration serviceCatalogConfiguration) {
            this.serviceCatalogConfiguration = serviceCatalogConfiguration;
            return this;
        }

        public final void setServiceCatalogConfiguration(
                ServiceNowServiceCatalogConfiguration.BuilderImpl serviceCatalogConfiguration) {
            this.serviceCatalogConfiguration = serviceCatalogConfiguration != null ? serviceCatalogConfiguration.build() : null;
        }

        @Override
        public ServiceNowConfiguration build() {
            return new ServiceNowConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
