/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for manually tuning the relevance of a field in a search. When a query includes terms that match
 * the field, the results are given a boost in the response based on these tuning parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relevance implements SdkPojo, Serializable, ToCopyableBuilder<Relevance.Builder, Relevance> {
    private static final SdkField<Boolean> FRESHNESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Freshness").getter(getter(Relevance::freshness)).setter(setter(Builder::freshness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Freshness").build()).build();

    private static final SdkField<Integer> IMPORTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Importance").getter(getter(Relevance::importance)).setter(setter(Builder::importance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Importance").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(Relevance::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> RANK_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RankOrder").getter(getter(Relevance::rankOrderAsString)).setter(setter(Builder::rankOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RankOrder").build()).build();

    private static final SdkField<Map<String, Integer>> VALUE_IMPORTANCE_MAP_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("ValueImportanceMap")
            .getter(getter(Relevance::valueImportanceMap))
            .setter(setter(Builder::valueImportanceMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueImportanceMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRESHNESS_FIELD,
            IMPORTANCE_FIELD, DURATION_FIELD, RANK_ORDER_FIELD, VALUE_IMPORTANCE_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean freshness;

    private final Integer importance;

    private final String duration;

    private final String rankOrder;

    private final Map<String, Integer> valueImportanceMap;

    private Relevance(BuilderImpl builder) {
        this.freshness = builder.freshness;
        this.importance = builder.importance;
        this.duration = builder.duration;
        this.rankOrder = builder.rankOrder;
        this.valueImportanceMap = builder.valueImportanceMap;
    }

    /**
     * <p>
     * Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on
     * November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You can only set
     * the <code>Freshness</code> field on one <code>DATE</code> type field. Only applies to <code>DATE</code> fields.
     * </p>
     * 
     * @return Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on
     *         November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You can
     *         only set the <code>Freshness</code> field on one <code>DATE</code> type field. Only applies to
     *         <code>DATE</code> fields.
     */
    public Boolean freshness() {
        return freshness;
    }

    /**
     * <p>
     * The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers.
     * </p>
     * 
     * @return The relative importance of the field in the search. Larger numbers provide more of a boost than smaller
     *         numbers.
     */
    public Integer importance() {
        return importance;
    }

    /**
     * <p>
     * Specifies the time period that the boost applies to. For example, to make the boost apply to documents with the
     * field value within the last month, you would use "2628000s". Once the field value is beyond the specified range,
     * the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you don't
     * specify a value, the default is 3 months. The value of the field is a numeric string followed by the character
     * "s", for example "86400s" for one day, or "604800s" for one week.
     * </p>
     * <p>
     * Only applies to <code>DATE</code> fields.
     * </p>
     * 
     * @return Specifies the time period that the boost applies to. For example, to make the boost apply to documents
     *         with the field value within the last month, you would use "2628000s". Once the field value is beyond the
     *         specified range, the effect of the boost drops off. The higher the importance, the faster the effect
     *         drops off. If you don't specify a value, the default is 3 months. The value of the field is a numeric
     *         string followed by the character "s", for example "86400s" for one day, or "604800s" for one week. </p>
     *         <p>
     *         Only applies to <code>DATE</code> fields.
     */
    public String duration() {
        return duration;
    }

    /**
     * <p>
     * Determines how values should be interpreted.
     * </p>
     * <p>
     * When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a
     * document with a rating score of 10 is higher ranking than a document with a rating score of 1.
     * </p>
     * <p>
     * When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a
     * task tracking application, a priority 1 task is more important than a priority 5 task.
     * </p>
     * <p>
     * Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rankOrder} will
     * return {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rankOrderAsString}.
     * </p>
     * 
     * @return Determines how values should be interpreted.</p>
     *         <p>
     *         When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example,
     *         a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
     *         </p>
     *         <p>
     *         When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example,
     *         in a task tracking application, a priority 1 task is more important than a priority 5 task.
     *         </p>
     *         <p>
     *         Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
     * @see Order
     */
    public Order rankOrder() {
        return Order.fromValue(rankOrder);
    }

    /**
     * <p>
     * Determines how values should be interpreted.
     * </p>
     * <p>
     * When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a
     * document with a rating score of 10 is higher ranking than a document with a rating score of 1.
     * </p>
     * <p>
     * When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a
     * task tracking application, a priority 1 task is more important than a priority 5 task.
     * </p>
     * <p>
     * Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rankOrder} will
     * return {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rankOrderAsString}.
     * </p>
     * 
     * @return Determines how values should be interpreted.</p>
     *         <p>
     *         When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example,
     *         a document with a rating score of 10 is higher ranking than a document with a rating score of 1.
     *         </p>
     *         <p>
     *         When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example,
     *         in a task tracking application, a priority 1 task is more important than a priority 5 task.
     *         </p>
     *         <p>
     *         Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
     * @see Order
     */
    public String rankOrderAsString() {
        return rankOrder;
    }

    /**
     * Returns true if the ValueImportanceMap property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValueImportanceMap() {
        return valueImportanceMap != null && !(valueImportanceMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of values that should be given a different boost when they appear in the result list. For example, if you
     * are boosting a field called "department," query terms that match the department field are boosted in the result.
     * However, you can add entries from the department field to boost documents with those values higher.
     * </p>
     * <p>
     * For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those
     * departments are given special attention when they appear in the metadata of a document. When those terms appear
     * they are given the specified importance instead of the regular importance for the boost.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValueImportanceMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of values that should be given a different boost when they appear in the result list. For example,
     *         if you are boosting a field called "department," query terms that match the department field are boosted
     *         in the result. However, you can add entries from the department field to boost documents with those
     *         values higher. </p>
     *         <p>
     *         For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3
     *         those departments are given special attention when they appear in the metadata of a document. When those
     *         terms appear they are given the specified importance instead of the regular importance for the boost.
     */
    public Map<String, Integer> valueImportanceMap() {
        return valueImportanceMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(freshness());
        hashCode = 31 * hashCode + Objects.hashCode(importance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(rankOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueImportanceMap());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relevance)) {
            return false;
        }
        Relevance other = (Relevance) obj;
        return Objects.equals(freshness(), other.freshness()) && Objects.equals(importance(), other.importance())
                && Objects.equals(duration(), other.duration()) && Objects.equals(rankOrderAsString(), other.rankOrderAsString())
                && Objects.equals(valueImportanceMap(), other.valueImportanceMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Relevance").add("Freshness", freshness()).add("Importance", importance())
                .add("Duration", duration()).add("RankOrder", rankOrderAsString())
                .add("ValueImportanceMap", valueImportanceMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Freshness":
            return Optional.ofNullable(clazz.cast(freshness()));
        case "Importance":
            return Optional.ofNullable(clazz.cast(importance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "RankOrder":
            return Optional.ofNullable(clazz.cast(rankOrderAsString()));
        case "ValueImportanceMap":
            return Optional.ofNullable(clazz.cast(valueImportanceMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relevance, T> g) {
        return obj -> g.apply((Relevance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relevance> {
        /**
         * <p>
         * Indicates that this field determines how "fresh" a document is. For example, if document 1 was created on
         * November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You can only
         * set the <code>Freshness</code> field on one <code>DATE</code> type field. Only applies to <code>DATE</code>
         * fields.
         * </p>
         * 
         * @param freshness
         *        Indicates that this field determines how "fresh" a document is. For example, if document 1 was created
         *        on November 5, and document 2 was created on October 31, document 1 is "fresher" than document 2. You
         *        can only set the <code>Freshness</code> field on one <code>DATE</code> type field. Only applies to
         *        <code>DATE</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freshness(Boolean freshness);

        /**
         * <p>
         * The relative importance of the field in the search. Larger numbers provide more of a boost than smaller
         * numbers.
         * </p>
         * 
         * @param importance
         *        The relative importance of the field in the search. Larger numbers provide more of a boost than
         *        smaller numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importance(Integer importance);

        /**
         * <p>
         * Specifies the time period that the boost applies to. For example, to make the boost apply to documents with
         * the field value within the last month, you would use "2628000s". Once the field value is beyond the specified
         * range, the effect of the boost drops off. The higher the importance, the faster the effect drops off. If you
         * don't specify a value, the default is 3 months. The value of the field is a numeric string followed by the
         * character "s", for example "86400s" for one day, or "604800s" for one week.
         * </p>
         * <p>
         * Only applies to <code>DATE</code> fields.
         * </p>
         * 
         * @param duration
         *        Specifies the time period that the boost applies to. For example, to make the boost apply to documents
         *        with the field value within the last month, you would use "2628000s". Once the field value is beyond
         *        the specified range, the effect of the boost drops off. The higher the importance, the faster the
         *        effect drops off. If you don't specify a value, the default is 3 months. The value of the field is a
         *        numeric string followed by the character "s", for example "86400s" for one day, or "604800s" for one
         *        week. </p>
         *        <p>
         *        Only applies to <code>DATE</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * Determines how values should be interpreted.
         * </p>
         * <p>
         * When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a
         * document with a rating score of 10 is higher ranking than a document with a rating score of 1.
         * </p>
         * <p>
         * When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a
         * task tracking application, a priority 1 task is more important than a priority 5 task.
         * </p>
         * <p>
         * Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
         * </p>
         * 
         * @param rankOrder
         *        Determines how values should be interpreted.</p>
         *        <p>
         *        When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For
         *        example, a document with a rating score of 10 is higher ranking than a document with a rating score of
         *        1.
         *        </p>
         *        <p>
         *        When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For
         *        example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
         *        </p>
         *        <p>
         *        Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder rankOrder(String rankOrder);

        /**
         * <p>
         * Determines how values should be interpreted.
         * </p>
         * <p>
         * When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For example, a
         * document with a rating score of 10 is higher ranking than a document with a rating score of 1.
         * </p>
         * <p>
         * When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For example, in a
         * task tracking application, a priority 1 task is more important than a priority 5 task.
         * </p>
         * <p>
         * Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
         * </p>
         * 
         * @param rankOrder
         *        Determines how values should be interpreted.</p>
         *        <p>
         *        When the <code>RankOrder</code> field is <code>ASCENDING</code>, higher numbers are better. For
         *        example, a document with a rating score of 10 is higher ranking than a document with a rating score of
         *        1.
         *        </p>
         *        <p>
         *        When the <code>RankOrder</code> field is <code>DESCENDING</code>, lower numbers are better. For
         *        example, in a task tracking application, a priority 1 task is more important than a priority 5 task.
         *        </p>
         *        <p>
         *        Only applies to <code>LONG</code> and <code>DOUBLE</code> fields.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder rankOrder(Order rankOrder);

        /**
         * <p>
         * A list of values that should be given a different boost when they appear in the result list. For example, if
         * you are boosting a field called "department," query terms that match the department field are boosted in the
         * result. However, you can add entries from the department field to boost documents with those values higher.
         * </p>
         * <p>
         * For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3 those
         * departments are given special attention when they appear in the metadata of a document. When those terms
         * appear they are given the specified importance instead of the regular importance for the boost.
         * </p>
         * 
         * @param valueImportanceMap
         *        A list of values that should be given a different boost when they appear in the result list. For
         *        example, if you are boosting a field called "department," query terms that match the department field
         *        are boosted in the result. However, you can add entries from the department field to boost documents
         *        with those values higher. </p>
         *        <p>
         *        For example, you can add entries to the map with names of departments. If you add "HR",5 and "Legal",3
         *        those departments are given special attention when they appear in the metadata of a document. When
         *        those terms appear they are given the specified importance instead of the regular importance for the
         *        boost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueImportanceMap(Map<String, Integer> valueImportanceMap);
    }

    static final class BuilderImpl implements Builder {
        private Boolean freshness;

        private Integer importance;

        private String duration;

        private String rankOrder;

        private Map<String, Integer> valueImportanceMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Relevance model) {
            freshness(model.freshness);
            importance(model.importance);
            duration(model.duration);
            rankOrder(model.rankOrder);
            valueImportanceMap(model.valueImportanceMap);
        }

        public final Boolean getFreshness() {
            return freshness;
        }

        @Override
        public final Builder freshness(Boolean freshness) {
            this.freshness = freshness;
            return this;
        }

        public final void setFreshness(Boolean freshness) {
            this.freshness = freshness;
        }

        public final Integer getImportance() {
            return importance;
        }

        @Override
        public final Builder importance(Integer importance) {
            this.importance = importance;
            return this;
        }

        public final void setImportance(Integer importance) {
            this.importance = importance;
        }

        public final String getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRankOrder() {
            return rankOrder;
        }

        @Override
        public final Builder rankOrder(String rankOrder) {
            this.rankOrder = rankOrder;
            return this;
        }

        @Override
        public final Builder rankOrder(Order rankOrder) {
            this.rankOrder(rankOrder == null ? null : rankOrder.toString());
            return this;
        }

        public final void setRankOrder(String rankOrder) {
            this.rankOrder = rankOrder;
        }

        public final Map<String, Integer> getValueImportanceMap() {
            return valueImportanceMap;
        }

        @Override
        public final Builder valueImportanceMap(Map<String, Integer> valueImportanceMap) {
            this.valueImportanceMap = ValueImportanceMapCopier.copy(valueImportanceMap);
            return this;
        }

        public final void setValueImportanceMap(Map<String, Integer> valueImportanceMap) {
            this.valueImportanceMap = ValueImportanceMapCopier.copy(valueImportanceMap);
        }

        @Override
        public Relevance build() {
            return new Relevance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
