/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ConfluenceSpaceFieldMappingsListCopier;
import software.amazon.awssdk.services.kendra.model.ConfluenceSpaceListCopier;
import software.amazon.awssdk.services.kendra.model.ConfluenceSpaceToIndexFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfluenceSpaceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfluenceSpaceConfiguration> {
    private static final SdkField<Boolean> CRAWL_PERSONAL_SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlPersonalSpaces").getter(ConfluenceSpaceConfiguration.getter(ConfluenceSpaceConfiguration::crawlPersonalSpaces)).setter(ConfluenceSpaceConfiguration.setter(Builder::crawlPersonalSpaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlPersonalSpaces").build()}).build();
    private static final SdkField<Boolean> CRAWL_ARCHIVED_SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlArchivedSpaces").getter(ConfluenceSpaceConfiguration.getter(ConfluenceSpaceConfiguration::crawlArchivedSpaces)).setter(ConfluenceSpaceConfiguration.setter(Builder::crawlArchivedSpaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlArchivedSpaces").build()}).build();
    private static final SdkField<List<String>> INCLUDE_SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeSpaces").getter(ConfluenceSpaceConfiguration.getter(ConfluenceSpaceConfiguration::includeSpaces)).setter(ConfluenceSpaceConfiguration.setter(Builder::includeSpaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeSpaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_SPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeSpaces").getter(ConfluenceSpaceConfiguration.getter(ConfluenceSpaceConfiguration::excludeSpaces)).setter(ConfluenceSpaceConfiguration.setter(Builder::excludeSpaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeSpaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ConfluenceSpaceToIndexFieldMapping>> SPACE_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpaceFieldMappings").getter(ConfluenceSpaceConfiguration.getter(ConfluenceSpaceConfiguration::spaceFieldMappings)).setter(ConfluenceSpaceConfiguration.setter(Builder::spaceFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfluenceSpaceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_PERSONAL_SPACES_FIELD, CRAWL_ARCHIVED_SPACES_FIELD, INCLUDE_SPACES_FIELD, EXCLUDE_SPACES_FIELD, SPACE_FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean crawlPersonalSpaces;
    private final Boolean crawlArchivedSpaces;
    private final List<String> includeSpaces;
    private final List<String> excludeSpaces;
    private final List<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings;

    private ConfluenceSpaceConfiguration(BuilderImpl builder) {
        this.crawlPersonalSpaces = builder.crawlPersonalSpaces;
        this.crawlArchivedSpaces = builder.crawlArchivedSpaces;
        this.includeSpaces = builder.includeSpaces;
        this.excludeSpaces = builder.excludeSpaces;
        this.spaceFieldMappings = builder.spaceFieldMappings;
    }

    public Boolean crawlPersonalSpaces() {
        return this.crawlPersonalSpaces;
    }

    public Boolean crawlArchivedSpaces() {
        return this.crawlArchivedSpaces;
    }

    public boolean hasIncludeSpaces() {
        return this.includeSpaces != null && !(this.includeSpaces instanceof SdkAutoConstructList);
    }

    public List<String> includeSpaces() {
        return this.includeSpaces;
    }

    public boolean hasExcludeSpaces() {
        return this.excludeSpaces != null && !(this.excludeSpaces instanceof SdkAutoConstructList);
    }

    public List<String> excludeSpaces() {
        return this.excludeSpaces;
    }

    public boolean hasSpaceFieldMappings() {
        return this.spaceFieldMappings != null && !(this.spaceFieldMappings instanceof SdkAutoConstructList);
    }

    public List<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings() {
        return this.spaceFieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlPersonalSpaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlArchivedSpaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeSpaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeSpaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceFieldMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceSpaceConfiguration)) {
            return false;
        }
        ConfluenceSpaceConfiguration other = (ConfluenceSpaceConfiguration)obj;
        return Objects.equals(this.crawlPersonalSpaces(), other.crawlPersonalSpaces()) && Objects.equals(this.crawlArchivedSpaces(), other.crawlArchivedSpaces()) && Objects.equals(this.includeSpaces(), other.includeSpaces()) && Objects.equals(this.excludeSpaces(), other.excludeSpaces()) && Objects.equals(this.spaceFieldMappings(), other.spaceFieldMappings());
    }

    public String toString() {
        return ToString.builder((String)"ConfluenceSpaceConfiguration").add("CrawlPersonalSpaces", (Object)this.crawlPersonalSpaces()).add("CrawlArchivedSpaces", (Object)this.crawlArchivedSpaces()).add("IncludeSpaces", this.includeSpaces()).add("ExcludeSpaces", this.excludeSpaces()).add("SpaceFieldMappings", this.spaceFieldMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlPersonalSpaces": {
                return Optional.ofNullable(clazz.cast(this.crawlPersonalSpaces()));
            }
            case "CrawlArchivedSpaces": {
                return Optional.ofNullable(clazz.cast(this.crawlArchivedSpaces()));
            }
            case "IncludeSpaces": {
                return Optional.ofNullable(clazz.cast(this.includeSpaces()));
            }
            case "ExcludeSpaces": {
                return Optional.ofNullable(clazz.cast(this.excludeSpaces()));
            }
            case "SpaceFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.spaceFieldMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceSpaceConfiguration, T> g) {
        return obj -> g.apply((ConfluenceSpaceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean crawlPersonalSpaces;
        private Boolean crawlArchivedSpaces;
        private List<String> includeSpaces = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeSpaces = DefaultSdkAutoConstructList.getInstance();
        private List<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceSpaceConfiguration model) {
            this.crawlPersonalSpaces(model.crawlPersonalSpaces);
            this.crawlArchivedSpaces(model.crawlArchivedSpaces);
            this.includeSpaces(model.includeSpaces);
            this.excludeSpaces(model.excludeSpaces);
            this.spaceFieldMappings(model.spaceFieldMappings);
        }

        public final Boolean getCrawlPersonalSpaces() {
            return this.crawlPersonalSpaces;
        }

        @Override
        public final Builder crawlPersonalSpaces(Boolean crawlPersonalSpaces) {
            this.crawlPersonalSpaces = crawlPersonalSpaces;
            return this;
        }

        public final void setCrawlPersonalSpaces(Boolean crawlPersonalSpaces) {
            this.crawlPersonalSpaces = crawlPersonalSpaces;
        }

        public final Boolean getCrawlArchivedSpaces() {
            return this.crawlArchivedSpaces;
        }

        @Override
        public final Builder crawlArchivedSpaces(Boolean crawlArchivedSpaces) {
            this.crawlArchivedSpaces = crawlArchivedSpaces;
            return this;
        }

        public final void setCrawlArchivedSpaces(Boolean crawlArchivedSpaces) {
            this.crawlArchivedSpaces = crawlArchivedSpaces;
        }

        public final Collection<String> getIncludeSpaces() {
            return this.includeSpaces;
        }

        @Override
        public final Builder includeSpaces(Collection<String> includeSpaces) {
            this.includeSpaces = ConfluenceSpaceListCopier.copy(includeSpaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeSpaces(String ... includeSpaces) {
            this.includeSpaces(Arrays.asList(includeSpaces));
            return this;
        }

        public final void setIncludeSpaces(Collection<String> includeSpaces) {
            this.includeSpaces = ConfluenceSpaceListCopier.copy(includeSpaces);
        }

        public final Collection<String> getExcludeSpaces() {
            return this.excludeSpaces;
        }

        @Override
        public final Builder excludeSpaces(Collection<String> excludeSpaces) {
            this.excludeSpaces = ConfluenceSpaceListCopier.copy(excludeSpaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeSpaces(String ... excludeSpaces) {
            this.excludeSpaces(Arrays.asList(excludeSpaces));
            return this;
        }

        public final void setExcludeSpaces(Collection<String> excludeSpaces) {
            this.excludeSpaces = ConfluenceSpaceListCopier.copy(excludeSpaces);
        }

        public final Collection<ConfluenceSpaceToIndexFieldMapping.Builder> getSpaceFieldMappings() {
            return this.spaceFieldMappings != null ? (Collection)this.spaceFieldMappings.stream().map(ConfluenceSpaceToIndexFieldMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spaceFieldMappings(Collection<ConfluenceSpaceToIndexFieldMapping> spaceFieldMappings) {
            this.spaceFieldMappings = ConfluenceSpaceFieldMappingsListCopier.copy(spaceFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaceFieldMappings(ConfluenceSpaceToIndexFieldMapping ... spaceFieldMappings) {
            this.spaceFieldMappings(Arrays.asList(spaceFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spaceFieldMappings(Consumer<ConfluenceSpaceToIndexFieldMapping.Builder> ... spaceFieldMappings) {
            this.spaceFieldMappings(Stream.of(spaceFieldMappings).map(c -> (ConfluenceSpaceToIndexFieldMapping)((ConfluenceSpaceToIndexFieldMapping.Builder)ConfluenceSpaceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpaceFieldMappings(Collection<ConfluenceSpaceToIndexFieldMapping.BuilderImpl> spaceFieldMappings) {
            this.spaceFieldMappings = ConfluenceSpaceFieldMappingsListCopier.copyFromBuilder(spaceFieldMappings);
        }

        public ConfluenceSpaceConfiguration build() {
            return new ConfluenceSpaceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfluenceSpaceConfiguration> {
        public Builder crawlPersonalSpaces(Boolean var1);

        public Builder crawlArchivedSpaces(Boolean var1);

        public Builder includeSpaces(Collection<String> var1);

        public Builder includeSpaces(String ... var1);

        public Builder excludeSpaces(Collection<String> var1);

        public Builder excludeSpaces(String ... var1);

        public Builder spaceFieldMappings(Collection<ConfluenceSpaceToIndexFieldMapping> var1);

        public Builder spaceFieldMappings(ConfluenceSpaceToIndexFieldMapping ... var1);

        public Builder spaceFieldMappings(Consumer<ConfluenceSpaceToIndexFieldMapping.Builder> ... var1);
    }
}

