/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a relative ranking that indicates how confident Amazon Kendra is that the response matches the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScoreAttributes implements SdkPojo, Serializable, ToCopyableBuilder<ScoreAttributes.Builder, ScoreAttributes> {
    private static final SdkField<String> SCORE_CONFIDENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScoreConfidence").getter(getter(ScoreAttributes::scoreConfidenceAsString))
            .setter(setter(Builder::scoreConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreConfidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scoreConfidence;

    private ScoreAttributes(BuilderImpl builder) {
        this.scoreConfidence = builder.scoreConfidence;
    }

    /**
     * <p>
     * A relative ranking for how well the response matches the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scoreConfidence}
     * will return {@link ScoreConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scoreConfidenceAsString}.
     * </p>
     * 
     * @return A relative ranking for how well the response matches the query.
     * @see ScoreConfidence
     */
    public ScoreConfidence scoreConfidence() {
        return ScoreConfidence.fromValue(scoreConfidence);
    }

    /**
     * <p>
     * A relative ranking for how well the response matches the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scoreConfidence}
     * will return {@link ScoreConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scoreConfidenceAsString}.
     * </p>
     * 
     * @return A relative ranking for how well the response matches the query.
     * @see ScoreConfidence
     */
    public String scoreConfidenceAsString() {
        return scoreConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scoreConfidenceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScoreAttributes)) {
            return false;
        }
        ScoreAttributes other = (ScoreAttributes) obj;
        return Objects.equals(scoreConfidenceAsString(), other.scoreConfidenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScoreAttributes").add("ScoreConfidence", scoreConfidenceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScoreConfidence":
            return Optional.ofNullable(clazz.cast(scoreConfidenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScoreAttributes, T> g) {
        return obj -> g.apply((ScoreAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScoreAttributes> {
        /**
         * <p>
         * A relative ranking for how well the response matches the query.
         * </p>
         * 
         * @param scoreConfidence
         *        A relative ranking for how well the response matches the query.
         * @see ScoreConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScoreConfidence
         */
        Builder scoreConfidence(String scoreConfidence);

        /**
         * <p>
         * A relative ranking for how well the response matches the query.
         * </p>
         * 
         * @param scoreConfidence
         *        A relative ranking for how well the response matches the query.
         * @see ScoreConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScoreConfidence
         */
        Builder scoreConfidence(ScoreConfidence scoreConfidence);
    }

    static final class BuilderImpl implements Builder {
        private String scoreConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ScoreAttributes model) {
            scoreConfidence(model.scoreConfidence);
        }

        public final String getScoreConfidence() {
            return scoreConfidence;
        }

        @Override
        public final Builder scoreConfidence(String scoreConfidence) {
            this.scoreConfidence = scoreConfidence;
            return this;
        }

        @Override
        public final Builder scoreConfidence(ScoreConfidence scoreConfidence) {
            this.scoreConfidence(scoreConfidence == null ? null : scoreConfidence.toString());
            return this;
        }

        public final void setScoreConfidence(String scoreConfidence) {
            this.scoreConfidence = scoreConfidence;
        }

        @Override
        public ScoreAttributes build() {
            return new ScoreAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
