/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the document attribute to use to sort the response to a Amazon Kendra query. You can specify a single
 * attribute for sorting. The attribute must have the <code>Sortable</code> flag set to <code>true</code>, otherwise
 * Amazon Kendra returns an exception.
 * </p>
 * <p>
 * You can sort attributes of the following types.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Date value
 * </p>
 * </li>
 * <li>
 * <p>
 * Long value
 * </p>
 * </li>
 * <li>
 * <p>
 * String value
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can't sort attributes of the following type.
 * </p>
 * <ul>
 * <li>
 * <p>
 * String list value
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SortingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SortingConfiguration.Builder, SortingConfiguration> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentAttributeKey").getter(getter(SortingConfiguration::documentAttributeKey))
            .setter(setter(Builder::documentAttributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(SortingConfiguration::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD,
            SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentAttributeKey;

    private final String sortOrder;

    private SortingConfiguration(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The name of the document attribute used to sort the response. You can use any field that has the
     * <code>Sortable</code> flag set to true.
     * </p>
     * <p>
     * You can also sort by any of the following built-in attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * _category
     * </p>
     * </li>
     * <li>
     * <p>
     * _created_at
     * </p>
     * </li>
     * <li>
     * <p>
     * _last_updated_at
     * </p>
     * </li>
     * <li>
     * <p>
     * _version
     * </p>
     * </li>
     * <li>
     * <p>
     * _view_count
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the document attribute used to sort the response. You can use any field that has the
     *         <code>Sortable</code> flag set to true.</p>
     *         <p>
     *         You can also sort by any of the following built-in attributes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         _category
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _created_at
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _last_updated_at
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _version
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         _view_count
     *         </p>
     *         </li>
     */
    public String documentAttributeKey() {
        return documentAttributeKey;
    }

    /**
     * <p>
     * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon
     * Kendra is used as the tie-breaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order that the results should be returned in. In case of ties, the relevance assigned to the result
     *         by Amazon Kendra is used as the tie-breaker.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon
     * Kendra is used as the tie-breaker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order that the results should be returned in. In case of ties, the relevance assigned to the result
     *         by Amazon Kendra is used as the tie-breaker.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortingConfiguration)) {
            return false;
        }
        SortingConfiguration other = (SortingConfiguration) obj;
        return Objects.equals(documentAttributeKey(), other.documentAttributeKey())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SortingConfiguration").add("DocumentAttributeKey", documentAttributeKey())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeKey":
            return Optional.ofNullable(clazz.cast(documentAttributeKey()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortingConfiguration, T> g) {
        return obj -> g.apply((SortingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SortingConfiguration> {
        /**
         * <p>
         * The name of the document attribute used to sort the response. You can use any field that has the
         * <code>Sortable</code> flag set to true.
         * </p>
         * <p>
         * You can also sort by any of the following built-in attributes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * _category
         * </p>
         * </li>
         * <li>
         * <p>
         * _created_at
         * </p>
         * </li>
         * <li>
         * <p>
         * _last_updated_at
         * </p>
         * </li>
         * <li>
         * <p>
         * _version
         * </p>
         * </li>
         * <li>
         * <p>
         * _view_count
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentAttributeKey
         *        The name of the document attribute used to sort the response. You can use any field that has the
         *        <code>Sortable</code> flag set to true.</p>
         *        <p>
         *        You can also sort by any of the following built-in attributes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        _category
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _created_at
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _last_updated_at
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _version
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        _view_count
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeKey(String documentAttributeKey);

        /**
         * <p>
         * The order that the results should be returned in. In case of ties, the relevance assigned to the result by
         * Amazon Kendra is used as the tie-breaker.
         * </p>
         * 
         * @param sortOrder
         *        The order that the results should be returned in. In case of ties, the relevance assigned to the
         *        result by Amazon Kendra is used as the tie-breaker.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order that the results should be returned in. In case of ties, the relevance assigned to the result by
         * Amazon Kendra is used as the tie-breaker.
         * </p>
         * 
         * @param sortOrder
         *        The order that the results should be returned in. In case of ties, the relevance assigned to the
         *        result by Amazon Kendra is used as the tie-breaker.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String documentAttributeKey;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SortingConfiguration model) {
            documentAttributeKey(model.documentAttributeKey);
            sortOrder(model.sortOrder);
        }

        public final String getDocumentAttributeKey() {
            return documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public SortingConfiguration build() {
            return new SortingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
