/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionConfiguration> {
    private static final SdkField<String> DATABASE_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseHost").getter(ConnectionConfiguration.getter(ConnectionConfiguration::databaseHost)).setter(ConnectionConfiguration.setter(Builder::databaseHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseHost").build()}).build();
    private static final SdkField<Integer> DATABASE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatabasePort").getter(ConnectionConfiguration.getter(ConnectionConfiguration::databasePort)).setter(ConnectionConfiguration.setter(Builder::databasePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabasePort").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(ConnectionConfiguration.getter(ConnectionConfiguration::databaseName)).setter(ConnectionConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ConnectionConfiguration.getter(ConnectionConfiguration::tableName)).setter(ConnectionConfiguration.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(ConnectionConfiguration.getter(ConnectionConfiguration::secretArn)).setter(ConnectionConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_HOST_FIELD, DATABASE_PORT_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, SECRET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseHost;
    private final Integer databasePort;
    private final String databaseName;
    private final String tableName;
    private final String secretArn;

    private ConnectionConfiguration(BuilderImpl builder) {
        this.databaseHost = builder.databaseHost;
        this.databasePort = builder.databasePort;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.secretArn = builder.secretArn;
    }

    public String databaseHost() {
        return this.databaseHost;
    }

    public Integer databasePort() {
        return this.databasePort;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.databasePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration)obj;
        return Objects.equals(this.databaseHost(), other.databaseHost()) && Objects.equals(this.databasePort(), other.databasePort()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public String toString() {
        return ToString.builder((String)"ConnectionConfiguration").add("DatabaseHost", (Object)this.databaseHost()).add("DatabasePort", (Object)this.databasePort()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("SecretArn", (Object)this.secretArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseHost": {
                return Optional.ofNullable(clazz.cast(this.databaseHost()));
            }
            case "DatabasePort": {
                return Optional.ofNullable(clazz.cast(this.databasePort()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionConfiguration, T> g) {
        return obj -> g.apply((ConnectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseHost;
        private Integer databasePort;
        private String databaseName;
        private String tableName;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionConfiguration model) {
            this.databaseHost(model.databaseHost);
            this.databasePort(model.databasePort);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.secretArn(model.secretArn);
        }

        public final String getDatabaseHost() {
            return this.databaseHost;
        }

        @Override
        public final Builder databaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
            return this;
        }

        public final void setDatabaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
        }

        public final Integer getDatabasePort() {
            return this.databasePort;
        }

        @Override
        public final Builder databasePort(Integer databasePort) {
            this.databasePort = databasePort;
            return this;
        }

        public final void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public ConnectionConfiguration build() {
            return new ConnectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionConfiguration> {
        public Builder databaseHost(String var1);

        public Builder databasePort(Integer var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder secretArn(String var1);
    }
}

