/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the mapping between a field in the Confluence data source to a Amazon Kendra index field.
 * </p>
 * <p>
 * You must first create the index field using the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluencePageToIndexFieldMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluencePageToIndexFieldMapping.Builder, ConfluencePageToIndexFieldMapping> {
    private static final SdkField<String> DATA_SOURCE_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceFieldName").getter(getter(ConfluencePageToIndexFieldMapping::dataSourceFieldNameAsString))
            .setter(setter(Builder::dataSourceFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceFieldName").build())
            .build();

    private static final SdkField<String> DATE_FIELD_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateFieldFormat").getter(getter(ConfluencePageToIndexFieldMapping::dateFieldFormat))
            .setter(setter(Builder::dateFieldFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFieldFormat").build()).build();

    private static final SdkField<String> INDEX_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexFieldName").getter(getter(ConfluencePageToIndexFieldMapping::indexFieldName))
            .setter(setter(Builder::indexFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD_NAME_FIELD,
            DATE_FIELD_FORMAT_FIELD, INDEX_FIELD_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSourceFieldName;

    private final String dateFieldFormat;

    private final String indexFieldName;

    private ConfluencePageToIndexFieldMapping(BuilderImpl builder) {
        this.dataSourceFieldName = builder.dataSourceFieldName;
        this.dateFieldFormat = builder.dateFieldFormat;
        this.indexFieldName = builder.indexFieldName;
    }

    /**
     * <p>
     * The name of the field in the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceFieldName} will return {@link ConfluencePageFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataSourceFieldNameAsString}.
     * </p>
     * 
     * @return The name of the field in the data source.
     * @see ConfluencePageFieldName
     */
    public ConfluencePageFieldName dataSourceFieldName() {
        return ConfluencePageFieldName.fromValue(dataSourceFieldName);
    }

    /**
     * <p>
     * The name of the field in the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataSourceFieldName} will return {@link ConfluencePageFieldName#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataSourceFieldNameAsString}.
     * </p>
     * 
     * @return The name of the field in the data source.
     * @see ConfluencePageFieldName
     */
    public String dataSourceFieldNameAsString() {
        return dataSourceFieldName;
    }

    /**
     * <p>
     * The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is a
     * date field you must specify the date format. If the field is not a date field, an exception is thrown.
     * </p>
     * 
     * @return The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code>
     *         is a date field you must specify the date format. If the field is not a date field, an exception is
     *         thrown.
     */
    public String dateFieldFormat() {
        return dateFieldFormat;
    }

    /**
     * <p>
     * The name of the index field to map to the Confluence data source field. The index field type must match the
     * Confluence field type.
     * </p>
     * 
     * @return The name of the index field to map to the Confluence data source field. The index field type must match
     *         the Confluence field type.
     */
    public String indexFieldName() {
        return indexFieldName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceFieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dateFieldFormat());
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluencePageToIndexFieldMapping)) {
            return false;
        }
        ConfluencePageToIndexFieldMapping other = (ConfluencePageToIndexFieldMapping) obj;
        return Objects.equals(dataSourceFieldNameAsString(), other.dataSourceFieldNameAsString())
                && Objects.equals(dateFieldFormat(), other.dateFieldFormat())
                && Objects.equals(indexFieldName(), other.indexFieldName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfluencePageToIndexFieldMapping").add("DataSourceFieldName", dataSourceFieldNameAsString())
                .add("DateFieldFormat", dateFieldFormat()).add("IndexFieldName", indexFieldName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceFieldName":
            return Optional.ofNullable(clazz.cast(dataSourceFieldNameAsString()));
        case "DateFieldFormat":
            return Optional.ofNullable(clazz.cast(dateFieldFormat()));
        case "IndexFieldName":
            return Optional.ofNullable(clazz.cast(indexFieldName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluencePageToIndexFieldMapping, T> g) {
        return obj -> g.apply((ConfluencePageToIndexFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluencePageToIndexFieldMapping> {
        /**
         * <p>
         * The name of the field in the data source.
         * </p>
         * 
         * @param dataSourceFieldName
         *        The name of the field in the data source.
         * @see ConfluencePageFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluencePageFieldName
         */
        Builder dataSourceFieldName(String dataSourceFieldName);

        /**
         * <p>
         * The name of the field in the data source.
         * </p>
         * 
         * @param dataSourceFieldName
         *        The name of the field in the data source.
         * @see ConfluencePageFieldName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluencePageFieldName
         */
        Builder dataSourceFieldName(ConfluencePageFieldName dataSourceFieldName);

        /**
         * <p>
         * The format for date fields in the data source. If the field specified in <code>DataSourceFieldName</code> is
         * a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         * </p>
         * 
         * @param dateFieldFormat
         *        The format for date fields in the data source. If the field specified in
         *        <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not
         *        a date field, an exception is thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateFieldFormat(String dateFieldFormat);

        /**
         * <p>
         * The name of the index field to map to the Confluence data source field. The index field type must match the
         * Confluence field type.
         * </p>
         * 
         * @param indexFieldName
         *        The name of the index field to map to the Confluence data source field. The index field type must
         *        match the Confluence field type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFieldName(String indexFieldName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceFieldName;

        private String dateFieldFormat;

        private String indexFieldName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluencePageToIndexFieldMapping model) {
            dataSourceFieldName(model.dataSourceFieldName);
            dateFieldFormat(model.dateFieldFormat);
            indexFieldName(model.indexFieldName);
        }

        public final String getDataSourceFieldName() {
            return dataSourceFieldName;
        }

        @Override
        public final Builder dataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
            return this;
        }

        @Override
        public final Builder dataSourceFieldName(ConfluencePageFieldName dataSourceFieldName) {
            this.dataSourceFieldName(dataSourceFieldName == null ? null : dataSourceFieldName.toString());
            return this;
        }

        public final void setDataSourceFieldName(String dataSourceFieldName) {
            this.dataSourceFieldName = dataSourceFieldName;
        }

        public final String getDateFieldFormat() {
            return dateFieldFormat;
        }

        @Override
        public final Builder dateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
            return this;
        }

        public final void setDateFieldFormat(String dateFieldFormat) {
            this.dateFieldFormat = dateFieldFormat;
        }

        public final String getIndexFieldName() {
            return indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        @Override
        public ConfluencePageToIndexFieldMapping build() {
            return new ConfluencePageToIndexFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
