/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the JWT token type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JwtTokenTypeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<JwtTokenTypeConfiguration.Builder, JwtTokenTypeConfiguration> {
    private static final SdkField<String> KEY_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyLocation").getter(getter(JwtTokenTypeConfiguration::keyLocationAsString))
            .setter(setter(Builder::keyLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLocation").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URL")
            .getter(getter(JwtTokenTypeConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URL").build()).build();

    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretManagerArn").getter(getter(JwtTokenTypeConfiguration::secretManagerArn))
            .setter(setter(Builder::secretManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()).build();

    private static final SdkField<String> USER_NAME_ATTRIBUTE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserNameAttributeField").getter(getter(JwtTokenTypeConfiguration::userNameAttributeField))
            .setter(setter(Builder::userNameAttributeField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNameAttributeField").build())
            .build();

    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupAttributeField").getter(getter(JwtTokenTypeConfiguration::groupAttributeField))
            .setter(setter(Builder::groupAttributeField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupAttributeField").build())
            .build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(JwtTokenTypeConfiguration::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> CLAIM_REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClaimRegex").getter(getter(JwtTokenTypeConfiguration::claimRegex)).setter(setter(Builder::claimRegex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimRegex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_LOCATION_FIELD, URL_FIELD,
            SECRET_MANAGER_ARN_FIELD, USER_NAME_ATTRIBUTE_FIELD_FIELD, GROUP_ATTRIBUTE_FIELD_FIELD, ISSUER_FIELD,
            CLAIM_REGEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyLocation;

    private final String url;

    private final String secretManagerArn;

    private final String userNameAttributeField;

    private final String groupAttributeField;

    private final String issuer;

    private final String claimRegex;

    private JwtTokenTypeConfiguration(BuilderImpl builder) {
        this.keyLocation = builder.keyLocation;
        this.url = builder.url;
        this.secretManagerArn = builder.secretManagerArn;
        this.userNameAttributeField = builder.userNameAttributeField;
        this.groupAttributeField = builder.groupAttributeField;
        this.issuer = builder.issuer;
        this.claimRegex = builder.claimRegex;
    }

    /**
     * <p>
     * The location of the key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyLocation} will
     * return {@link KeyLocation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyLocationAsString}.
     * </p>
     * 
     * @return The location of the key.
     * @see KeyLocation
     */
    public KeyLocation keyLocation() {
        return KeyLocation.fromValue(keyLocation);
    }

    /**
     * <p>
     * The location of the key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyLocation} will
     * return {@link KeyLocation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyLocationAsString}.
     * </p>
     * 
     * @return The location of the key.
     * @see KeyLocation
     */
    public String keyLocationAsString() {
        return keyLocation;
    }

    /**
     * <p>
     * The signing key URL.
     * </p>
     * 
     * @return The signing key URL.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the secret.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the secret.
     */
    public String secretManagerArn() {
        return secretManagerArn;
    }

    /**
     * <p>
     * The user name attribute field.
     * </p>
     * 
     * @return The user name attribute field.
     */
    public String userNameAttributeField() {
        return userNameAttributeField;
    }

    /**
     * <p>
     * The group attribute field.
     * </p>
     * 
     * @return The group attribute field.
     */
    public String groupAttributeField() {
        return groupAttributeField;
    }

    /**
     * <p>
     * The issuer of the token.
     * </p>
     * 
     * @return The issuer of the token.
     */
    public String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The regular expression that identifies the claim.
     * </p>
     * 
     * @return The regular expression that identifies the claim.
     */
    public String claimRegex() {
        return claimRegex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyLocationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(userNameAttributeField());
        hashCode = 31 * hashCode + Objects.hashCode(groupAttributeField());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(claimRegex());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtTokenTypeConfiguration)) {
            return false;
        }
        JwtTokenTypeConfiguration other = (JwtTokenTypeConfiguration) obj;
        return Objects.equals(keyLocationAsString(), other.keyLocationAsString()) && Objects.equals(url(), other.url())
                && Objects.equals(secretManagerArn(), other.secretManagerArn())
                && Objects.equals(userNameAttributeField(), other.userNameAttributeField())
                && Objects.equals(groupAttributeField(), other.groupAttributeField()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(claimRegex(), other.claimRegex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JwtTokenTypeConfiguration").add("KeyLocation", keyLocationAsString()).add("URL", url())
                .add("SecretManagerArn", secretManagerArn()).add("UserNameAttributeField", userNameAttributeField())
                .add("GroupAttributeField", groupAttributeField()).add("Issuer", issuer()).add("ClaimRegex", claimRegex())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyLocation":
            return Optional.ofNullable(clazz.cast(keyLocationAsString()));
        case "URL":
            return Optional.ofNullable(clazz.cast(url()));
        case "SecretManagerArn":
            return Optional.ofNullable(clazz.cast(secretManagerArn()));
        case "UserNameAttributeField":
            return Optional.ofNullable(clazz.cast(userNameAttributeField()));
        case "GroupAttributeField":
            return Optional.ofNullable(clazz.cast(groupAttributeField()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "ClaimRegex":
            return Optional.ofNullable(clazz.cast(claimRegex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JwtTokenTypeConfiguration, T> g) {
        return obj -> g.apply((JwtTokenTypeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JwtTokenTypeConfiguration> {
        /**
         * <p>
         * The location of the key.
         * </p>
         * 
         * @param keyLocation
         *        The location of the key.
         * @see KeyLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyLocation
         */
        Builder keyLocation(String keyLocation);

        /**
         * <p>
         * The location of the key.
         * </p>
         * 
         * @param keyLocation
         *        The location of the key.
         * @see KeyLocation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyLocation
         */
        Builder keyLocation(KeyLocation keyLocation);

        /**
         * <p>
         * The signing key URL.
         * </p>
         * 
         * @param url
         *        The signing key URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The Amazon Resource Name (arn) of the secret.
         * </p>
         * 
         * @param secretManagerArn
         *        The Amazon Resource Name (arn) of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretManagerArn(String secretManagerArn);

        /**
         * <p>
         * The user name attribute field.
         * </p>
         * 
         * @param userNameAttributeField
         *        The user name attribute field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNameAttributeField(String userNameAttributeField);

        /**
         * <p>
         * The group attribute field.
         * </p>
         * 
         * @param groupAttributeField
         *        The group attribute field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupAttributeField(String groupAttributeField);

        /**
         * <p>
         * The issuer of the token.
         * </p>
         * 
         * @param issuer
         *        The issuer of the token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The regular expression that identifies the claim.
         * </p>
         * 
         * @param claimRegex
         *        The regular expression that identifies the claim.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimRegex(String claimRegex);
    }

    static final class BuilderImpl implements Builder {
        private String keyLocation;

        private String url;

        private String secretManagerArn;

        private String userNameAttributeField;

        private String groupAttributeField;

        private String issuer;

        private String claimRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(JwtTokenTypeConfiguration model) {
            keyLocation(model.keyLocation);
            url(model.url);
            secretManagerArn(model.secretManagerArn);
            userNameAttributeField(model.userNameAttributeField);
            groupAttributeField(model.groupAttributeField);
            issuer(model.issuer);
            claimRegex(model.claimRegex);
        }

        public final String getKeyLocation() {
            return keyLocation;
        }

        @Override
        public final Builder keyLocation(String keyLocation) {
            this.keyLocation = keyLocation;
            return this;
        }

        @Override
        public final Builder keyLocation(KeyLocation keyLocation) {
            this.keyLocation(keyLocation == null ? null : keyLocation.toString());
            return this;
        }

        public final void setKeyLocation(String keyLocation) {
            this.keyLocation = keyLocation;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getSecretManagerArn() {
            return secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        public final String getUserNameAttributeField() {
            return userNameAttributeField;
        }

        @Override
        public final Builder userNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
            return this;
        }

        public final void setUserNameAttributeField(String userNameAttributeField) {
            this.userNameAttributeField = userNameAttributeField;
        }

        public final String getGroupAttributeField() {
            return groupAttributeField;
        }

        @Override
        public final Builder groupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
            return this;
        }

        public final void setGroupAttributeField(String groupAttributeField) {
            this.groupAttributeField = groupAttributeField;
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getClaimRegex() {
            return claimRegex;
        }

        @Override
        public final Builder claimRegex(String claimRegex) {
            this.claimRegex = claimRegex;
            return this;
        }

        public final void setClaimRegex(String claimRegex) {
            this.claimRegex = claimRegex;
        }

        @Override
        public JwtTokenTypeConfiguration build() {
            return new JwtTokenTypeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
