/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeThesaurusResponse extends KendraResponse implements
        ToCopyableBuilder<DescribeThesaurusResponse.Builder, DescribeThesaurusResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeThesaurusResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(DescribeThesaurusResponse::indexId)).setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeThesaurusResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeThesaurusResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeThesaurusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeThesaurusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeThesaurusResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeThesaurusResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeThesaurusResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<S3Path> SOURCE_S3_PATH_FIELD = SdkField.<S3Path> builder(MarshallingType.SDK_POJO)
            .memberName("SourceS3Path").getter(getter(DescribeThesaurusResponse::sourceS3Path))
            .setter(setter(Builder::sourceS3Path)).constructor(S3Path::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Path").build()).build();

    private static final SdkField<Long> FILE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileSizeBytes").getter(getter(DescribeThesaurusResponse::fileSizeBytes))
            .setter(setter(Builder::fileSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeBytes").build()).build();

    private static final SdkField<Long> TERM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("TermCount")
            .getter(getter(DescribeThesaurusResponse::termCount)).setter(setter(Builder::termCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermCount").build()).build();

    private static final SdkField<Long> SYNONYM_RULE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SynonymRuleCount").getter(getter(DescribeThesaurusResponse::synonymRuleCount))
            .setter(setter(Builder::synonymRuleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SynonymRuleCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ROLE_ARN_FIELD,
            SOURCE_S3_PATH_FIELD, FILE_SIZE_BYTES_FIELD, TERM_COUNT_FIELD, SYNONYM_RULE_COUNT_FIELD));

    private final String id;

    private final String indexId;

    private final String name;

    private final String description;

    private final String status;

    private final String errorMessage;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String roleArn;

    private final S3Path sourceS3Path;

    private final Long fileSizeBytes;

    private final Long termCount;

    private final Long synonymRuleCount;

    private DescribeThesaurusResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.roleArn = builder.roleArn;
        this.sourceS3Path = builder.sourceS3Path;
        this.fileSizeBytes = builder.fileSizeBytes;
        this.termCount = builder.termCount;
        this.synonymRuleCount = builder.synonymRuleCount;
    }

    /**
     * <p>
     * The identifier of the thesaurus.
     * </p>
     * 
     * @return The identifier of the thesaurus.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the index associated with the thesaurus to describe.
     * </p>
     * 
     * @return The identifier of the index associated with the thesaurus to describe.
     */
    public String indexId() {
        return indexId;
    }

    /**
     * <p>
     * The thesaurus name.
     * </p>
     * 
     * @return The thesaurus name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The thesaurus description.
     * </p>
     * 
     * @return The thesaurus description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
     * thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     * provides more information.
     * </p>
     * <p>
     * If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new
     * thesaurus file. The old thesaurus file is still active.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThesaurusStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
     *         thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code>
     *         field provides more information. </p>
     *         <p>
     *         If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the
     *         new thesaurus file. The old thesaurus file is still active.
     * @see ThesaurusStatus
     */
    public ThesaurusStatus status() {
        return ThesaurusStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
     * thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     * provides more information.
     * </p>
     * <p>
     * If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new
     * thesaurus file. The old thesaurus file is still active.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThesaurusStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
     *         thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code>
     *         field provides more information. </p>
     *         <p>
     *         If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the
     *         new thesaurus file. The old thesaurus file is still active.
     * @see ThesaurusStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides
     * more information.
     * </p>
     * 
     * @return When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
     *         provides more information.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The Unix datetime that the thesaurus was created.
     * </p>
     * 
     * @return The Unix datetime that the thesaurus was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix datetime that the thesaurus was last updated.
     * </p>
     * 
     * @return The Unix datetime that the thesaurus was last updated.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus file
     * specified in <code>SourceS3Path</code>.
     * </p>
     * 
     * @return An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus
     *         file specified in <code>SourceS3Path</code>.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the SourceS3Path property for this object.
     * 
     * @return The value of the SourceS3Path property for this object.
     */
    public S3Path sourceS3Path() {
        return sourceS3Path;
    }

    /**
     * <p>
     * The size of the thesaurus file in bytes.
     * </p>
     * 
     * @return The size of the thesaurus file in bytes.
     */
    public Long fileSizeBytes() {
        return fileSizeBytes;
    }

    /**
     * <p>
     * The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and
     * <code>a=&gt;d</code>, the term count would be 4.
     * </p>
     * 
     * @return The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and
     *         <code>a=&gt;d</code>, the term count would be 4.
     */
    public Long termCount() {
        return termCount;
    }

    /**
     * <p>
     * The number of synonym rules in the thesaurus file.
     * </p>
     * 
     * @return The number of synonym rules in the thesaurus file.
     */
    public Long synonymRuleCount() {
        return synonymRuleCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(fileSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(termCount());
        hashCode = 31 * hashCode + Objects.hashCode(synonymRuleCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThesaurusResponse)) {
            return false;
        }
        DescribeThesaurusResponse other = (DescribeThesaurusResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(indexId(), other.indexId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(sourceS3Path(), other.sourceS3Path()) && Objects.equals(fileSizeBytes(), other.fileSizeBytes())
                && Objects.equals(termCount(), other.termCount()) && Objects.equals(synonymRuleCount(), other.synonymRuleCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeThesaurusResponse").add("Id", id()).add("IndexId", indexId()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("ErrorMessage", errorMessage())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("RoleArn", roleArn())
                .add("SourceS3Path", sourceS3Path()).add("FileSizeBytes", fileSizeBytes()).add("TermCount", termCount())
                .add("SynonymRuleCount", synonymRuleCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SourceS3Path":
            return Optional.ofNullable(clazz.cast(sourceS3Path()));
        case "FileSizeBytes":
            return Optional.ofNullable(clazz.cast(fileSizeBytes()));
        case "TermCount":
            return Optional.ofNullable(clazz.cast(termCount()));
        case "SynonymRuleCount":
            return Optional.ofNullable(clazz.cast(synonymRuleCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeThesaurusResponse, T> g) {
        return obj -> g.apply((DescribeThesaurusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeThesaurusResponse> {
        /**
         * <p>
         * The identifier of the thesaurus.
         * </p>
         * 
         * @param id
         *        The identifier of the thesaurus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the index associated with the thesaurus to describe.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index associated with the thesaurus to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * The thesaurus name.
         * </p>
         * 
         * @param name
         *        The thesaurus name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The thesaurus description.
         * </p>
         * 
         * @param description
         *        The thesaurus description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
         * thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         * provides more information.
         * </p>
         * <p>
         * If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new
         * thesaurus file. The old thesaurus file is still active.
         * </p>
         * 
         * @param status
         *        The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use
         *        the thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field provides more information. </p>
         *        <p>
         *        If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest
         *        the new thesaurus file. The old thesaurus file is still active.
         * @see ThesaurusStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThesaurusStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use the
         * thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         * provides more information.
         * </p>
         * <p>
         * If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest the new
         * thesaurus file. The old thesaurus file is still active.
         * </p>
         * 
         * @param status
         *        The current status of the thesaurus. When the value is <code>ACTIVE</code>, queries are able to use
         *        the thesaurus. If the <code>Status</code> field value is <code>FAILED</code>, the
         *        <code>ErrorMessage</code> field provides more information. </p>
         *        <p>
         *        If the status is <code>ACTIVE_BUT_UPDATE_FAILED</code>, it means that Amazon Kendra could not ingest
         *        the new thesaurus file. The old thesaurus file is still active.
         * @see ThesaurusStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThesaurusStatus
         */
        Builder status(ThesaurusStatus status);

        /**
         * <p>
         * When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field provides
         * more information.
         * </p>
         * 
         * @param errorMessage
         *        When the <code>Status</code> field value is <code>FAILED</code>, the <code>ErrorMessage</code> field
         *        provides more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The Unix datetime that the thesaurus was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix datetime that the thesaurus was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix datetime that the thesaurus was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix datetime that the thesaurus was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access thesaurus
         * file specified in <code>SourceS3Path</code>.
         * </p>
         * 
         * @param roleArn
         *        An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access
         *        thesaurus file specified in <code>SourceS3Path</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the SourceS3Path property for this object.
         *
         * @param sourceS3Path
         *        The new value for the SourceS3Path property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Path(S3Path sourceS3Path);

        /**
         * Sets the value of the SourceS3Path property for this object.
         *
         * This is a convenience that creates an instance of the {@link S3Path.Builder} avoiding the need to create one
         * manually via {@link S3Path#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Path.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Path(S3Path)}.
         * 
         * @param sourceS3Path
         *        a consumer that will call methods on {@link S3Path.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Path(S3Path)
         */
        default Builder sourceS3Path(Consumer<S3Path.Builder> sourceS3Path) {
            return sourceS3Path(S3Path.builder().applyMutation(sourceS3Path).build());
        }

        /**
         * <p>
         * The size of the thesaurus file in bytes.
         * </p>
         * 
         * @param fileSizeBytes
         *        The size of the thesaurus file in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSizeBytes(Long fileSizeBytes);

        /**
         * <p>
         * The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and
         * <code>a=&gt;d</code>, the term count would be 4.
         * </p>
         * 
         * @param termCount
         *        The number of unique terms in the thesaurus file. For example, the synonyms <code>a,b,c</code> and
         *        <code>a=&gt;d</code>, the term count would be 4.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termCount(Long termCount);

        /**
         * <p>
         * The number of synonym rules in the thesaurus file.
         * </p>
         * 
         * @param synonymRuleCount
         *        The number of synonym rules in the thesaurus file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonymRuleCount(Long synonymRuleCount);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private String id;

        private String indexId;

        private String name;

        private String description;

        private String status;

        private String errorMessage;

        private Instant createdAt;

        private Instant updatedAt;

        private String roleArn;

        private S3Path sourceS3Path;

        private Long fileSizeBytes;

        private Long termCount;

        private Long synonymRuleCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThesaurusResponse model) {
            super(model);
            id(model.id);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            status(model.status);
            errorMessage(model.errorMessage);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            roleArn(model.roleArn);
            sourceS3Path(model.sourceS3Path);
            fileSizeBytes(model.fileSizeBytes);
            termCount(model.termCount);
            synonymRuleCount(model.synonymRuleCount);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIndexId() {
            return indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ThesaurusStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final S3Path.Builder getSourceS3Path() {
            return sourceS3Path != null ? sourceS3Path.toBuilder() : null;
        }

        @Override
        public final Builder sourceS3Path(S3Path sourceS3Path) {
            this.sourceS3Path = sourceS3Path;
            return this;
        }

        public final void setSourceS3Path(S3Path.BuilderImpl sourceS3Path) {
            this.sourceS3Path = sourceS3Path != null ? sourceS3Path.build() : null;
        }

        public final Long getFileSizeBytes() {
            return fileSizeBytes;
        }

        @Override
        public final Builder fileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        public final void setFileSizeBytes(Long fileSizeBytes) {
            this.fileSizeBytes = fileSizeBytes;
        }

        public final Long getTermCount() {
            return termCount;
        }

        @Override
        public final Builder termCount(Long termCount) {
            this.termCount = termCount;
            return this;
        }

        public final void setTermCount(Long termCount) {
            this.termCount = termCount;
        }

        public final Long getSynonymRuleCount() {
            return synonymRuleCount;
        }

        @Override
        public final Builder synonymRuleCount(Long synonymRuleCount) {
            this.synonymRuleCount = synonymRuleCount;
            return this;
        }

        public final void setSynonymRuleCount(Long synonymRuleCount) {
            this.synonymRuleCount = synonymRuleCount;
        }

        @Override
        public DescribeThesaurusResponse build() {
            return new DescribeThesaurusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
