/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.HighlightType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Highlight
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Highlight> {
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(Highlight.getter(Highlight::beginOffset)).setter(Highlight.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(Highlight.getter(Highlight::endOffset)).setter(Highlight.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<Boolean> TOP_ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TopAnswer").getter(Highlight.getter(Highlight::topAnswer)).setter(Highlight.setter(Builder::topAnswer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopAnswer").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Highlight.getter(Highlight::typeAsString)).setter(Highlight.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, TOP_ANSWER_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final Boolean topAnswer;
    private final String type;

    private Highlight(BuilderImpl builder) {
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.topAnswer = builder.topAnswer;
        this.type = builder.type;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public Boolean topAnswer() {
        return this.topAnswer;
    }

    public HighlightType type() {
        return HighlightType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.topAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Highlight)) {
            return false;
        }
        Highlight other = (Highlight)obj;
        return Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.topAnswer(), other.topAnswer()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Highlight").add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("TopAnswer", (Object)this.topAnswer()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "TopAnswer": {
                return Optional.ofNullable(clazz.cast(this.topAnswer()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Highlight, T> g) {
        return obj -> g.apply((Highlight)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer beginOffset;
        private Integer endOffset;
        private Boolean topAnswer;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Highlight model) {
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.topAnswer(model.topAnswer);
            this.type(model.type);
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final Boolean getTopAnswer() {
            return this.topAnswer;
        }

        @Override
        public final Builder topAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
            return this;
        }

        public final void setTopAnswer(Boolean topAnswer) {
            this.topAnswer = topAnswer;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HighlightType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public Highlight build() {
            return new Highlight(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Highlight> {
        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder topAnswer(Boolean var1);

        public Builder type(String var1);

        public Builder type(HighlightType var1);
    }
}

