/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides filtering the query results based on document attributes.
 * </p>
 * <p>
 * When you use the <code>AndAllFilters</code> or <code>OrAllFilters</code>, filters you can use 2 layers under the
 * first attribute filter. For example, you can use:
 * </p>
 * <p>
 * <code>&lt;AndAllFilters&gt;</code>
 * </p>
 * <ol>
 * <li>
 * <p>
 * <code> &lt;OrAllFilters&gt;</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code> &lt;EqualTo&gt;</code>
 * </p>
 * </li>
 * </ol>
 * <p>
 * If you use more than 2 layers, you receive a <code>ValidationException</code> exception with the message "
 * <code>AttributeFilter</code> cannot have a depth of more than 2."
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeFilter implements SdkPojo, Serializable, ToCopyableBuilder<AttributeFilter.Builder, AttributeFilter> {
    private static final SdkField<List<AttributeFilter>> AND_ALL_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("AndAllFilters")
            .getter(getter(AttributeFilter::andAllFilters))
            .setter(setter(Builder::andAllFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndAllFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttributeFilter>> OR_ALL_FILTERS_FIELD = SdkField
            .<List<AttributeFilter>> builder(MarshallingType.LIST)
            .memberName("OrAllFilters")
            .getter(getter(AttributeFilter::orAllFilters))
            .setter(setter(Builder::orAllFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrAllFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttributeFilter> NOT_FILTER_FIELD = SdkField
            .<AttributeFilter> builder(MarshallingType.SDK_POJO).memberName("NotFilter")
            .getter(getter(AttributeFilter::notFilter)).setter(setter(Builder::notFilter)).constructor(AttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotFilter").build()).build();

    private static final SdkField<DocumentAttribute> EQUALS_TO_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("EqualsTo")
            .getter(getter(AttributeFilter::equalsTo)).setter(setter(Builder::equalsTo)).constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EqualsTo").build()).build();

    private static final SdkField<DocumentAttribute> CONTAINS_ALL_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("ContainsAll")
            .getter(getter(AttributeFilter::containsAll)).setter(setter(Builder::containsAll))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsAll").build()).build();

    private static final SdkField<DocumentAttribute> CONTAINS_ANY_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("ContainsAny")
            .getter(getter(AttributeFilter::containsAny)).setter(setter(Builder::containsAny))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsAny").build()).build();

    private static final SdkField<DocumentAttribute> GREATER_THAN_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("GreaterThan")
            .getter(getter(AttributeFilter::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreaterThan").build()).build();

    private static final SdkField<DocumentAttribute> GREATER_THAN_OR_EQUALS_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("GreaterThanOrEquals")
            .getter(getter(AttributeFilter::greaterThanOrEquals)).setter(setter(Builder::greaterThanOrEquals))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreaterThanOrEquals").build())
            .build();

    private static final SdkField<DocumentAttribute> LESS_THAN_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("LessThan")
            .getter(getter(AttributeFilter::lessThan)).setter(setter(Builder::lessThan)).constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LessThan").build()).build();

    private static final SdkField<DocumentAttribute> LESS_THAN_OR_EQUALS_FIELD = SdkField
            .<DocumentAttribute> builder(MarshallingType.SDK_POJO).memberName("LessThanOrEquals")
            .getter(getter(AttributeFilter::lessThanOrEquals)).setter(setter(Builder::lessThanOrEquals))
            .constructor(DocumentAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LessThanOrEquals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_ALL_FILTERS_FIELD,
            OR_ALL_FILTERS_FIELD, NOT_FILTER_FIELD, EQUALS_TO_FIELD, CONTAINS_ALL_FIELD, CONTAINS_ANY_FIELD, GREATER_THAN_FIELD,
            GREATER_THAN_OR_EQUALS_FIELD, LESS_THAN_FIELD, LESS_THAN_OR_EQUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeFilter> andAllFilters;

    private final List<AttributeFilter> orAllFilters;

    private final AttributeFilter notFilter;

    private final DocumentAttribute equalsTo;

    private final DocumentAttribute containsAll;

    private final DocumentAttribute containsAny;

    private final DocumentAttribute greaterThan;

    private final DocumentAttribute greaterThanOrEquals;

    private final DocumentAttribute lessThan;

    private final DocumentAttribute lessThanOrEquals;

    private AttributeFilter(BuilderImpl builder) {
        this.andAllFilters = builder.andAllFilters;
        this.orAllFilters = builder.orAllFilters;
        this.notFilter = builder.notFilter;
        this.equalsTo = builder.equalsTo;
        this.containsAll = builder.containsAll;
        this.containsAny = builder.containsAny;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEquals = builder.greaterThanOrEquals;
        this.lessThan = builder.lessThan;
        this.lessThanOrEquals = builder.lessThanOrEquals;
    }

    /**
     * Returns true if the AndAllFilters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAndAllFilters() {
        return andAllFilters != null && !(andAllFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Performs a logical <code>AND</code> operation on all supplied filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAndAllFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Performs a logical <code>AND</code> operation on all supplied filters.
     */
    public final List<AttributeFilter> andAllFilters() {
        return andAllFilters;
    }

    /**
     * Returns true if the OrAllFilters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOrAllFilters() {
        return orAllFilters != null && !(orAllFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Performs a logical <code>OR</code> operation on all supplied filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrAllFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Performs a logical <code>OR</code> operation on all supplied filters.
     */
    public final List<AttributeFilter> orAllFilters() {
        return orAllFilters;
    }

    /**
     * <p>
     * Performs a logical <code>NOT</code> operation on all supplied filters.
     * </p>
     * 
     * @return Performs a logical <code>NOT</code> operation on all supplied filters.
     */
    public final AttributeFilter notFilter() {
        return notFilter;
    }

    /**
     * <p>
     * Performs an equals operation on two document attributes.
     * </p>
     * 
     * @return Performs an equals operation on two document attributes.
     */
    public final DocumentAttribute equalsTo() {
        return equalsTo;
    }

    /**
     * <p>
     * Returns true when a document contains all of the specified document attributes. This filter is only applicable to
     * <code>StringListValue</code> metadata.
     * </p>
     * 
     * @return Returns true when a document contains all of the specified document attributes. This filter is only
     *         applicable to <code>StringListValue</code> metadata.
     */
    public final DocumentAttribute containsAll() {
        return containsAll;
    }

    /**
     * <p>
     * Returns true when a document contains any of the specified document attributes. This filter is only applicable to
     * <code>StringListValue</code> metadata.
     * </p>
     * 
     * @return Returns true when a document contains any of the specified document attributes. This filter is only
     *         applicable to <code>StringListValue</code> metadata.
     */
    public final DocumentAttribute containsAny() {
        return containsAny;
    }

    /**
     * <p>
     * Performs a greater than operation on two document attributes. Use with a document attribute of type
     * <code>Integer</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a greater than operation on two document attributes. Use with a document attribute of type
     *         <code>Integer</code> or <code>Long</code>.
     */
    public final DocumentAttribute greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Performs a greater or equals than operation on two document attributes. Use with a document attribute of type
     * <code>Integer</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a greater or equals than operation on two document attributes. Use with a document attribute of
     *         type <code>Integer</code> or <code>Long</code>.
     */
    public final DocumentAttribute greaterThanOrEquals() {
        return greaterThanOrEquals;
    }

    /**
     * <p>
     * Performs a less than operation on two document attributes. Use with a document attribute of type
     * <code>Integer</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a less than operation on two document attributes. Use with a document attribute of type
     *         <code>Integer</code> or <code>Long</code>.
     */
    public final DocumentAttribute lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Performs a less than or equals operation on two document attributes. Use with a document attribute of type
     * <code>Integer</code> or <code>Long</code>.
     * </p>
     * 
     * @return Performs a less than or equals operation on two document attributes. Use with a document attribute of
     *         type <code>Integer</code> or <code>Long</code>.
     */
    public final DocumentAttribute lessThanOrEquals() {
        return lessThanOrEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndAllFilters() ? andAllFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrAllFilters() ? orAllFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notFilter());
        hashCode = 31 * hashCode + Objects.hashCode(equalsTo());
        hashCode = 31 * hashCode + Objects.hashCode(containsAll());
        hashCode = 31 * hashCode + Objects.hashCode(containsAny());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEquals());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEquals());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeFilter)) {
            return false;
        }
        AttributeFilter other = (AttributeFilter) obj;
        return hasAndAllFilters() == other.hasAndAllFilters() && Objects.equals(andAllFilters(), other.andAllFilters())
                && hasOrAllFilters() == other.hasOrAllFilters() && Objects.equals(orAllFilters(), other.orAllFilters())
                && Objects.equals(notFilter(), other.notFilter()) && Objects.equals(equalsTo(), other.equalsTo())
                && Objects.equals(containsAll(), other.containsAll()) && Objects.equals(containsAny(), other.containsAny())
                && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEquals(), other.greaterThanOrEquals())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEquals(), other.lessThanOrEquals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeFilter").add("AndAllFilters", hasAndAllFilters() ? andAllFilters() : null)
                .add("OrAllFilters", hasOrAllFilters() ? orAllFilters() : null).add("NotFilter", notFilter())
                .add("EqualsTo", equalsTo()).add("ContainsAll", containsAll()).add("ContainsAny", containsAny())
                .add("GreaterThan", greaterThan()).add("GreaterThanOrEquals", greaterThanOrEquals()).add("LessThan", lessThan())
                .add("LessThanOrEquals", lessThanOrEquals()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AndAllFilters":
            return Optional.ofNullable(clazz.cast(andAllFilters()));
        case "OrAllFilters":
            return Optional.ofNullable(clazz.cast(orAllFilters()));
        case "NotFilter":
            return Optional.ofNullable(clazz.cast(notFilter()));
        case "EqualsTo":
            return Optional.ofNullable(clazz.cast(equalsTo()));
        case "ContainsAll":
            return Optional.ofNullable(clazz.cast(containsAll()));
        case "ContainsAny":
            return Optional.ofNullable(clazz.cast(containsAny()));
        case "GreaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "GreaterThanOrEquals":
            return Optional.ofNullable(clazz.cast(greaterThanOrEquals()));
        case "LessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "LessThanOrEquals":
            return Optional.ofNullable(clazz.cast(lessThanOrEquals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeFilter, T> g) {
        return obj -> g.apply((AttributeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeFilter> {
        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * 
         * @param andAllFilters
         *        Performs a logical <code>AND</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAllFilters(Collection<AttributeFilter> andAllFilters);

        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * 
         * @param andAllFilters
         *        Performs a logical <code>AND</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andAllFilters(AttributeFilter... andAllFilters);

        /**
         * <p>
         * Performs a logical <code>AND</code> operation on all supplied filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeFilter>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #andAllFilters(List<AttributeFilter>)}.
         * 
         * @param andAllFilters
         *        a consumer that will call methods on {@link List<AttributeFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andAllFilters(List<AttributeFilter>)
         */
        Builder andAllFilters(Consumer<Builder>... andAllFilters);

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * 
         * @param orAllFilters
         *        Performs a logical <code>OR</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAllFilters(Collection<AttributeFilter> orAllFilters);

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * 
         * @param orAllFilters
         *        Performs a logical <code>OR</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orAllFilters(AttributeFilter... orAllFilters);

        /**
         * <p>
         * Performs a logical <code>OR</code> operation on all supplied filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeFilter>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #orAllFilters(List<AttributeFilter>)}.
         * 
         * @param orAllFilters
         *        a consumer that will call methods on {@link List<AttributeFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orAllFilters(List<AttributeFilter>)
         */
        Builder orAllFilters(Consumer<Builder>... orAllFilters);

        /**
         * <p>
         * Performs a logical <code>NOT</code> operation on all supplied filters.
         * </p>
         * 
         * @param notFilter
         *        Performs a logical <code>NOT</code> operation on all supplied filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notFilter(AttributeFilter notFilter);

        /**
         * <p>
         * Performs a logical <code>NOT</code> operation on all supplied filters.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeFilter.Builder} avoiding the need to
         * create one manually via {@link AttributeFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #notFilter(AttributeFilter)}.
         * 
         * @param notFilter
         *        a consumer that will call methods on {@link AttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notFilter(AttributeFilter)
         */
        default Builder notFilter(Consumer<Builder> notFilter) {
            return notFilter(AttributeFilter.builder().applyMutation(notFilter).build());
        }

        /**
         * <p>
         * Performs an equals operation on two document attributes.
         * </p>
         * 
         * @param equalsTo
         *        Performs an equals operation on two document attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsTo(DocumentAttribute equalsTo);

        /**
         * <p>
         * Performs an equals operation on two document attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #equalsTo(DocumentAttribute)}.
         * 
         * @param equalsTo
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalsTo(DocumentAttribute)
         */
        default Builder equalsTo(Consumer<DocumentAttribute.Builder> equalsTo) {
            return equalsTo(DocumentAttribute.builder().applyMutation(equalsTo).build());
        }

        /**
         * <p>
         * Returns true when a document contains all of the specified document attributes. This filter is only
         * applicable to <code>StringListValue</code> metadata.
         * </p>
         * 
         * @param containsAll
         *        Returns true when a document contains all of the specified document attributes. This filter is only
         *        applicable to <code>StringListValue</code> metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsAll(DocumentAttribute containsAll);

        /**
         * <p>
         * Returns true when a document contains all of the specified document attributes. This filter is only
         * applicable to <code>StringListValue</code> metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #containsAll(DocumentAttribute)}.
         * 
         * @param containsAll
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containsAll(DocumentAttribute)
         */
        default Builder containsAll(Consumer<DocumentAttribute.Builder> containsAll) {
            return containsAll(DocumentAttribute.builder().applyMutation(containsAll).build());
        }

        /**
         * <p>
         * Returns true when a document contains any of the specified document attributes. This filter is only
         * applicable to <code>StringListValue</code> metadata.
         * </p>
         * 
         * @param containsAny
         *        Returns true when a document contains any of the specified document attributes. This filter is only
         *        applicable to <code>StringListValue</code> metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsAny(DocumentAttribute containsAny);

        /**
         * <p>
         * Returns true when a document contains any of the specified document attributes. This filter is only
         * applicable to <code>StringListValue</code> metadata.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #containsAny(DocumentAttribute)}.
         * 
         * @param containsAny
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containsAny(DocumentAttribute)
         */
        default Builder containsAny(Consumer<DocumentAttribute.Builder> containsAny) {
            return containsAny(DocumentAttribute.builder().applyMutation(containsAny).build());
        }

        /**
         * <p>
         * Performs a greater than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * 
         * @param greaterThan
         *        Performs a greater than operation on two document attributes. Use with a document attribute of type
         *        <code>Integer</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(DocumentAttribute greaterThan);

        /**
         * <p>
         * Performs a greater than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThan(DocumentAttribute)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(DocumentAttribute)
         */
        default Builder greaterThan(Consumer<DocumentAttribute.Builder> greaterThan) {
            return greaterThan(DocumentAttribute.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * Performs a greater or equals than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * 
         * @param greaterThanOrEquals
         *        Performs a greater or equals than operation on two document attributes. Use with a document attribute
         *        of type <code>Integer</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEquals(DocumentAttribute greaterThanOrEquals);

        /**
         * <p>
         * Performs a greater or equals than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #greaterThanOrEquals(DocumentAttribute)}.
         * 
         * @param greaterThanOrEquals
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEquals(DocumentAttribute)
         */
        default Builder greaterThanOrEquals(Consumer<DocumentAttribute.Builder> greaterThanOrEquals) {
            return greaterThanOrEquals(DocumentAttribute.builder().applyMutation(greaterThanOrEquals).build());
        }

        /**
         * <p>
         * Performs a less than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * 
         * @param lessThan
         *        Performs a less than operation on two document attributes. Use with a document attribute of type
         *        <code>Integer</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(DocumentAttribute lessThan);

        /**
         * <p>
         * Performs a less than operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThan(DocumentAttribute)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(DocumentAttribute)
         */
        default Builder lessThan(Consumer<DocumentAttribute.Builder> lessThan) {
            return lessThan(DocumentAttribute.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * Performs a less than or equals operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * 
         * @param lessThanOrEquals
         *        Performs a less than or equals operation on two document attributes. Use with a document attribute of
         *        type <code>Integer</code> or <code>Long</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEquals(DocumentAttribute lessThanOrEquals);

        /**
         * <p>
         * Performs a less than or equals operation on two document attributes. Use with a document attribute of type
         * <code>Integer</code> or <code>Long</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentAttribute.Builder} avoiding the need to
         * create one manually via {@link DocumentAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #lessThanOrEquals(DocumentAttribute)}.
         * 
         * @param lessThanOrEquals
         *        a consumer that will call methods on {@link DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEquals(DocumentAttribute)
         */
        default Builder lessThanOrEquals(Consumer<DocumentAttribute.Builder> lessThanOrEquals) {
            return lessThanOrEquals(DocumentAttribute.builder().applyMutation(lessThanOrEquals).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeFilter> andAllFilters = DefaultSdkAutoConstructList.getInstance();

        private List<AttributeFilter> orAllFilters = DefaultSdkAutoConstructList.getInstance();

        private AttributeFilter notFilter;

        private DocumentAttribute equalsTo;

        private DocumentAttribute containsAll;

        private DocumentAttribute containsAny;

        private DocumentAttribute greaterThan;

        private DocumentAttribute greaterThanOrEquals;

        private DocumentAttribute lessThan;

        private DocumentAttribute lessThanOrEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeFilter model) {
            andAllFilters(model.andAllFilters);
            orAllFilters(model.orAllFilters);
            notFilter(model.notFilter);
            equalsTo(model.equalsTo);
            containsAll(model.containsAll);
            containsAny(model.containsAny);
            greaterThan(model.greaterThan);
            greaterThanOrEquals(model.greaterThanOrEquals);
            lessThan(model.lessThan);
            lessThanOrEquals(model.lessThanOrEquals);
        }

        public final Collection<Builder> getAndAllFilters() {
            if (andAllFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return andAllFilters != null ? andAllFilters.stream().map(AttributeFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder andAllFilters(Collection<AttributeFilter> andAllFilters) {
            this.andAllFilters = AttributeFilterListCopier.copy(andAllFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAllFilters(AttributeFilter... andAllFilters) {
            andAllFilters(Arrays.asList(andAllFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAllFilters(Consumer<Builder>... andAllFilters) {
            andAllFilters(Stream.of(andAllFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAndAllFilters(Collection<BuilderImpl> andAllFilters) {
            this.andAllFilters = AttributeFilterListCopier.copyFromBuilder(andAllFilters);
        }

        public final Collection<Builder> getOrAllFilters() {
            if (orAllFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return orAllFilters != null ? orAllFilters.stream().map(AttributeFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder orAllFilters(Collection<AttributeFilter> orAllFilters) {
            this.orAllFilters = AttributeFilterListCopier.copy(orAllFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAllFilters(AttributeFilter... orAllFilters) {
            orAllFilters(Arrays.asList(orAllFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAllFilters(Consumer<Builder>... orAllFilters) {
            orAllFilters(Stream.of(orAllFilters).map(c -> AttributeFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOrAllFilters(Collection<BuilderImpl> orAllFilters) {
            this.orAllFilters = AttributeFilterListCopier.copyFromBuilder(orAllFilters);
        }

        public final Builder getNotFilter() {
            return notFilter != null ? notFilter.toBuilder() : null;
        }

        @Override
        public final Builder notFilter(AttributeFilter notFilter) {
            this.notFilter = notFilter;
            return this;
        }

        public final void setNotFilter(BuilderImpl notFilter) {
            this.notFilter = notFilter != null ? notFilter.build() : null;
        }

        public final DocumentAttribute.Builder getEqualsTo() {
            return equalsTo != null ? equalsTo.toBuilder() : null;
        }

        @Override
        public final Builder equalsTo(DocumentAttribute equalsTo) {
            this.equalsTo = equalsTo;
            return this;
        }

        public final void setEqualsTo(DocumentAttribute.BuilderImpl equalsTo) {
            this.equalsTo = equalsTo != null ? equalsTo.build() : null;
        }

        public final DocumentAttribute.Builder getContainsAll() {
            return containsAll != null ? containsAll.toBuilder() : null;
        }

        @Override
        public final Builder containsAll(DocumentAttribute containsAll) {
            this.containsAll = containsAll;
            return this;
        }

        public final void setContainsAll(DocumentAttribute.BuilderImpl containsAll) {
            this.containsAll = containsAll != null ? containsAll.build() : null;
        }

        public final DocumentAttribute.Builder getContainsAny() {
            return containsAny != null ? containsAny.toBuilder() : null;
        }

        @Override
        public final Builder containsAny(DocumentAttribute containsAny) {
            this.containsAny = containsAny;
            return this;
        }

        public final void setContainsAny(DocumentAttribute.BuilderImpl containsAny) {
            this.containsAny = containsAny != null ? containsAny.build() : null;
        }

        public final DocumentAttribute.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        @Override
        public final Builder greaterThan(DocumentAttribute greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        public final void setGreaterThan(DocumentAttribute.BuilderImpl greaterThan) {
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
        }

        public final DocumentAttribute.Builder getGreaterThanOrEquals() {
            return greaterThanOrEquals != null ? greaterThanOrEquals.toBuilder() : null;
        }

        @Override
        public final Builder greaterThanOrEquals(DocumentAttribute greaterThanOrEquals) {
            this.greaterThanOrEquals = greaterThanOrEquals;
            return this;
        }

        public final void setGreaterThanOrEquals(DocumentAttribute.BuilderImpl greaterThanOrEquals) {
            this.greaterThanOrEquals = greaterThanOrEquals != null ? greaterThanOrEquals.build() : null;
        }

        public final DocumentAttribute.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        @Override
        public final Builder lessThan(DocumentAttribute lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        public final void setLessThan(DocumentAttribute.BuilderImpl lessThan) {
            this.lessThan = lessThan != null ? lessThan.build() : null;
        }

        public final DocumentAttribute.Builder getLessThanOrEquals() {
            return lessThanOrEquals != null ? lessThanOrEquals.toBuilder() : null;
        }

        @Override
        public final Builder lessThanOrEquals(DocumentAttribute lessThanOrEquals) {
            this.lessThanOrEquals = lessThanOrEquals;
            return this;
        }

        public final void setLessThanOrEquals(DocumentAttribute.BuilderImpl lessThanOrEquals) {
            this.lessThanOrEquals = lessThanOrEquals != null ? lessThanOrEquals.build() : null;
        }

        @Override
        public AttributeFilter build() {
            return new AttributeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
