/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration;
import software.amazon.awssdk.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfigurationListCopier;
import software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleState;
import software.amazon.awssdk.services.kendra.model.SalesforceKnowledgeArticleStateListCopier;
import software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceKnowledgeArticleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceKnowledgeArticleConfiguration> {
    private static final SdkField<List<String>> INCLUDED_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedStates").getter(SalesforceKnowledgeArticleConfiguration.getter(SalesforceKnowledgeArticleConfiguration::includedStatesAsStrings)).setter(SalesforceKnowledgeArticleConfiguration.setter(Builder::includedStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SalesforceStandardKnowledgeArticleTypeConfiguration> STANDARD_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardKnowledgeArticleTypeConfiguration").getter(SalesforceKnowledgeArticleConfiguration.getter(SalesforceKnowledgeArticleConfiguration::standardKnowledgeArticleTypeConfiguration)).setter(SalesforceKnowledgeArticleConfiguration.setter(Builder::standardKnowledgeArticleTypeConfiguration)).constructor(SalesforceStandardKnowledgeArticleTypeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardKnowledgeArticleTypeConfiguration").build()}).build();
    private static final SdkField<List<SalesforceCustomKnowledgeArticleTypeConfiguration>> CUSTOM_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomKnowledgeArticleTypeConfigurations").getter(SalesforceKnowledgeArticleConfiguration.getter(SalesforceKnowledgeArticleConfiguration::customKnowledgeArticleTypeConfigurations)).setter(SalesforceKnowledgeArticleConfiguration.setter(Builder::customKnowledgeArticleTypeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKnowledgeArticleTypeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SalesforceCustomKnowledgeArticleTypeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_STATES_FIELD, STANDARD_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATION_FIELD, CUSTOM_KNOWLEDGE_ARTICLE_TYPE_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> includedStates;
    private final SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration;
    private final List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations;

    private SalesforceKnowledgeArticleConfiguration(BuilderImpl builder) {
        this.includedStates = builder.includedStates;
        this.standardKnowledgeArticleTypeConfiguration = builder.standardKnowledgeArticleTypeConfiguration;
        this.customKnowledgeArticleTypeConfigurations = builder.customKnowledgeArticleTypeConfigurations;
    }

    public final List<SalesforceKnowledgeArticleState> includedStates() {
        return SalesforceKnowledgeArticleStateListCopier.copyStringToEnum(this.includedStates);
    }

    public final boolean hasIncludedStates() {
        return this.includedStates != null && !(this.includedStates instanceof SdkAutoConstructList);
    }

    public final List<String> includedStatesAsStrings() {
        return this.includedStates;
    }

    public final SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration() {
        return this.standardKnowledgeArticleTypeConfiguration;
    }

    public final boolean hasCustomKnowledgeArticleTypeConfigurations() {
        return this.customKnowledgeArticleTypeConfigurations != null && !(this.customKnowledgeArticleTypeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations() {
        return this.customKnowledgeArticleTypeConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedStates() ? this.includedStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.standardKnowledgeArticleTypeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomKnowledgeArticleTypeConfigurations() ? this.customKnowledgeArticleTypeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceKnowledgeArticleConfiguration)) {
            return false;
        }
        SalesforceKnowledgeArticleConfiguration other = (SalesforceKnowledgeArticleConfiguration)obj;
        return this.hasIncludedStates() == other.hasIncludedStates() && Objects.equals(this.includedStatesAsStrings(), other.includedStatesAsStrings()) && Objects.equals(this.standardKnowledgeArticleTypeConfiguration(), other.standardKnowledgeArticleTypeConfiguration()) && this.hasCustomKnowledgeArticleTypeConfigurations() == other.hasCustomKnowledgeArticleTypeConfigurations() && Objects.equals(this.customKnowledgeArticleTypeConfigurations(), other.customKnowledgeArticleTypeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceKnowledgeArticleConfiguration").add("IncludedStates", this.hasIncludedStates() ? this.includedStatesAsStrings() : null).add("StandardKnowledgeArticleTypeConfiguration", (Object)this.standardKnowledgeArticleTypeConfiguration()).add("CustomKnowledgeArticleTypeConfigurations", this.hasCustomKnowledgeArticleTypeConfigurations() ? this.customKnowledgeArticleTypeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IncludedStates": {
                return Optional.ofNullable(clazz.cast(this.includedStatesAsStrings()));
            }
            case "StandardKnowledgeArticleTypeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.standardKnowledgeArticleTypeConfiguration()));
            }
            case "CustomKnowledgeArticleTypeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.customKnowledgeArticleTypeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceKnowledgeArticleConfiguration, T> g) {
        return obj -> g.apply((SalesforceKnowledgeArticleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> includedStates = DefaultSdkAutoConstructList.getInstance();
        private SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration;
        private List<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceKnowledgeArticleConfiguration model) {
            this.includedStatesWithStrings(model.includedStates);
            this.standardKnowledgeArticleTypeConfiguration(model.standardKnowledgeArticleTypeConfiguration);
            this.customKnowledgeArticleTypeConfigurations(model.customKnowledgeArticleTypeConfigurations);
        }

        public final Collection<String> getIncludedStates() {
            if (this.includedStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedStates;
        }

        @Override
        public final Builder includedStatesWithStrings(Collection<String> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copy(includedStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedStatesWithStrings(String ... includedStates) {
            this.includedStatesWithStrings(Arrays.asList(includedStates));
            return this;
        }

        @Override
        public final Builder includedStates(Collection<SalesforceKnowledgeArticleState> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copyEnumToString(includedStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedStates(SalesforceKnowledgeArticleState ... includedStates) {
            this.includedStates(Arrays.asList(includedStates));
            return this;
        }

        public final void setIncludedStates(Collection<String> includedStates) {
            this.includedStates = SalesforceKnowledgeArticleStateListCopier.copy(includedStates);
        }

        public final SalesforceStandardKnowledgeArticleTypeConfiguration.Builder getStandardKnowledgeArticleTypeConfiguration() {
            return this.standardKnowledgeArticleTypeConfiguration != null ? this.standardKnowledgeArticleTypeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration standardKnowledgeArticleTypeConfiguration) {
            this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
            return this;
        }

        public final void setStandardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration.BuilderImpl standardKnowledgeArticleTypeConfiguration) {
            this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration != null ? standardKnowledgeArticleTypeConfiguration.build() : null;
        }

        public final Collection<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder> getCustomKnowledgeArticleTypeConfigurations() {
            if (this.customKnowledgeArticleTypeConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customKnowledgeArticleTypeConfigurations != null ? (Collection)this.customKnowledgeArticleTypeConfigurations.stream().map(SalesforceCustomKnowledgeArticleTypeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customKnowledgeArticleTypeConfigurations(Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations = SalesforceCustomKnowledgeArticleTypeConfigurationListCopier.copy(customKnowledgeArticleTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKnowledgeArticleTypeConfigurations(SalesforceCustomKnowledgeArticleTypeConfiguration ... customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations(Arrays.asList(customKnowledgeArticleTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customKnowledgeArticleTypeConfigurations(Consumer<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder> ... customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations(Stream.of(customKnowledgeArticleTypeConfigurations).map(c -> (SalesforceCustomKnowledgeArticleTypeConfiguration)((SalesforceCustomKnowledgeArticleTypeConfiguration.Builder)SalesforceCustomKnowledgeArticleTypeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomKnowledgeArticleTypeConfigurations(Collection<SalesforceCustomKnowledgeArticleTypeConfiguration.BuilderImpl> customKnowledgeArticleTypeConfigurations) {
            this.customKnowledgeArticleTypeConfigurations = SalesforceCustomKnowledgeArticleTypeConfigurationListCopier.copyFromBuilder(customKnowledgeArticleTypeConfigurations);
        }

        public SalesforceKnowledgeArticleConfiguration build() {
            return new SalesforceKnowledgeArticleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceKnowledgeArticleConfiguration> {
        public Builder includedStatesWithStrings(Collection<String> var1);

        public Builder includedStatesWithStrings(String ... var1);

        public Builder includedStates(Collection<SalesforceKnowledgeArticleState> var1);

        public Builder includedStates(SalesforceKnowledgeArticleState ... var1);

        public Builder standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfiguration var1);

        default public Builder standardKnowledgeArticleTypeConfiguration(Consumer<SalesforceStandardKnowledgeArticleTypeConfiguration.Builder> standardKnowledgeArticleTypeConfiguration) {
            return this.standardKnowledgeArticleTypeConfiguration((SalesforceStandardKnowledgeArticleTypeConfiguration)((SalesforceStandardKnowledgeArticleTypeConfiguration.Builder)SalesforceStandardKnowledgeArticleTypeConfiguration.builder().applyMutation(standardKnowledgeArticleTypeConfiguration)).build());
        }

        public Builder customKnowledgeArticleTypeConfigurations(Collection<SalesforceCustomKnowledgeArticleTypeConfiguration> var1);

        public Builder customKnowledgeArticleTypeConfigurations(SalesforceCustomKnowledgeArticleTypeConfiguration ... var1);

        public Builder customKnowledgeArticleTypeConfigurations(Consumer<SalesforceCustomKnowledgeArticleTypeConfiguration.Builder> ... var1);
    }
}

