/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutDocumentResponse extends KendraResponse implements
        ToCopyableBuilder<BatchPutDocumentResponse.Builder, BatchPutDocumentResponse> {
    private static final SdkField<List<BatchPutDocumentResponseFailedDocument>> FAILED_DOCUMENTS_FIELD = SdkField
            .<List<BatchPutDocumentResponseFailedDocument>> builder(MarshallingType.LIST)
            .memberName("FailedDocuments")
            .getter(getter(BatchPutDocumentResponse::failedDocuments))
            .setter(setter(Builder::failedDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutDocumentResponseFailedDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutDocumentResponseFailedDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_DOCUMENTS_FIELD));

    private final List<BatchPutDocumentResponseFailedDocument> failedDocuments;

    private BatchPutDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.failedDocuments = builder.failedDocuments;
    }

    /**
     * Returns true if the FailedDocuments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFailedDocuments() {
        return failedDocuments != null && !(failedDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of documents that were not added to the index because the document failed a validation check. Each
     * document contains an error message that indicates why the document couldn't be added to the index.
     * </p>
     * <p>
     * If there was an error adding a document to an index the error is reported in your Amazon Web Services CloudWatch
     * log. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon
     * CloudWatch Logs</a>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedDocuments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of documents that were not added to the index because the document failed a validation check. Each
     *         document contains an error message that indicates why the document couldn't be added to the index.</p>
     *         <p>
     *         If there was an error adding a document to an index the error is reported in your Amazon Web Services
     *         CloudWatch log. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with
     *         Amazon CloudWatch Logs</a>
     */
    public final List<BatchPutDocumentResponseFailedDocument> failedDocuments() {
        return failedDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedDocuments() ? failedDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentResponse)) {
            return false;
        }
        BatchPutDocumentResponse other = (BatchPutDocumentResponse) obj;
        return hasFailedDocuments() == other.hasFailedDocuments() && Objects.equals(failedDocuments(), other.failedDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutDocumentResponse")
                .add("FailedDocuments", hasFailedDocuments() ? failedDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedDocuments":
            return Optional.ofNullable(clazz.cast(failedDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentResponse, T> g) {
        return obj -> g.apply((BatchPutDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutDocumentResponse> {
        /**
         * <p>
         * A list of documents that were not added to the index because the document failed a validation check. Each
         * document contains an error message that indicates why the document couldn't be added to the index.
         * </p>
         * <p>
         * If there was an error adding a document to an index the error is reported in your Amazon Web Services
         * CloudWatch log. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon
         * CloudWatch Logs</a>
         * </p>
         * 
         * @param failedDocuments
         *        A list of documents that were not added to the index because the document failed a validation check.
         *        Each document contains an error message that indicates why the document couldn't be added to the
         *        index.</p>
         *        <p>
         *        If there was an error adding a document to an index the error is reported in your Amazon Web Services
         *        CloudWatch log. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with
         *        Amazon CloudWatch Logs</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDocuments(Collection<BatchPutDocumentResponseFailedDocument> failedDocuments);

        /**
         * <p>
         * A list of documents that were not added to the index because the document failed a validation check. Each
         * document contains an error message that indicates why the document couldn't be added to the index.
         * </p>
         * <p>
         * If there was an error adding a document to an index the error is reported in your Amazon Web Services
         * CloudWatch log. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon
         * CloudWatch Logs</a>
         * </p>
         * 
         * @param failedDocuments
         *        A list of documents that were not added to the index because the document failed a validation check.
         *        Each document contains an error message that indicates why the document couldn't be added to the
         *        index.</p>
         *        <p>
         *        If there was an error adding a document to an index the error is reported in your Amazon Web Services
         *        CloudWatch log. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with
         *        Amazon CloudWatch Logs</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedDocuments(BatchPutDocumentResponseFailedDocument... failedDocuments);

        /**
         * <p>
         * A list of documents that were not added to the index because the document failed a validation check. Each
         * document contains an error message that indicates why the document couldn't be added to the index.
         * </p>
         * <p>
         * If there was an error adding a document to an index the error is reported in your Amazon Web Services
         * CloudWatch log. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/cloudwatch-logs.html">Monitoring Amazon Kendra with Amazon
         * CloudWatch Logs</a>
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchPutDocumentResponseFailedDocument>.Builder} avoiding the need to create one manually via {@link List
         * <BatchPutDocumentResponseFailedDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPutDocumentResponseFailedDocument>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failedDocuments(List<BatchPutDocumentResponseFailedDocument>)}.
         * 
         * @param failedDocuments
         *        a consumer that will call methods on {@link List<BatchPutDocumentResponseFailedDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedDocuments(List<BatchPutDocumentResponseFailedDocument>)
         */
        Builder failedDocuments(Consumer<BatchPutDocumentResponseFailedDocument.Builder>... failedDocuments);
    }

    static final class BuilderImpl extends KendraResponse.BuilderImpl implements Builder {
        private List<BatchPutDocumentResponseFailedDocument> failedDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentResponse model) {
            super(model);
            failedDocuments(model.failedDocuments);
        }

        public final List<BatchPutDocumentResponseFailedDocument.Builder> getFailedDocuments() {
            List<BatchPutDocumentResponseFailedDocument.Builder> result = BatchPutDocumentResponseFailedDocumentsCopier
                    .copyToBuilder(this.failedDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failedDocuments(Collection<BatchPutDocumentResponseFailedDocument> failedDocuments) {
            this.failedDocuments = BatchPutDocumentResponseFailedDocumentsCopier.copy(failedDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(BatchPutDocumentResponseFailedDocument... failedDocuments) {
            failedDocuments(Arrays.asList(failedDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedDocuments(Consumer<BatchPutDocumentResponseFailedDocument.Builder>... failedDocuments) {
            failedDocuments(Stream.of(failedDocuments)
                    .map(c -> BatchPutDocumentResponseFailedDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedDocuments(Collection<BatchPutDocumentResponseFailedDocument.BuilderImpl> failedDocuments) {
            this.failedDocuments = BatchPutDocumentResponseFailedDocumentsCopier.copyFromBuilder(failedDocuments);
        }

        @Override
        public BatchPutDocumentResponse build() {
            return new BatchPutDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
