/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the attachment settings for the Confluence data source. Attachment settings are optional, if you don't
 * specify settings attachments, Amazon Kendra won't index them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluenceAttachmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluenceAttachmentConfiguration.Builder, ConfluenceAttachmentConfiguration> {
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CrawlAttachments").getter(getter(ConfluenceAttachmentConfiguration::crawlAttachments))
            .setter(setter(Builder::crawlAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()).build();

    private static final SdkField<List<ConfluenceAttachmentToIndexFieldMapping>> ATTACHMENT_FIELD_MAPPINGS_FIELD = SdkField
            .<List<ConfluenceAttachmentToIndexFieldMapping>> builder(MarshallingType.LIST)
            .memberName("AttachmentFieldMappings")
            .getter(getter(ConfluenceAttachmentConfiguration::attachmentFieldMappings))
            .setter(setter(Builder::attachmentFieldMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentFieldMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfluenceAttachmentToIndexFieldMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfluenceAttachmentToIndexFieldMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ATTACHMENTS_FIELD,
            ATTACHMENT_FIELD_MAPPINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean crawlAttachments;

    private final List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings;

    private ConfluenceAttachmentConfiguration(BuilderImpl builder) {
        this.crawlAttachments = builder.crawlAttachments;
        this.attachmentFieldMappings = builder.attachmentFieldMappings;
    }

    /**
     * <p>
     * Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
     * </p>
     * 
     * @return Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
     */
    public final Boolean crawlAttachments() {
        return crawlAttachments;
    }

    /**
     * Returns true if the AttachmentFieldMappings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttachmentFieldMappings() {
        return attachmentFieldMappings != null && !(attachmentFieldMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you must
     * first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.
     * </p>
     * <p>
     * If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachmentFieldMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you
     *         must first create an index field with a matching type using the console or the <code>UpdateIndex</code>
     *         operation.</p>
     *         <p>
     *         If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
     *         mapping.
     */
    public final List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings() {
        return attachmentFieldMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachmentFieldMappings() ? attachmentFieldMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceAttachmentConfiguration)) {
            return false;
        }
        ConfluenceAttachmentConfiguration other = (ConfluenceAttachmentConfiguration) obj;
        return Objects.equals(crawlAttachments(), other.crawlAttachments())
                && hasAttachmentFieldMappings() == other.hasAttachmentFieldMappings()
                && Objects.equals(attachmentFieldMappings(), other.attachmentFieldMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfluenceAttachmentConfiguration").add("CrawlAttachments", crawlAttachments())
                .add("AttachmentFieldMappings", hasAttachmentFieldMappings() ? attachmentFieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlAttachments":
            return Optional.ofNullable(clazz.cast(crawlAttachments()));
        case "AttachmentFieldMappings":
            return Optional.ofNullable(clazz.cast(attachmentFieldMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceAttachmentConfiguration, T> g) {
        return obj -> g.apply((ConfluenceAttachmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluenceAttachmentConfiguration> {
        /**
         * <p>
         * Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
         * </p>
         * 
         * @param crawlAttachments
         *        Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlAttachments(Boolean crawlAttachments);

        /**
         * <p>
         * Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you must
         * first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.
         * </p>
         * <p>
         * If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
         * mapping.
         * </p>
         * 
         * @param attachmentFieldMappings
         *        Defines how attachment metadata fields should be mapped to index fields. Before you can map a field,
         *        you must first create an index field with a matching type using the console or the
         *        <code>UpdateIndex</code> operation.</p>
         *        <p>
         *        If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
         *        mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentFieldMappings(Collection<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings);

        /**
         * <p>
         * Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you must
         * first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.
         * </p>
         * <p>
         * If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
         * mapping.
         * </p>
         * 
         * @param attachmentFieldMappings
         *        Defines how attachment metadata fields should be mapped to index fields. Before you can map a field,
         *        you must first create an index field with a matching type using the console or the
         *        <code>UpdateIndex</code> operation.</p>
         *        <p>
         *        If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
         *        mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentFieldMappings(ConfluenceAttachmentToIndexFieldMapping... attachmentFieldMappings);

        /**
         * <p>
         * Defines how attachment metadata fields should be mapped to index fields. Before you can map a field, you must
         * first create an index field with a matching type using the console or the <code>UpdateIndex</code> operation.
         * </p>
         * <p>
         * If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field
         * mapping.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ConfluenceAttachmentToIndexFieldMapping>.Builder} avoiding the need to create one manually via {@link List
         * <ConfluenceAttachmentToIndexFieldMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfluenceAttachmentToIndexFieldMapping>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #attachmentFieldMappings(List<ConfluenceAttachmentToIndexFieldMapping>)}.
         * 
         * @param attachmentFieldMappings
         *        a consumer that will call methods on {@link List<ConfluenceAttachmentToIndexFieldMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentFieldMappings(List<ConfluenceAttachmentToIndexFieldMapping>)
         */
        Builder attachmentFieldMappings(Consumer<ConfluenceAttachmentToIndexFieldMapping.Builder>... attachmentFieldMappings);
    }

    static final class BuilderImpl implements Builder {
        private Boolean crawlAttachments;

        private List<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceAttachmentConfiguration model) {
            crawlAttachments(model.crawlAttachments);
            attachmentFieldMappings(model.attachmentFieldMappings);
        }

        public final Boolean getCrawlAttachments() {
            return crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final List<ConfluenceAttachmentToIndexFieldMapping.Builder> getAttachmentFieldMappings() {
            List<ConfluenceAttachmentToIndexFieldMapping.Builder> result = ConfluenceAttachmentFieldMappingsListCopier
                    .copyToBuilder(this.attachmentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attachmentFieldMappings(Collection<ConfluenceAttachmentToIndexFieldMapping> attachmentFieldMappings) {
            this.attachmentFieldMappings = ConfluenceAttachmentFieldMappingsListCopier.copy(attachmentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(ConfluenceAttachmentToIndexFieldMapping... attachmentFieldMappings) {
            attachmentFieldMappings(Arrays.asList(attachmentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(
                Consumer<ConfluenceAttachmentToIndexFieldMapping.Builder>... attachmentFieldMappings) {
            attachmentFieldMappings(Stream.of(attachmentFieldMappings)
                    .map(c -> ConfluenceAttachmentToIndexFieldMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentFieldMappings(
                Collection<ConfluenceAttachmentToIndexFieldMapping.BuilderImpl> attachmentFieldMappings) {
            this.attachmentFieldMappings = ConfluenceAttachmentFieldMappingsListCopier.copyFromBuilder(attachmentFieldMappings);
        }

        @Override
        public ConfluenceAttachmentConfiguration build() {
            return new ConfluenceAttachmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
